/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.type.BooleanType;
import org.hibernate.type.Type;

public class BooleanLiteralNode
extends LiteralNode
implements ExpectedTypeAwareNode {
    private Type expectedType;

    public Type getDataType() {
        return this.expectedType == null ? Hibernate.BOOLEAN : this.expectedType;
    }

    public BooleanType getTypeInternal() {
        return (BooleanType)this.getDataType();
    }

    public Boolean getValue() {
        return this.getType() == 49 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setExpectedType(Type type) {
        this.expectedType = type;
    }

    public Type getExpectedType() {
        return this.expectedType;
    }

    public String getRenderText(SessionFactoryImplementor sessionFactoryImplementor) {
        try {
            return this.getTypeInternal().objectToSQLString(this.getValue(), sessionFactoryImplementor.getDialect());
        }
        catch (Throwable throwable) {
            throw new QueryException("Unable to render boolean literal value", throwable);
        }
    }
}

