/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class BinaryLogicOperatorNode
extends HqlSqlWalkerNode
implements BinaryOperatorNode {
    public void initialize() throws SemanticException {
        Node node = this.getLeftHandOperand();
        if (node == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        Node node2 = this.getRightHandOperand();
        if (node2 == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        Type type = this.extractDataType(node);
        Type type2 = this.extractDataType(node2);
        if (type == null) {
            type = type2;
        }
        if (type2 == null) {
            type2 = type;
        }
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)node)).getClass())) {
            ((ExpectedTypeAwareNode)((Object)node)).setExpectedType(type2);
        }
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)node2)).getClass())) {
            ((ExpectedTypeAwareNode)((Object)node2)).setExpectedType(type);
        }
        this.mutateRowValueConstructorSyntaxesIfNecessary(type, type2);
    }

    protected final void mutateRowValueConstructorSyntaxesIfNecessary(Type type, Type type2) {
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryHelper().getFactory();
        if (type != null && type2 != null) {
            int n = type.getColumnSpan(sessionFactoryImplementor);
            if (n != type2.getColumnSpan(sessionFactoryImplementor)) {
                throw new TypeMismatchException("left and right hand sides of a binary logic operator were incompatibile [" + type.getName() + " : " + type2.getName() + "]");
            }
            if (n > 1 && !sessionFactoryImplementor.getDialect().supportsRowValueConstructorSyntax()) {
                this.mutateRowValueConstructorSyntax(n);
            }
        }
    }

    private void mutateRowValueConstructorSyntax(int n) {
        int n2 = this.getType();
        String string = this.getText();
        this.setType(6);
        this.setText("AND");
        String[] stringArray = BinaryLogicOperatorNode.extractMutationTexts(this.getLeftHandOperand(), n);
        String[] stringArray2 = BinaryLogicOperatorNode.extractMutationTexts(this.getRightHandOperand(), n);
        BinaryLogicOperatorNode binaryLogicOperatorNode = this;
        for (int i = n - 1; i > 0; --i) {
            AST aST;
            AST aST2;
            AST aST3;
            AST aST4;
            if (i == 1) {
                aST4 = this.getASTFactory().create(n2, string);
                aST3 = this.getASTFactory().create(136, stringArray[0]);
                aST2 = this.getASTFactory().create(136, stringArray2[0]);
                aST4.setFirstChild(aST3);
                aST3.setNextSibling(aST2);
                binaryLogicOperatorNode.setFirstChild(aST4);
                aST = this.getASTFactory().create(n2, string);
                AST aST5 = this.getASTFactory().create(136, stringArray[1]);
                AST aST6 = this.getASTFactory().create(136, stringArray2[1]);
                aST.setFirstChild(aST5);
                aST5.setNextSibling(aST6);
                aST4.setNextSibling(aST);
                continue;
            }
            aST4 = this.getASTFactory().create(n2, string);
            aST3 = this.getASTFactory().create(136, stringArray[i]);
            aST2 = this.getASTFactory().create(136, stringArray2[i]);
            aST4.setFirstChild(aST3);
            aST3.setNextSibling(aST2);
            aST = this.getASTFactory().create(6, "AND");
            binaryLogicOperatorNode.setFirstChild(aST);
            aST.setNextSibling(aST4);
            binaryLogicOperatorNode = aST;
        }
    }

    private static String[] extractMutationTexts(Node node, int n) {
        if (node instanceof ParameterNode) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "?";
            }
            return stringArray;
        }
        if (node.getType() == 89) {
            String[] stringArray = new String[node.getNumberOfChildren()];
            int n2 = 0;
            for (AST aST = node.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
                stringArray[n2++] = aST.getText();
            }
            return stringArray;
        }
        if (node instanceof SqlNode) {
            String[] stringArray;
            String string = node.getText();
            if (string.startsWith("(")) {
                string = string.substring(1);
            }
            if (string.endsWith(")")) {
                string = string.substring(0, string.length() - 1);
            }
            if (n != (stringArray = StringHelper.split(", ", string)).length) {
                throw new HibernateException("SqlNode's text did not reference expected number of columns");
            }
            return stringArray;
        }
        throw new HibernateException("dont know how to extract row value elements from node : " + (Object)((Object)node));
    }

    protected Type extractDataType(Node node) {
        Type type = null;
        if (node instanceof SqlNode) {
            type = ((SqlNode)node).getDataType();
        }
        if (type == null && node instanceof ExpectedTypeAwareNode) {
            type = ((ExpectedTypeAwareNode)((Object)node)).getExpectedType();
        }
        return type;
    }

    public Type getDataType() {
        return Hibernate.BOOLEAN;
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }
}

