/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.Hibernate;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.type.Type;

public class BinaryArithmeticOperatorNode
extends AbstractSelectExpression
implements BinaryOperatorNode,
DisplayableNode {
    public void initialize() throws SemanticException {
        Node node = this.getLeftHandOperand();
        Node node2 = this.getRightHandOperand();
        if (node == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        if (node2 == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        Type type = node instanceof SqlNode ? ((SqlNode)node).getDataType() : null;
        Type type2 = node2 instanceof SqlNode ? ((SqlNode)node2).getDataType() : null;
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)node)).getClass()) && type2 != null) {
            Type type3 = null;
            type3 = this.isDateTimeType(type2) ? (this.getType() == 110 ? Hibernate.DOUBLE : type2) : type2;
            ((ExpectedTypeAwareNode)((Object)node)).setExpectedType(type3);
        } else if (ParameterNode.class.isAssignableFrom(((Object)((Object)node2)).getClass()) && type != null) {
            Type type4 = null;
            if (this.isDateTimeType(type)) {
                if (this.getType() == 110) {
                    type4 = Hibernate.DOUBLE;
                }
            } else {
                type4 = type;
            }
            ((ExpectedTypeAwareNode)((Object)node2)).setExpectedType(type4);
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            super.setDataType(this.resolveDataType());
        }
        return super.getDataType();
    }

    private Type resolveDataType() {
        Type type;
        Node node = this.getLeftHandOperand();
        Node node2 = this.getRightHandOperand();
        Type type2 = node instanceof SqlNode ? ((SqlNode)node).getDataType() : null;
        Type type3 = type = node2 instanceof SqlNode ? ((SqlNode)node2).getDataType() : null;
        if (this.isDateTimeType(type2) || this.isDateTimeType(type)) {
            return this.resolveDateTimeArithmeticResultType(type2, type);
        }
        if (type2 == null) {
            if (type == null) {
                return Hibernate.DOUBLE;
            }
            return type;
        }
        if (type == null) {
            return type2;
        }
        if (type2 == Hibernate.DOUBLE || type == Hibernate.DOUBLE) {
            return Hibernate.DOUBLE;
        }
        if (type2 == Hibernate.FLOAT || type == Hibernate.FLOAT) {
            return Hibernate.FLOAT;
        }
        if (type2 == Hibernate.BIG_DECIMAL || type == Hibernate.BIG_DECIMAL) {
            return Hibernate.BIG_DECIMAL;
        }
        if (type2 == Hibernate.BIG_INTEGER || type == Hibernate.BIG_INTEGER) {
            return Hibernate.BIG_INTEGER;
        }
        if (type2 == Hibernate.LONG || type == Hibernate.LONG) {
            return Hibernate.LONG;
        }
        if (type2 == Hibernate.INTEGER || type == Hibernate.INTEGER) {
            return Hibernate.INTEGER;
        }
        return type2;
    }

    private boolean isDateTimeType(Type type) {
        if (type == null) {
            return false;
        }
        return Date.class.isAssignableFrom(type.getReturnedClass()) || Calendar.class.isAssignableFrom(type.getReturnedClass());
    }

    private Type resolveDateTimeArithmeticResultType(Type type, Type type2) {
        boolean bl = this.isDateTimeType(type);
        boolean bl2 = this.isDateTimeType(type2);
        if (this.getType() == 110) {
            return bl ? type : type2;
        }
        if (this.getType() == 111) {
            if (bl && !bl2) {
                return type;
            }
            if (bl && bl2) {
                return Hibernate.DOUBLE;
            }
        }
        return null;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, n);
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }

    public String getDisplayText() {
        return "{dataType=" + this.getDataType() + "}";
    }
}

