/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.ast.tree.AssignmentSpecification;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.UpdateStatement;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Update;
import org.hibernate.util.StringHelper;

public class MultiTableUpdateExecutor
extends AbstractStatementExecutor {
    private static final Log log = LogFactory.getLog((Class)MultiTableUpdateExecutor.class);
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] updates;
    private final ParameterSpecification[][] hqlParameters;

    public MultiTableUpdateExecutor(HqlSqlWalker hqlSqlWalker) {
        super(hqlSqlWalker, log);
        if (!hqlSqlWalker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot perform multi-table updates using dialect not supporting temp tables");
        }
        UpdateStatement updateStatement = (UpdateStatement)hqlSqlWalker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        String string = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, string, updateStatement.getWhereClause());
        log.trace((Object)("Generated ID-INSERT-SELECT SQL (multi-table update) : " + this.idInsertSelect));
        String[] stringArray = this.persister.getConstraintOrderedTableNameClosure();
        String[][] stringArray2 = this.persister.getContraintOrderedTableKeyColumnClosure();
        String string2 = this.generateIdSubselect(this.persister);
        ArrayList arrayList = hqlSqlWalker.getAssignmentSpecifications();
        this.updates = new String[stringArray.length];
        this.hqlParameters = new ParameterSpecification[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            ArrayList<ParameterSpecification> arrayList2 = new ArrayList<ParameterSpecification>();
            Update update = new Update(this.getFactory().getDialect()).setTableName(stringArray[i]).setWhere("(" + StringHelper.join(", ", stringArray2[i]) + ") IN (" + string2 + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                update.setComment("bulk update");
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AssignmentSpecification assignmentSpecification = (AssignmentSpecification)iterator.next();
                if (!assignmentSpecification.affectsTable(stringArray[i])) continue;
                bl = true;
                update.appendAssignmentFragment(assignmentSpecification.getSqlAssignmentFragment());
                if (assignmentSpecification.getParameters() == null) continue;
                for (int j = 0; j < assignmentSpecification.getParameters().length; ++j) {
                    arrayList2.add(assignmentSpecification.getParameters()[j]);
                }
            }
            if (!bl) continue;
            this.updates[i] = update.toStatementString();
            this.hqlParameters[i] = arrayList2.toArray(new ParameterSpecification[0]);
        }
    }

    public Queryable getAffectedQueryable() {
        return this.persister;
    }

    public String[] getSqlStatements() {
        return this.updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.coordinateSharedCacheCleanup(sessionImplementor);
        this.createTemporaryTableIfNecessary(this.persister, sessionImplementor);
        try {
            int n;
            int n2;
            PreparedStatement preparedStatement;
            block15: {
                preparedStatement = null;
                n2 = 0;
                try {
                    try {
                        preparedStatement = sessionImplementor.getBatcher().prepareStatement(this.idInsertSelect);
                        n = this.getWalker().getNumberOfParametersInSetClause();
                        ArrayList arrayList = this.getWalker().getParameters();
                        Iterator iterator = arrayList.subList(n, arrayList.size()).iterator();
                        int n3 = 1;
                        while (iterator.hasNext()) {
                            n3 += ((ParameterSpecification)iterator.next()).bind(preparedStatement, queryParameters, sessionImplementor, n3);
                        }
                        n2 = preparedStatement.executeUpdate();
                        Object var10_13 = null;
                        if (preparedStatement == null) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        if (preparedStatement == null) throw throwable;
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                        throw throwable;
                    }
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not insert/select ids for bulk update", this.idInsertSelect);
                }
            }
            for (n = 0; n < this.updates.length; ++n) {
                if (this.updates[n] == null) continue;
                try {
                    Object var12_16;
                    try {
                        preparedStatement = sessionImplementor.getBatcher().prepareStatement(this.updates[n]);
                        if (this.hqlParameters[n] != null) {
                            int n4 = 1;
                            for (int i = 0; i < this.hqlParameters[n].length; n4 += this.hqlParameters[n][i].bind(preparedStatement, queryParameters, sessionImplementor, n4), ++i) {
                            }
                        }
                        preparedStatement.executeUpdate();
                        var12_16 = null;
                        if (preparedStatement == null) continue;
                    }
                    catch (Throwable throwable) {
                        var12_16 = null;
                        if (preparedStatement == null) throw throwable;
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                        throw throwable;
                    }
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    continue;
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "error performing bulk update", this.updates[n]);
                }
            }
            n = n2;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, sessionImplementor);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

