/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;

public class BasicExecutor
extends AbstractStatementExecutor {
    private static final Log log = LogFactory.getLog((Class)BasicExecutor.class);
    private final Queryable persister;
    private final String sql;

    public BasicExecutor(HqlSqlWalker hqlSqlWalker, Queryable queryable) {
        super(hqlSqlWalker, log);
        this.persister = queryable;
        try {
            SqlGenerator sqlGenerator = new SqlGenerator(this.getFactory());
            sqlGenerator.statement(hqlSqlWalker.getAST());
            this.sql = sqlGenerator.getSQL();
            sqlGenerator.getParseErrorHandler().throwQueryException();
        }
        catch (RecognitionException recognitionException) {
            throw QuerySyntaxException.convert(recognitionException);
        }
    }

    public String[] getSqlStatements() {
        return new String[]{this.sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int execute(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.coordinateSharedCacheCleanup(sessionImplementor);
        PreparedStatement preparedStatement = null;
        RowSelection rowSelection = queryParameters.getRowSelection();
        try {
            int n;
            block7: {
                try {
                    preparedStatement = sessionImplementor.getBatcher().prepareStatement(this.sql);
                    Iterator iterator = this.getWalker().getParameters().iterator();
                    int n2 = 1;
                    while (iterator.hasNext()) {
                        ParameterSpecification parameterSpecification = (ParameterSpecification)iterator.next();
                        n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n2);
                    }
                    if (rowSelection != null && rowSelection.getTimeout() != null) {
                        preparedStatement.setQueryTimeout(rowSelection.getTimeout());
                    }
                    n = preparedStatement.executeUpdate();
                    Object var9_10 = null;
                    if (preparedStatement == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (preparedStatement != null) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                    throw throwable;
                }
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not execute update query", this.sql);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

