/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.engine.transaction.Isolater;
import org.hibernate.event.EventSource;
import org.hibernate.hql.antlr.SqlGeneratorBase;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.util.StringHelper;

public abstract class AbstractStatementExecutor
implements StatementExecutor {
    private final Log log;
    private final HqlSqlWalker walker;

    public AbstractStatementExecutor(HqlSqlWalker hqlSqlWalker, Log log) {
        this.walker = hqlSqlWalker;
        this.log = log;
    }

    protected HqlSqlWalker getWalker() {
        return this.walker;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.walker.getSessionFactoryHelper().getFactory();
    }

    protected abstract Queryable[] getAffectedQueryables();

    protected String generateIdInsertSelect(Queryable queryable, String string, AST aST) {
        Object object;
        Select select = new Select(this.getFactory().getDialect());
        SelectFragment selectFragment = new SelectFragment().addColumns(string, queryable.getIdentifierColumnNames(), queryable.getIdentifierColumnNames());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        String string2 = queryable.getTableName();
        String string3 = queryable.fromJoinFragment(string, true, false);
        String string4 = queryable.whereJoinFragment(string, true, false);
        select.setFromClause(string2 + ' ' + string + string3);
        if (string4 == null) {
            string4 = "";
        } else if ((string4 = string4.trim()).startsWith("and")) {
            string4 = string4.substring(4);
        }
        String string5 = "";
        if (aST.getNumberOfChildren() != 0) {
            try {
                object = new SqlGenerator(this.getFactory());
                ((SqlGeneratorBase)object).whereClause(aST);
                string5 = ((SqlGenerator)object).getSQL().substring(7);
            }
            catch (RecognitionException recognitionException) {
                throw new HibernateException("Unable to generate id select for DML operation", recognitionException);
            }
            if (string4.length() > 0) {
                string4 = string4 + " and ";
            }
        }
        select.setWhereClause(string4 + string5);
        object = new InsertSelect(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            ((InsertSelect)object).setComment("insert-select for " + queryable.getEntityName() + " ids");
        }
        ((InsertSelect)object).setTableName(queryable.getTemporaryIdTableName());
        ((InsertSelect)object).setSelect(select);
        return ((InsertSelect)object).toStatementString();
    }

    protected String generateIdSubselect(Queryable queryable) {
        return "select " + StringHelper.join(", ", queryable.getIdentifierColumnNames()) + " from " + queryable.getTemporaryIdTableName();
    }

    protected void createTemporaryTableIfNecessary(final Queryable queryable, SessionImplementor sessionImplementor) {
        IsolatedWork isolatedWork = new IsolatedWork(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void doWork(Connection connection) throws HibernateException {
                Statement statement = null;
                statement = connection.createStatement();
                statement.executeUpdate(queryable.getTemporaryIdTableDDL());
                Object var5_3 = null;
                if (statement == null) return;
                try {
                    statement.close();
                    return;
                }
                catch (Throwable throwable) {}
                return;
                {
                    catch (Throwable throwable) {
                        AbstractStatementExecutor.this.log.debug((Object)("unable to create temporary id table [" + throwable.getMessage() + "]"));
                        Object var5_4 = null;
                        if (statement == null) return;
                        try {
                            statement.close();
                            return;
                        }
                        catch (Throwable throwable2) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (statement == null) throw throwable;
                    try {
                        statement.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        };
        if (this.shouldIsolateTemporaryTableDDL()) {
            if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                Isolater.doIsolatedWork(isolatedWork, sessionImplementor);
            } else {
                Isolater.doNonTransactedWork(isolatedWork, sessionImplementor);
            }
        } else {
            isolatedWork.doWork(sessionImplementor.getJDBCContext().getConnectionManager().getConnection());
            sessionImplementor.getJDBCContext().getConnectionManager().afterStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dropTemporaryTableIfNecessary(final Queryable queryable, SessionImplementor sessionImplementor) {
        PreparedStatement preparedStatement;
        if (this.getFactory().getDialect().dropTemporaryTableAfterUse()) {
            IsolatedWork isolatedWork = new IsolatedWork(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void doWork(Connection connection) throws HibernateException {
                    Statement statement = null;
                    statement = connection.createStatement();
                    statement.executeUpdate("drop table " + queryable.getTemporaryIdTableName());
                    Object var5_3 = null;
                    if (statement == null) return;
                    try {
                        statement.close();
                        return;
                    }
                    catch (Throwable throwable) {}
                    return;
                    {
                        catch (Throwable throwable) {
                            AbstractStatementExecutor.this.log.warn((Object)("unable to drop temporary id table after use [" + throwable.getMessage() + "]"));
                            Object var5_4 = null;
                            if (statement == null) return;
                            try {
                                statement.close();
                                return;
                            }
                            catch (Throwable throwable2) {}
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (statement == null) throw throwable;
                        try {
                            statement.close();
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            };
            if (this.shouldIsolateTemporaryTableDDL()) {
                if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                    Isolater.doIsolatedWork(isolatedWork, sessionImplementor);
                    return;
                } else {
                    Isolater.doNonTransactedWork(isolatedWork, sessionImplementor);
                }
                return;
            } else {
                isolatedWork.doWork(sessionImplementor.getJDBCContext().getConnectionManager().getConnection());
                sessionImplementor.getJDBCContext().getConnectionManager().afterStatement();
            }
            return;
        } else {
            preparedStatement = null;
            preparedStatement = sessionImplementor.getBatcher().prepareStatement("delete from " + queryable.getTemporaryIdTableName());
            preparedStatement.executeUpdate();
            Object var6_5 = null;
            if (preparedStatement == null) return;
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                return;
            }
            catch (Throwable throwable) {}
        }
        return;
        {
            catch (Throwable throwable) {
                this.log.warn((Object)("unable to cleanup temporary id table after use [" + throwable + "]"));
                Object var6_6 = null;
                if (preparedStatement == null) return;
                try {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    return;
                }
                catch (Throwable throwable2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (preparedStatement == null) throw throwable;
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                throw throwable;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor sessionImplementor) {
        BulkOperationCleanupAction bulkOperationCleanupAction = new BulkOperationCleanupAction(sessionImplementor, this.getAffectedQueryables());
        bulkOperationCleanupAction.init();
        if (sessionImplementor.isEventSource()) {
            ((EventSource)sessionImplementor).getActionQueue().addAction(bulkOperationCleanupAction);
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL() {
        Boolean bl = this.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (bl != null) {
            return bl;
        }
        return this.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }
}

