/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ANTLRException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.ParameterTranslations;
import org.hibernate.hql.QueryExecutionRequestException;
import org.hibernate.hql.antlr.HqlTokenTypes;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.ParameterTranslationsImpl;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.BasicExecutor;
import org.hibernate.hql.ast.exec.MultiTableDeleteExecutor;
import org.hibernate.hql.ast.exec.MultiTableUpdateExecutor;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.InsertStatement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.Statement;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.NodeTraverser;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.Type;
import org.hibernate.util.IdentitySet;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class QueryTranslatorImpl
implements FilterTranslator {
    private static final Log log = LogFactory.getLog((Class)QueryTranslatorImpl.class);
    private static final Log AST_LOG = LogFactory.getLog((String)"org.hibernate.hql.ast.AST");
    private SessionFactoryImplementor factory;
    private final String queryIdentifier;
    private String hql;
    private boolean shallowQuery;
    private Map tokenReplacements;
    private Map enabledFilters;
    private boolean compiled;
    private QueryLoader queryLoader;
    private StatementExecutor statementExecutor;
    private Statement sqlAst;
    private String sql;
    private ParameterTranslations paramTranslations;

    public QueryTranslatorImpl(String string, String string2, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        this.queryIdentifier = string;
        this.hql = string2;
        this.compiled = false;
        this.shallowQuery = false;
        this.enabledFilters = map;
        this.factory = sessionFactoryImplementor;
    }

    public void compile(Map map, boolean bl) throws QueryException, MappingException {
        this.doCompile(map, bl, null);
    }

    public void compile(String string, Map map, boolean bl) throws QueryException, MappingException {
        this.doCompile(map, bl, string);
    }

    private synchronized void doCompile(Map map, boolean bl, String string) {
        if (this.compiled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"compile() : The query is already compiled, skipping...");
            }
            return;
        }
        this.tokenReplacements = map;
        if (this.tokenReplacements == null) {
            this.tokenReplacements = new HashMap();
        }
        this.shallowQuery = bl;
        try {
            HqlParser hqlParser = this.parse(true);
            HqlSqlWalker hqlSqlWalker = this.analyze(hqlParser, string);
            this.sqlAst = (Statement)hqlSqlWalker.getAST();
            if (this.sqlAst.needsExecutor()) {
                this.statementExecutor = this.buildAppropriateStatementExecutor(hqlSqlWalker);
            } else {
                this.generate((AST)((QueryNode)this.sqlAst));
                this.queryLoader = new QueryLoader(this, this.factory, hqlSqlWalker.getSelectClause());
            }
            this.compiled = true;
        }
        catch (QueryException queryException) {
            queryException.setQueryString(this.hql);
            throw queryException;
        }
        catch (RecognitionException recognitionException) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"converted antlr.RecognitionException", (Throwable)recognitionException);
            }
            throw QuerySyntaxException.convert(recognitionException, this.hql);
        }
        catch (ANTLRException aNTLRException) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"converted antlr.ANTLRException", (Throwable)aNTLRException);
            }
            throw new QueryException(aNTLRException.getMessage(), this.hql);
        }
        this.enabledFilters = null;
    }

    private void generate(AST aST) throws QueryException, RecognitionException {
        if (this.sql == null) {
            SqlGenerator sqlGenerator = new SqlGenerator(this.factory);
            sqlGenerator.statement(aST);
            this.sql = sqlGenerator.getSQL();
            if (log.isDebugEnabled()) {
                log.debug((Object)("HQL: " + this.hql));
                log.debug((Object)("SQL: " + this.sql));
            }
            sqlGenerator.getParseErrorHandler().throwQueryException();
        }
    }

    private HqlSqlWalker analyze(HqlParser hqlParser, String string) throws QueryException, RecognitionException {
        HqlSqlWalker hqlSqlWalker = new HqlSqlWalker(this, this.factory, hqlParser, this.tokenReplacements, string);
        AST aST = hqlParser.getAST();
        hqlSqlWalker.statement(aST);
        if (AST_LOG.isDebugEnabled()) {
            ASTPrinter aSTPrinter = new ASTPrinter(SqlTokenTypes.class);
            AST_LOG.debug((Object)aSTPrinter.showAsString(hqlSqlWalker.getAST(), "--- SQL AST ---"));
        }
        hqlSqlWalker.getParseErrorHandler().throwQueryException();
        return hqlSqlWalker;
    }

    private HqlParser parse(boolean bl) throws TokenStreamException, RecognitionException {
        HqlParser hqlParser = HqlParser.getInstance(this.hql);
        hqlParser.setFilter(bl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse() - HQL: " + this.hql));
        }
        hqlParser.statement();
        AST aST = hqlParser.getAST();
        JavaConstantConverter javaConstantConverter = new JavaConstantConverter();
        NodeTraverser nodeTraverser = new NodeTraverser(javaConstantConverter);
        nodeTraverser.traverseDepthFirst(aST);
        this.showHqlAst(aST);
        hqlParser.getParseErrorHandler().throwQueryException();
        return hqlParser;
    }

    void showHqlAst(AST aST) {
        if (AST_LOG.isDebugEnabled()) {
            ASTPrinter aSTPrinter = new ASTPrinter(HqlTokenTypes.class);
            aSTPrinter.setShowClassNames(false);
            AST_LOG.debug((Object)aSTPrinter.showAsString(aST, "--- HQL AST ---"));
        }
    }

    private void errorIfDML() throws HibernateException {
        if (this.sqlAst.needsExecutor()) {
            throw new QueryExecutionRequestException("Not supported for DML operations", this.hql);
        }
    }

    private void errorIfSelect() throws HibernateException {
        if (!this.sqlAst.needsExecutor()) {
            throw new QueryExecutionRequestException("Not supported for select queries", this.hql);
        }
    }

    public String getQueryIdentifier() {
        return this.queryIdentifier;
    }

    public Statement getSqlAST() {
        return this.sqlAst;
    }

    private HqlSqlWalker getWalker() {
        return this.sqlAst.getWalker();
    }

    public Type[] getReturnTypes() {
        this.errorIfDML();
        return this.getWalker().getReturnTypes();
    }

    public String[] getReturnAliases() {
        this.errorIfDML();
        return this.getWalker().getReturnAliases();
    }

    public String[][] getColumnNames() {
        this.errorIfDML();
        return this.getWalker().getSelectClause().getColumnNames();
    }

    public Set getQuerySpaces() {
        return this.getWalker().getQuerySpaces();
    }

    public List list(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        QueryParameters queryParameters2;
        ArrayList arrayList;
        boolean bl;
        this.errorIfDML();
        QueryNode queryNode = (QueryNode)this.sqlAst;
        boolean bl2 = queryParameters.getRowSelection() != null && queryParameters.getRowSelection().definesLimits();
        boolean bl3 = bl = (queryNode.getSelectClause().isDistinct() || bl2) && this.containsCollectionFetches();
        if (bl2 && this.containsCollectionFetches()) {
            log.warn((Object)"firstResult/maxResults specified with collection fetch; applying in memory!");
            arrayList = new RowSelection();
            ((RowSelection)((Object)arrayList)).setFetchSize(queryParameters.getRowSelection().getFetchSize());
            ((RowSelection)((Object)arrayList)).setTimeout(queryParameters.getRowSelection().getTimeout());
            queryParameters2 = queryParameters.createCopyUsing((RowSelection)((Object)arrayList));
        } else {
            queryParameters2 = queryParameters;
        }
        arrayList = this.queryLoader.list(sessionImplementor, queryParameters2);
        if (bl) {
            int n = -1;
            int n2 = !bl2 || queryParameters.getRowSelection().getFirstRow() == null ? 0 : queryParameters.getRowSelection().getFirstRow();
            int n3 = !bl2 || queryParameters.getRowSelection().getMaxRows() == null ? -1 : queryParameters.getRowSelection().getMaxRows();
            int n4 = arrayList.size();
            ArrayList arrayList2 = new ArrayList();
            IdentitySet identitySet = new IdentitySet();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList.get(i);
                if (!identitySet.add(e) || ++n < n2) continue;
                arrayList2.add(e);
                if (n3 >= 0 && n - n2 >= n3 - 1) break;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public Iterator iterate(QueryParameters queryParameters, EventSource eventSource) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.iterate(queryParameters, eventSource);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.scroll(queryParameters, sessionImplementor);
    }

    public int executeUpdate(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.errorIfSelect();
        return this.statementExecutor.execute(queryParameters, sessionImplementor);
    }

    public String getSQLString() {
        return this.sql;
    }

    public List collectSqlStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isManipulationStatement()) {
            String[] stringArray = this.statementExecutor.getSqlStatements();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        } else {
            arrayList.add(this.sql);
        }
        return arrayList;
    }

    public boolean isShallowQuery() {
        return this.shallowQuery;
    }

    public String getQueryString() {
        return this.hql;
    }

    public Map getEnabledFilters() {
        return this.enabledFilters;
    }

    public int[] getNamedParameterLocs(String string) {
        return this.getWalker().getNamedParameterLocations(string);
    }

    public boolean containsCollectionFetches() {
        this.errorIfDML();
        List list = ((QueryNode)this.sqlAst).getFromClause().getCollectionFetches();
        return list != null && list.size() > 0;
    }

    public boolean isManipulationStatement() {
        return this.sqlAst.needsExecutor();
    }

    public void validateScrollability() throws HibernateException {
        FromElement fromElement;
        this.errorIfDML();
        QueryNode queryNode = (QueryNode)this.sqlAst;
        List list = queryNode.getFromClause().getCollectionFetches();
        if (list.isEmpty()) {
            return;
        }
        if (this.isShallowQuery()) {
            return;
        }
        if (this.getReturnTypes().length > 1) {
            throw new HibernateException("cannot scroll with collection fetches and returned tuples");
        }
        FromElement fromElement2 = null;
        Iterator iterator = queryNode.getSelectClause().getFromElementsForLoad().iterator();
        while (iterator.hasNext()) {
            fromElement = (FromElement)iterator.next();
            if (fromElement.getOrigin() != null) continue;
            fromElement2 = fromElement;
            break;
        }
        if (fromElement2 == null) {
            throw new HibernateException("unable to locate collection fetch(es) owner for scrollability checks");
        }
        fromElement = queryNode.getOrderByClause().getFirstChild();
        if (fromElement != null) {
            String[] stringArray = fromElement2.getQueryable().getIdentifierColumnNames();
            String string = StringHelper.join(", ", StringHelper.qualify(fromElement2.getTableAlias(), stringArray));
            if (!fromElement.getText().startsWith(string)) {
                throw new HibernateException("cannot scroll results with collection fetches which are not ordered primarily by the root entity's PK");
            }
        }
    }

    private StatementExecutor buildAppropriateStatementExecutor(HqlSqlWalker hqlSqlWalker) {
        Statement statement = (Statement)hqlSqlWalker.getAST();
        if (hqlSqlWalker.getStatementType() == 13) {
            FromElement fromElement = hqlSqlWalker.getFinalFromClause().getFromElement();
            Queryable queryable = fromElement.getQueryable();
            if (queryable.isMultiTable()) {
                return new MultiTableDeleteExecutor(hqlSqlWalker);
            }
            return new BasicExecutor(hqlSqlWalker, queryable);
        }
        if (hqlSqlWalker.getStatementType() == 51) {
            FromElement fromElement = hqlSqlWalker.getFinalFromClause().getFromElement();
            Queryable queryable = fromElement.getQueryable();
            if (queryable.isMultiTable()) {
                return new MultiTableUpdateExecutor(hqlSqlWalker);
            }
            return new BasicExecutor(hqlSqlWalker, queryable);
        }
        if (hqlSqlWalker.getStatementType() == 29) {
            return new BasicExecutor(hqlSqlWalker, ((InsertStatement)statement).getIntoClause().getQueryable());
        }
        throw new QueryException("Unexpected statement type");
    }

    public ParameterTranslations getParameterTranslations() {
        if (this.paramTranslations == null) {
            this.paramTranslations = new ParameterTranslationsImpl(this.getWalker().getParameters());
        }
        return this.paramTranslations;
    }

    public static class JavaConstantConverter
    implements NodeTraverser.VisitationStrategy {
        private AST dotRoot;

        public void visit(AST aST) {
            if (this.dotRoot != null) {
                if (ASTUtil.isSubtreeChild(this.dotRoot, aST)) {
                    return;
                }
                this.dotRoot = null;
            }
            if (this.dotRoot == null && aST.getType() == 15) {
                this.dotRoot = aST;
                this.handleDotStructure(this.dotRoot);
            }
        }

        private void handleDotStructure(AST aST) {
            String string = ASTUtil.getPathText(aST);
            Object object = ReflectHelper.getConstantValue(string);
            if (object != null) {
                aST.setFirstChild(null);
                aST.setType(95);
                aST.setText(string);
            }
        }
    }
}

