/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTPair;
import antlr.MismatchedTokenException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.hql.antlr.HqlBaseParser;
import org.hibernate.hql.antlr.HqlTokenTypes;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.HqlASTFactory;
import org.hibernate.hql.ast.HqlLexer;
import org.hibernate.hql.ast.HqlToken;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;

public final class HqlParser
extends HqlBaseParser {
    private static final Log log = LogFactory.getLog((Class)HqlParser.class);
    private ParseErrorHandler parseErrorHandler;
    private ASTPrinter printer = HqlParser.getASTPrinter();

    private static ASTPrinter getASTPrinter() {
        return new ASTPrinter(HqlTokenTypes.class);
    }

    public static HqlParser getInstance(String string) {
        HqlLexer hqlLexer = new HqlLexer(new StringReader(string));
        return new HqlParser(hqlLexer);
    }

    private HqlParser(TokenStream tokenStream) {
        super(tokenStream);
        this.initialize();
    }

    public void reportError(RecognitionException recognitionException) {
        this.parseErrorHandler.reportError(recognitionException);
    }

    public void reportError(String string) {
        this.parseErrorHandler.reportError(string);
    }

    public void reportWarning(String string) {
        this.parseErrorHandler.reportWarning(string);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public AST handleIdentifierError(Token token, RecognitionException recognitionException) throws RecognitionException, TokenStreamException {
        HqlToken hqlToken;
        if (token instanceof HqlToken && (hqlToken = (HqlToken)token).isPossibleID() && recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            if (mismatchedTokenException.expecting == 120) {
                this.reportWarning("Keyword  '" + token.getText() + "' is being interpreted as an identifier due to: " + mismatchedTokenException.getMessage());
                ASTPair aSTPair = new ASTPair();
                token.setType(90);
                this.astFactory.addASTChild(aSTPair, this.astFactory.create(token));
                this.consume();
                AST aST = aSTPair.root;
                return aST;
            }
        }
        return super.handleIdentifierError(token, recognitionException);
    }

    public AST negateNode(AST aST) {
        switch (aST.getType()) {
            case 40: {
                aST.setType(6);
                aST.setText("{and}");
                this.negateNode(aST.getFirstChild());
                this.negateNode(aST.getFirstChild().getNextSibling());
                return aST;
            }
            case 6: {
                aST.setType(40);
                aST.setText("{or}");
                this.negateNode(aST.getFirstChild());
                this.negateNode(aST.getFirstChild().getNextSibling());
                return aST;
            }
            case 97: {
                aST.setType(103);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 103: {
                aST.setType(97);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 106: {
                aST.setType(107);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 105: {
                aST.setType(108);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 108: {
                aST.setType(105);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 107: {
                aST.setType(106);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 34: {
                aST.setType(81);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 81: {
                aST.setType(34);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 26: {
                aST.setType(80);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 80: {
                aST.setType(26);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 77: {
                aST.setType(76);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 76: {
                aST.setType(77);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 10: {
                aST.setType(79);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 79: {
                aST.setType(10);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
        }
        return super.negateNode(aST);
    }

    public AST processEqualityExpression(AST aST) {
        if (aST == null) {
            log.warn((Object)"processEqualityExpression() : No expression to process!");
            return null;
        }
        int n = aST.getType();
        if (n == 97 || n == 103) {
            boolean bl;
            boolean bl2 = bl = n == 103;
            if (aST.getNumberOfChildren() == 2) {
                AST aST2 = aST.getFirstChild();
                AST aST3 = aST2.getNextSibling();
                if (aST2.getType() == 39 && aST3.getType() != 39) {
                    return this.createIsNullParent(aST3, bl);
                }
                if (aST3.getType() == 39 && aST2.getType() != 39) {
                    return this.createIsNullParent(aST2, bl);
                }
                if (aST3.getType() == 62) {
                    return this.processIsEmpty(aST2, bl);
                }
                return aST;
            }
            return aST;
        }
        return aST;
    }

    private AST createIsNullParent(AST aST, boolean bl) {
        aST.setNextSibling(null);
        int n = bl ? 76 : 77;
        String string = bl ? "is not null" : "is null";
        return ASTUtil.createParent(this.astFactory, n, string, aST);
    }

    private AST processIsEmpty(AST aST, boolean bl) {
        aST.setNextSibling(null);
        AST aST2 = this.createSubquery(aST);
        aST2 = ASTUtil.createParent(this.astFactory, 19, "exists", aST2);
        if (!bl) {
            aST2 = ASTUtil.createParent(this.astFactory, 38, "not", aST2);
        }
        return aST2;
    }

    private AST createSubquery(AST aST) {
        AST aST2 = ASTUtil.createParent(this.astFactory, 84, "RANGE", aST);
        aST2 = ASTUtil.createParent(this.astFactory, 22, "from", aST2);
        aST2 = ASTUtil.createParent(this.astFactory, 86, "SELECT_FROM", aST2);
        aST2 = ASTUtil.createParent(this.astFactory, 83, "QUERY", aST2);
        return aST2;
    }

    public void showAst(AST aST, PrintStream printStream) {
        this.showAst(aST, new PrintWriter(printStream));
    }

    private void showAst(AST aST, PrintWriter printWriter) {
        this.printer.showAst(aST, printWriter);
    }

    private void initialize() {
        this.parseErrorHandler = new ErrorCounter();
        this.setASTFactory(new HqlASTFactory());
    }

    public void weakKeywords() throws TokenStreamException {
        int n = this.LA(1);
        switch (n) {
            case 24: 
            case 41: {
                if (this.LA(2) == 100) break;
                this.LT(1).setType(120);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("weakKeywords() : new LT(1) token - " + this.LT(1)));
                break;
            }
            default: {
                HqlToken hqlToken;
                if (this.LA(0) != 22 || n == 120 || this.LA(2) != 15 || !(hqlToken = (HqlToken)this.LT(1)).isPossibleID()) break;
                hqlToken.setType(120);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("weakKeywords() : new LT(1) token - " + this.LT(1)));
            }
        }
    }

    public void handleDotIdent() throws TokenStreamException {
        HqlToken hqlToken;
        if (this.LA(1) == 15 && this.LA(2) != 120 && (hqlToken = (HqlToken)this.LT(2)).isPossibleID()) {
            this.LT(2).setType(120);
            if (log.isDebugEnabled()) {
                log.debug((Object)("handleDotIdent() : new LT(2) token - " + this.LT(1)));
            }
        }
    }

    public void processMemberOf(Token token, AST aST, ASTPair aSTPair) {
        AST aST2 = token == null ? this.astFactory.create(26, "in") : this.astFactory.create(80, "not in");
        this.astFactory.makeASTRoot(aSTPair, aST2);
        AST aST3 = this.createSubquery(aST);
        aST3 = ASTUtil.createParent(this.astFactory, 74, "inList", aST3);
        aST2.addChild(aST3);
    }

    public static void panic() {
        throw new QueryException("Parser: panic");
    }
}

