/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.antlr;

import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import antlr.collections.impl.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;

public class HqlSqlBaseWalker
extends TreeParser
implements HqlSqlTokenTypes {
    private static Log log = LogFactory.getLog((Class)HqlSqlBaseWalker.class);
    private int level = 0;
    private boolean inSelect = false;
    private boolean inFunctionCall = false;
    private boolean inCase = false;
    private boolean inFrom = false;
    private int statementType;
    private String statementTypeName;
    private int currentClauseType;
    private int currentTopLevelClauseType;
    private int currentStatementType;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"all\"", "\"any\"", "\"and\"", "\"as\"", "\"asc\"", "\"avg\"", "\"between\"", "\"class\"", "\"count\"", "\"delete\"", "\"desc\"", "DOT", "\"distinct\"", "\"elements\"", "\"escape\"", "\"exists\"", "\"false\"", "\"fetch\"", "\"from\"", "\"full\"", "\"group\"", "\"having\"", "\"in\"", "\"indices\"", "\"inner\"", "\"insert\"", "\"into\"", "\"is\"", "\"join\"", "\"left\"", "\"like\"", "\"max\"", "\"min\"", "\"new\"", "\"not\"", "\"null\"", "\"or\"", "\"order\"", "\"outer\"", "\"properties\"", "\"right\"", "\"select\"", "\"set\"", "\"some\"", "\"sum\"", "\"true\"", "\"union\"", "\"update\"", "\"versioned\"", "\"where\"", "\"case\"", "\"end\"", "\"else\"", "\"then\"", "\"when\"", "\"on\"", "\"with\"", "\"both\"", "\"empty\"", "\"leading\"", "\"member\"", "\"object\"", "\"of\"", "\"trailing\"", "AGGREGATE", "ALIAS", "CONSTRUCTOR", "CASE2", "EXPR_LIST", "FILTER_ENTITY", "IN_LIST", "INDEX_OP", "IS_NOT_NULL", "IS_NULL", "METHOD_CALL", "NOT_BETWEEN", "NOT_IN", "NOT_LIKE", "ORDER_ELEMENT", "QUERY", "RANGE", "ROW_STAR", "SELECT_FROM", "UNARY_MINUS", "UNARY_PLUS", "VECTOR_EXPR", "WEIRD_IDENT", "CONSTANT", "NUM_DOUBLE", "NUM_FLOAT", "NUM_LONG", "JAVA_CONSTANT", "COMMA", "EQ", "OPEN", "CLOSE", "\"by\"", "\"ascending\"", "\"descending\"", "NE", "SQL_NE", "LT", "GT", "LE", "GE", "CONCAT", "PLUS", "MINUS", "STAR", "DIV", "OPEN_BRACKET", "CLOSE_BRACKET", "COLON", "PARAM", "NUM_INT", "QUOTED_STRING", "IDENT", "ID_START_LETTER", "ID_LETTER", "ESCqs", "WS", "HEX_DIGIT", "EXPONENT", "FLOAT_SUFFIX", "FROM_FRAGMENT", "IMPLIED_FROM", "JOIN_FRAGMENT", "SELECT_CLAUSE", "LEFT_OUTER", "RIGHT_OUTER", "ALIAS_REF", "PROPERTY_REF", "SQL_TOKEN", "SELECT_COLUMNS", "SELECT_EXPR", "THETA_JOINS", "FILTERS", "METHOD_NAME", "NAMED_PARAM", "BOGUS"};
    public static final BitSet _tokenSet_0 = new BitSet(HqlSqlBaseWalker.mk_tokenSet_0());

    public final boolean isSubQuery() {
        return this.level > 1;
    }

    public final boolean isInFrom() {
        return this.inFrom;
    }

    public final boolean isInFunctionCall() {
        return this.inFunctionCall;
    }

    public final boolean isInSelect() {
        return this.inSelect;
    }

    public final boolean isInCase() {
        return this.inCase;
    }

    public final int getStatementType() {
        return this.statementType;
    }

    public final int getCurrentClauseType() {
        return this.currentClauseType;
    }

    public final int getCurrentTopLevelClauseType() {
        return this.currentTopLevelClauseType;
    }

    public final int getCurrentStatementType() {
        return this.currentStatementType;
    }

    public final boolean isComparativeExpressionClause() {
        return this.getCurrentClauseType() == 53 || this.getCurrentClauseType() == 60 || this.isInCase();
    }

    public final boolean isSelectStatement() {
        return this.statementType == 45;
    }

    private void beforeStatement(String string, int n) {
        this.inFunctionCall = false;
        ++this.level;
        if (this.level == 1) {
            this.statementTypeName = string;
            this.statementType = n;
        }
        this.currentStatementType = n;
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " << begin [level=" + this.level + ", statement=" + this.statementTypeName + "]"));
        }
    }

    private void beforeStatementCompletion(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " : finishing up [level=" + this.level + ", statement=" + this.statementTypeName + "]"));
        }
    }

    private void afterStatementCompletion(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " >> end [level=" + this.level + ", statement=" + this.statementTypeName + "]"));
        }
        --this.level;
    }

    private void handleClauseStart(int n) {
        this.currentClauseType = n;
        if (this.level == 1) {
            this.currentTopLevelClauseType = n;
        }
    }

    protected void evaluateAssignment(AST aST) throws SemanticException {
    }

    protected void prepareFromClauseInputTree(AST aST) {
    }

    protected void pushFromClause(AST aST, AST aST2) {
    }

    protected AST createFromElement(String string, AST aST, AST aST2) throws SemanticException {
        return null;
    }

    protected void createFromJoinElement(AST aST, AST aST2, int n, AST aST3, AST aST4, AST aST5) throws SemanticException {
    }

    protected AST createFromFilterElement(AST aST, AST aST2) throws SemanticException {
        return null;
    }

    protected void processQuery(AST aST, AST aST2) throws SemanticException {
    }

    protected void postProcessUpdate(AST aST) throws SemanticException {
    }

    protected void postProcessDelete(AST aST) throws SemanticException {
    }

    protected void postProcessInsert(AST aST) throws SemanticException {
    }

    protected void beforeSelectClause() throws SemanticException {
    }

    protected void processIndex(AST aST) throws SemanticException {
    }

    protected void processConstant(AST aST) throws SemanticException {
    }

    protected void processBoolean(AST aST) throws SemanticException {
    }

    protected void processNumericLiteral(AST aST) throws SemanticException {
    }

    protected void resolve(AST aST) throws SemanticException {
    }

    protected void resolveSelectExpression(AST aST) throws SemanticException {
    }

    protected void processFunction(AST aST, boolean bl) throws SemanticException {
    }

    protected void processConstructor(AST aST) throws SemanticException {
    }

    protected AST generateNamedParameter(AST aST, AST aST2) throws SemanticException {
        return this.astFactory.make(new ASTArray(1).add(this.astFactory.create(142, aST2.getText())));
    }

    protected AST generatePositionalParameter(AST aST) throws SemanticException {
        return this.astFactory.make(new ASTArray(1).add(this.astFactory.create(117, "?")));
    }

    protected void lookupAlias(AST aST) throws SemanticException {
    }

    protected void setAlias(AST aST, AST aST2) {
    }

    protected AST lookupProperty(AST aST, boolean bl, boolean bl2) throws SemanticException {
        return aST;
    }

    protected boolean isNonQualifiedPropertyRef(AST aST) {
        return false;
    }

    protected AST lookupNonQualifiedProperty(AST aST) throws SemanticException {
        return aST;
    }

    protected void setImpliedJoinType(int n) {
    }

    protected AST createIntoClause(String string, AST aST) throws SemanticException {
        return null;
    }

    protected void prepareVersioned(AST aST, AST aST2) throws SemanticException {
    }

    protected void prepareLogicOperator(AST aST) throws SemanticException {
    }

    protected void prepareArithmeticOperator(AST aST) throws SemanticException {
    }

    public HqlSqlBaseWalker() {
        this.tokenNames = _tokenNames;
    }

    public final void statement(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 83: {
                        this.selectStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 51: {
                        this.updateStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 13: {
                        this.deleteStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 29: {
                        this.insertStatement(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectStatement(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.query(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void updateStatement(AST aST) throws RecognitionException {
        AST aST2;
        block12: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            try {
                AST aST14 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var16_17 = null;
                aST5 = this.astFactory.create(aST4);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 51);
                aST = aST.getFirstChild();
                this.beforeStatement("update", 51);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 52: {
                        aST6 = aST;
                        Object var18_19 = null;
                        aST7 = this.astFactory.create(aST6);
                        this.match(aST, 52);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 22: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST9 = aST == ASTNULL ? null : aST;
                this.fromClause(aST);
                aST = this._retTree;
                aST8 = this.returnAST;
                aST11 = aST == ASTNULL ? null : aST;
                this.setClause(aST);
                aST = this._retTree;
                aST10 = this.returnAST;
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 53: {
                        aST13 = aST == ASTNULL ? null : aST;
                        this.whereClause(aST);
                        aST = this._retTree;
                        aST12 = this.returnAST;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST14;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aST2 = this.astFactory.make(new ASTArray(4).add(aST5).add(aST8).add(aST10).add(aST12));
                this.beforeStatementCompletion("update");
                this.prepareVersioned(aST2, aST7);
                this.postProcessUpdate(aST2);
                this.afterStatementCompletion("update");
                aSTPair.root = aST2;
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block12;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void deleteStatement(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 13);
                aST = aST.getFirstChild();
                this.beforeStatement("delete", 13);
                this.fromClause(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 53: {
                        this.whereClause(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                this.beforeStatementCompletion("delete");
                this.postProcessDelete(aST2);
                this.afterStatementCompletion("delete");
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void insertStatement(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 29);
                aST = aST.getFirstChild();
                this.beforeStatement("insert", 29);
                this.intoClause(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.query(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                this.beforeStatementCompletion("insert");
                this.postProcessInsert(aST2);
                this.afterStatementCompletion("insert");
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void query(AST aST) throws RecognitionException {
        AST aST2;
        block22: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            try {
                AST aST14 = aST;
                AST aST15 = null;
                AST aST16 = null;
                aST15 = this.astFactory.create(aST);
                aST16 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 83);
                aST = aST.getFirstChild();
                this.beforeStatement("select", 45);
                AST aST17 = aST;
                AST aST18 = null;
                AST aST19 = null;
                aST18 = this.astFactory.create(aST);
                aST19 = aST;
                ASTPair aSTPair3 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 86);
                aST = aST.getFirstChild();
                aST5 = aST == ASTNULL ? null : aST;
                this.fromClause(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 45: {
                        aST7 = aST == ASTNULL ? null : aST;
                        this.selectClause(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair3;
                aST = aST17;
                aST = aST.getNextSibling();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 53: {
                        aST9 = aST == ASTNULL ? null : aST;
                        this.whereClause(aST);
                        aST = this._retTree;
                        aST8 = this.returnAST;
                        break;
                    }
                    case 3: 
                    case 24: 
                    case 41: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 24: {
                        aST11 = aST == ASTNULL ? null : aST;
                        this.groupClause(aST);
                        aST = this._retTree;
                        aST10 = this.returnAST;
                        break;
                    }
                    case 3: 
                    case 41: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 41: {
                        aST13 = aST == ASTNULL ? null : aST;
                        this.orderClause(aST);
                        aST = this._retTree;
                        aST12 = this.returnAST;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST14;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aST2 = this.astFactory.make(new ASTArray(6).add(this.astFactory.create(45, "SELECT")).add(aST6).add(aST4).add(aST8).add(aST10).add(aST12));
                this.beforeStatementCompletion("select");
                this.processQuery(aST6, aST2);
                this.afterStatementCompletion("select");
                aSTPair.root = aST2;
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block22;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void fromClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            this.prepareFromClauseInputTree(aST3);
            try {
                AST aST6 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var8_9 = null;
                aST5 = this.astFactory.create(aST4);
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 22);
                aST = aST.getFirstChild();
                aST2 = aSTPair.root;
                this.pushFromClause(aST2, aST4);
                this.handleClauseStart(22);
                this.fromElementList(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void setClause(AST aST) throws RecognitionException {
        AST aST2;
        block4: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 46);
                aST = aST.getFirstChild();
                this.handleClauseStart(46);
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() != 97) break;
                    this.assignment(aST);
                    aST = this._retTree;
                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block4;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void whereClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var10_11 = null;
                aST5 = this.astFactory.create(aST4);
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 53);
                aST = aST.getFirstChild();
                this.handleClauseStart(53);
                aST7 = aST == ASTNULL ? null : aST;
                this.logicalExpr(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(2).add(aST5).add(aST6));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void intoClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            String string = null;
            try {
                AST aST6 = aST;
                AST aST7 = null;
                AST aST8 = null;
                aST7 = this.astFactory.create(aST);
                aST8 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 30);
                aST = aST.getFirstChild();
                this.handleClauseStart(30);
                string = this.path(aST);
                aST = this._retTree;
                aST5 = aST == ASTNULL ? null : aST;
                this.insertablePropertySpec(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.createIntoClause(string, aST5);
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final String path(AST aST) throws RecognitionException {
        String string;
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            string = "???";
            String string2 = "?x?";
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 90: 
                    case 120: {
                        aST5 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        string = aST5.getText();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 15: {
                        AST aST8 = aST;
                        AST aST9 = null;
                        AST aST10 = null;
                        aST9 = this.astFactory.create(aST);
                        aST10 = aST;
                        this.astFactory.addASTChild(aSTPair, aST9);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 15);
                        aST = aST.getFirstChild();
                        string2 = this.path(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST7 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST8;
                        aST = aST.getNextSibling();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string2).append(".").append(aST7.getText());
                        string = stringBuffer.toString();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
        return string;
    }

    public final void insertablePropertySpec(AST aST) throws RecognitionException {
        AST aST2;
        block5: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 84);
                aST = aST.getFirstChild();
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() != 120) {
                        if (n >= 1) break;
                        throw new NoViableAltException(aST);
                    }
                    AST aST7 = null;
                    AST aST8 = null;
                    aST7 = this.astFactory.create(aST);
                    aST8 = aST;
                    this.astFactory.addASTChild(aSTPair, aST7);
                    this.match(aST, 120);
                    aST = aST.getNextSibling();
                    ++n;
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block5;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void assignment(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                AST aST6 = aST;
                AST aST7 = null;
                AST aST8 = null;
                aST7 = this.astFactory.create(aST);
                aST8 = aST;
                this.astFactory.addASTChild(aSTPair, aST7);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 97);
                aST = aST.getFirstChild();
                aST5 = aST == ASTNULL ? null : aST;
                this.propertyRef(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                this.resolve(aST4);
                this.newValue(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                this.evaluateAssignment(aST2);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void propertyRef(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: {
                        AST aST12 = aST;
                        aST4 = aST == ASTNULL ? null : aST;
                        Object var14_15 = null;
                        aST5 = this.astFactory.create(aST4);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 15);
                        aST = aST.getFirstChild();
                        aST7 = aST == ASTNULL ? null : aST;
                        this.propertyRefLhs(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        aST9 = aST == ASTNULL ? null : aST;
                        this.propertyName(aST);
                        aST = this._retTree;
                        aST8 = this.returnAST;
                        aSTPair = aSTPair2;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aST2 = this.astFactory.make(new ASTArray(3).add(aST5).add(aST6).add(aST8));
                        aSTPair.root = aST2 = this.lookupProperty(aST2, false, true);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 90: 
                    case 120: {
                        aST11 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST10 = this.returnAST;
                        aST2 = aSTPair.root;
                        if (this.isNonQualifiedPropertyRef(aST10)) {
                            aST2 = this.lookupNonQualifiedProperty(aST10);
                        } else {
                            this.resolve(aST10);
                            aST2 = aST10;
                        }
                        aSTPair.root = aST2;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void newValue(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 83: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void expr(AST aST) throws RecognitionException {
        AST aST2;
        block14: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: 
                    case 75: 
                    case 90: 
                    case 120: {
                        aST5 = aST == ASTNULL ? null : aST;
                        this.addrExpr(aST, true);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.resolve(aST4);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 89: {
                        AST aST6 = aST;
                        AST aST7 = null;
                        AST aST8 = null;
                        aST7 = this.astFactory.create(aST);
                        aST8 = aST;
                        this.astFactory.addASTChild(aSTPair, aST7);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 89);
                        aST = aST.getFirstChild();
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (!_tokenSet_0.member(aST.getType())) break;
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                        }
                        aSTPair = aSTPair2;
                        aST = aST6;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 20: 
                    case 39: 
                    case 49: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 118: 
                    case 119: {
                        this.constant(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 54: 
                    case 71: 
                    case 87: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: {
                        this.arithmeticExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 68: 
                    case 78: {
                        this.functionCall(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 116: 
                    case 117: {
                        this.parameter(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 12: {
                        this.count(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block14;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectClause(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                AST aST9 = null;
                AST aST10 = null;
                aST9 = this.astFactory.create(aST);
                aST10 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 45);
                aST = aST.getFirstChild();
                this.handleClauseStart(45);
                this.beforeSelectClause();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 16: {
                        aST4 = aST;
                        Object var13_14 = null;
                        aST5 = this.astFactory.create(aST4);
                        this.match(aST, 16);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 12: 
                    case 15: 
                    case 17: 
                    case 27: 
                    case 54: 
                    case 65: 
                    case 68: 
                    case 70: 
                    case 71: 
                    case 78: 
                    case 83: 
                    case 87: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 118: 
                    case 119: 
                    case 120: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST7 = aST == ASTNULL ? null : aST;
                this.selectExprList(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(3).add(this.astFactory.create(131, "{select clause}")).add(aST5).add(aST6));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void groupClause(AST aST) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 24);
                aST = aST.getFirstChild();
                this.handleClauseStart(24);
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (!_tokenSet_0.member(aST.getType())) {
                        if (n >= 1) break;
                        throw new NoViableAltException(aST);
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                    ++n;
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 25: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 25);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void orderClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 41);
                aST = aST.getFirstChild();
                this.handleClauseStart(41);
                this.orderExprs(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void orderExprs(AST aST) throws RecognitionException {
        AST aST2;
        block13: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.expr(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 8: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 8);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 14: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 14);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 12: 
                    case 15: 
                    case 20: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        this.orderExprs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block13;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void logicalExpr(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 6: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 6);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 40: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 40);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 38: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 38);
                        aST = aST.getFirstChild();
                        this.logicalExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 10: 
                    case 19: 
                    case 26: 
                    case 34: 
                    case 76: 
                    case 77: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 97: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        this.comparisonExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectExprList(AST aST) throws RecognitionException {
        AST aST2;
        block8: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            boolean bl = this.inSelect;
            this.inSelect = true;
            try {
                int n = 0;
                block6: while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 4: 
                        case 12: 
                        case 15: 
                        case 17: 
                        case 27: 
                        case 54: 
                        case 65: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 78: 
                        case 83: 
                        case 87: 
                        case 90: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 118: 
                        case 119: 
                        case 120: {
                            this.selectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            break;
                        }
                        case 7: {
                            this.aliasedSelectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            break;
                        }
                        default: {
                            if (n >= 1) break block6;
                            throw new NoViableAltException(aST);
                        }
                    }
                    ++n;
                }
                this.inSelect = bl;
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block8;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void selectExpr(AST aST) throws RecognitionException {
        AST aST2;
        block15: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: 
                    case 90: 
                    case 120: {
                        aST5 = aST == ASTNULL ? null : aST;
                        this.propertyRef(aST);
                        aST = this._retTree;
                        aST4 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.resolveSelectExpression(aST4);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 4: {
                        AST aST12 = aST;
                        AST aST13 = null;
                        AST aST14 = null;
                        aST13 = this.astFactory.create(aST);
                        aST14 = aST;
                        this.astFactory.addASTChild(aSTPair, aST13);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 4);
                        aST = aST.getFirstChild();
                        aST7 = aST == ASTNULL ? null : aST;
                        this.aliasRef(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.resolveSelectExpression(aST6);
                        aSTPair.root = aST2 = aST6;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 65: {
                        AST aST15 = aST;
                        AST aST16 = null;
                        AST aST17 = null;
                        aST16 = this.astFactory.create(aST);
                        aST17 = aST;
                        this.astFactory.addASTChild(aSTPair, aST16);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 65);
                        aST = aST.getFirstChild();
                        aST9 = aST == ASTNULL ? null : aST;
                        this.aliasRef(aST);
                        aST = this._retTree;
                        aST8 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST15;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.resolveSelectExpression(aST8);
                        aSTPair.root = aST2 = aST8;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 70: {
                        aST11 = aST == ASTNULL ? null : aST;
                        this.constructor(aST);
                        aST = this._retTree;
                        aST10 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.processConstructor(aST10);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 68: 
                    case 78: {
                        this.functionCall(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 12: {
                        this.count(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.collectionFunction(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 92: 
                    case 93: 
                    case 94: 
                    case 118: 
                    case 119: {
                        this.literal(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 54: 
                    case 71: 
                    case 87: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: {
                        this.arithmeticExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 83: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block15;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void aliasedSelectExpr(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                AST aST9 = null;
                AST aST10 = null;
                aST9 = this.astFactory.create(aST);
                aST10 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 7);
                aST = aST.getFirstChild();
                aST5 = aST == ASTNULL ? null : aST;
                this.selectExpr(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                aST7 = aST == ASTNULL ? null : aST;
                this.identifier(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                this.setAlias(aST4, aST6);
                aSTPair.root = aST2 = aST4;
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void identifier(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 120: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 120);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 90: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 90);
                        aST = aST.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void aliasRef(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            try {
                aST5 = aST == ASTNULL ? null : aST;
                this.identifier(aST);
                aST = this._retTree;
                aST4 = this.returnAST;
                aST2 = aSTPair.root;
                aST2 = this.astFactory.make(new ASTArray(1).add(this.astFactory.create(134, aST5.getText())));
                this.lookupAlias(aST2);
                aSTPair.root = aST2;
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void constructor(AST aST) throws RecognitionException {
        AST aST2;
        block8: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            String string = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 70);
                aST = aST.getFirstChild();
                string = this.path(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                block6: while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 4: 
                        case 12: 
                        case 15: 
                        case 17: 
                        case 27: 
                        case 54: 
                        case 65: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 78: 
                        case 83: 
                        case 87: 
                        case 90: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 118: 
                        case 119: 
                        case 120: {
                            this.selectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            continue block6;
                        }
                        case 7: {
                            this.aliasedSelectExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            continue block6;
                        }
                    }
                    break;
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block8;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void functionCall(AST aST) throws RecognitionException {
        AST aST2;
        block14: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 78: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 78);
                        aST = aST.getFirstChild();
                        this.inFunctionCall = true;
                        this.pathAsIdent(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 72: {
                                AST aST7 = aST;
                                AST aST8 = null;
                                AST aST9 = null;
                                aST8 = this.astFactory.create(aST);
                                aST9 = aST;
                                this.astFactory.addASTChild(aSTPair, aST8);
                                ASTPair aSTPair3 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 72);
                                aST = aST.getFirstChild();
                                while (true) {
                                    if (aST == null) {
                                        aST = ASTNULL;
                                    }
                                    if (!_tokenSet_0.member(aST.getType())) break;
                                    this.expr(aST);
                                    aST = this._retTree;
                                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                                }
                                aSTPair = aSTPair3;
                                aST = aST7;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processFunction(aST2, this.inSelect);
                        this.inFunctionCall = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 68: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 68);
                        aST = aST.getFirstChild();
                        this.aggregateExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block14;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void count(AST aST) throws RecognitionException {
        AST aST2;
        block13: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4;
                AST aST5;
                AST aST6 = aST;
                AST aST7 = null;
                AST aST8 = null;
                aST7 = this.astFactory.create(aST);
                aST8 = aST;
                this.astFactory.addASTChild(aSTPair, aST7);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 12);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 16: {
                        aST5 = null;
                        aST4 = null;
                        aST5 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 16);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 4: {
                        aST5 = null;
                        aST4 = null;
                        aST5 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 4);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 12: 
                    case 15: 
                    case 17: 
                    case 20: 
                    case 27: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 85: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 17: 
                    case 20: 
                    case 27: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        this.aggregateExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 85: {
                        aST5 = null;
                        aST4 = null;
                        aST5 = this.astFactory.create(aST);
                        aST4 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        this.match(aST, 85);
                        aST = aST.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST6;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block13;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void collectionFunction(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 17: {
                        AST aST12 = aST;
                        aST4 = aST == ASTNULL ? null : aST;
                        Object var14_16 = null;
                        aST5 = this.astFactory.create(aST4);
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 17);
                        aST = aST.getFirstChild();
                        this.inFunctionCall = true;
                        aST7 = aST == ASTNULL ? null : aST;
                        this.propertyRef(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.resolve(aST6);
                        aSTPair = aSTPair2;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        this.processFunction(aST5, this.inSelect);
                        this.inFunctionCall = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 27: {
                        AST aST13 = aST;
                        aST8 = aST == ASTNULL ? null : aST;
                        Object var14_17 = null;
                        aST9 = this.astFactory.create(aST8);
                        this.astFactory.addASTChild(aSTPair, aST9);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 27);
                        aST = aST.getFirstChild();
                        this.inFunctionCall = true;
                        aST11 = aST == ASTNULL ? null : aST;
                        this.propertyRef(aST);
                        aST = this._retTree;
                        aST10 = this.returnAST;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.resolve(aST10);
                        aSTPair = aSTPair3;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        this.processFunction(aST9, this.inSelect);
                        this.inFunctionCall = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void literal(AST aST) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 118: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 118);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processNumericLiteral(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 94: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 94);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processNumericLiteral(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 93: {
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        this.match(aST, 93);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processNumericLiteral(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 92: {
                        AST aST10 = null;
                        AST aST11 = null;
                        aST10 = this.astFactory.create(aST);
                        aST11 = aST;
                        this.astFactory.addASTChild(aSTPair, aST10);
                        this.match(aST, 92);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processNumericLiteral(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 119: {
                        AST aST12 = null;
                        AST aST13 = null;
                        aST12 = this.astFactory.create(aST);
                        aST13 = aST;
                        this.astFactory.addASTChild(aSTPair, aST12);
                        this.match(aST, 119);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void arithmeticExpr(AST aST) throws RecognitionException {
        AST aST2;
        block11: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 110: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 110);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.prepareArithmeticOperator(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 111: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 111);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.prepareArithmeticOperator(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 113: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 113);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.prepareArithmeticOperator(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 112: {
                        AST aST13 = aST;
                        AST aST14 = null;
                        AST aST15 = null;
                        aST14 = this.astFactory.create(aST);
                        aST15 = aST;
                        this.astFactory.addASTChild(aSTPair, aST14);
                        ASTPair aSTPair5 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 112);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair5;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.prepareArithmeticOperator(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 87: {
                        AST aST16 = aST;
                        AST aST17 = null;
                        AST aST18 = null;
                        aST17 = this.astFactory.create(aST);
                        aST18 = aST;
                        this.astFactory.addASTChild(aSTPair, aST17);
                        ASTPair aSTPair6 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 87);
                        aST = aST.getFirstChild();
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair6;
                        aST = aST16;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.prepareArithmeticOperator(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 54: 
                    case 71: {
                        this.caseExpr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block11;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void aggregateExpr(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 17: 
                    case 27: {
                        this.collectionFunction(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void fromElementList(AST aST) throws RecognitionException {
        AST aST2;
        block5: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            boolean bl = this.inFrom;
            this.inFrom = true;
            try {
                int n = 0;
                while (true) {
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    if (aST.getType() != 32 && aST.getType() != 73 && aST.getType() != 84) {
                        if (n >= 1) break;
                        throw new NoViableAltException(aST);
                    }
                    this.fromElement(aST);
                    aST = this._retTree;
                    this.astFactory.addASTChild(aSTPair, this.returnAST);
                    ++n;
                }
                this.inFrom = bl;
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block5;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void fromElement(AST aST) throws RecognitionException {
        AST aST2;
        block18: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            String string = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 84: {
                        Object var20_23;
                        AST aST14 = aST;
                        AST aST15 = null;
                        AST aST16 = null;
                        aST15 = this.astFactory.create(aST);
                        aST16 = aST;
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 84);
                        aST = aST.getFirstChild();
                        string = this.path(aST);
                        aST = this._retTree;
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 69: {
                                aST4 = aST;
                                var20_23 = null;
                                aST5 = this.astFactory.create(aST4);
                                this.match(aST, 69);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: 
                            case 21: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 21: {
                                aST6 = aST;
                                var20_23 = null;
                                aST7 = this.astFactory.create(aST6);
                                this.match(aST, 21);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair2;
                        aST = aST14;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = this.createFromElement(string, aST4, aST6);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 32: {
                        aST9 = aST == ASTNULL ? null : aST;
                        this.joinElement(aST);
                        aST = this._retTree;
                        aST8 = this.returnAST;
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = aST8;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 73: {
                        aST10 = aST;
                        Object var16_17 = null;
                        aST11 = this.astFactory.create(aST10);
                        this.match(aST, 73);
                        aST12 = aST = aST.getNextSibling();
                        Object var17_20 = null;
                        aST13 = this.astFactory.create(aST12);
                        this.match(aST, 69);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = this.createFromFilterElement(aST10, aST12);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block18;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void joinElement(AST aST) throws RecognitionException {
        Object var4_4;
        block27: {
            AST aST2 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            var4_4 = null;
            AST aST3 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            int n = 28;
            try {
                Object var20_21;
                AST aST13 = aST;
                AST aST14 = null;
                AST aST15 = null;
                aST14 = this.astFactory.create(aST);
                aST15 = aST;
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 32);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 23: 
                    case 28: 
                    case 33: 
                    case 44: {
                        n = this.joinType(aST);
                        aST = this._retTree;
                        this.setImpliedJoinType(n);
                        break;
                    }
                    case 15: 
                    case 21: 
                    case 90: 
                    case 120: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 21: {
                        aST3 = aST;
                        var20_21 = null;
                        aST4 = this.astFactory.create(aST3);
                        this.match(aST, 21);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 15: 
                    case 90: 
                    case 120: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST6 = aST == ASTNULL ? null : aST;
                this.propertyRef(aST);
                aST = this._retTree;
                aST5 = this.returnAST;
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 69: {
                        aST7 = aST;
                        var20_21 = null;
                        aST8 = this.astFactory.create(aST7);
                        this.match(aST, 69);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 21: 
                    case 60: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 21: {
                        aST9 = aST;
                        var20_21 = null;
                        aST10 = this.astFactory.create(aST9);
                        this.match(aST, 21);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: 
                    case 60: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 60: {
                        aST11 = aST;
                        var20_21 = null;
                        aST12 = this.astFactory.create(aST11);
                        this.match(aST, 60);
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST13;
                aST = aST.getNextSibling();
                this.createFromJoinElement(aST5, aST7, n, aST3, aST9, aST11);
                this.setImpliedJoinType(28);
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block27;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = var4_4;
        this._retTree = aST;
    }

    public final int joinType(AST aST) throws RecognitionException {
        int n;
        AST aST2;
        block23: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            n = 28;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 33: 
                    case 44: {
                        Object var12_12;
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 33: {
                                aST4 = aST;
                                var12_12 = null;
                                aST5 = this.astFactory.create(aST4);
                                this.astFactory.addASTChild(aSTPair, aST5);
                                this.match(aST, 33);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 44: {
                                aST6 = aST;
                                var12_12 = null;
                                aST7 = this.astFactory.create(aST6);
                                this.astFactory.addASTChild(aSTPair, aST7);
                                this.match(aST, 44);
                                aST = aST.getNextSibling();
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 42: {
                                aST8 = aST;
                                var12_12 = null;
                                aST9 = this.astFactory.create(aST8);
                                this.astFactory.addASTChild(aSTPair, aST9);
                                this.match(aST, 42);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 15: 
                            case 21: 
                            case 90: 
                            case 120: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        if (aST4 != null) {
                            n = 132;
                        } else if (aST6 != null) {
                            n = 133;
                        } else if (aST8 != null) {
                            n = 133;
                        }
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 23: {
                        AST aST10 = null;
                        AST aST11 = null;
                        aST10 = this.astFactory.create(aST);
                        aST11 = aST;
                        this.astFactory.addASTChild(aSTPair, aST10);
                        this.match(aST, 23);
                        aST = aST.getNextSibling();
                        n = 23;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 28: {
                        AST aST12 = null;
                        AST aST13 = null;
                        aST12 = this.astFactory.create(aST);
                        aST13 = aST;
                        this.astFactory.addASTChild(aSTPair, aST12);
                        this.match(aST, 28);
                        aST = aST.getNextSibling();
                        n = 28;
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block23;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
        return n;
    }

    public final void pathAsIdent(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            String string = "?text?";
            try {
                string = this.path(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(1).add(this.astFactory.create(120, string)));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void withClause(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            try {
                AST aST8 = aST;
                aST4 = aST == ASTNULL ? null : aST;
                Object var10_11 = null;
                aST5 = this.astFactory.create(aST4);
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 60);
                aST = aST.getFirstChild();
                this.handleClauseStart(60);
                aST7 = aST == ASTNULL ? null : aST;
                this.logicalExpr(aST);
                aST = this._retTree;
                aST6 = this.returnAST;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aSTPair = aSTPair2;
                aST = aST8;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
                aSTPair.root = aST2 = this.astFactory.make(new ASTArray(2).add(aST5).add(aST6));
                aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                aSTPair.advanceChildToEnd();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void comparisonExpr(AST aST) throws RecognitionException {
        AST aST2;
        block35: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 97: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 97);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 103: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 103);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 105: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 105);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 106: {
                        AST aST13 = aST;
                        AST aST14 = null;
                        AST aST15 = null;
                        aST14 = this.astFactory.create(aST);
                        aST15 = aST;
                        this.astFactory.addASTChild(aSTPair, aST14);
                        ASTPair aSTPair5 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 106);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair5;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 107: {
                        AST aST16 = aST;
                        AST aST17 = null;
                        AST aST18 = null;
                        aST17 = this.astFactory.create(aST);
                        aST18 = aST;
                        this.astFactory.addASTChild(aSTPair, aST17);
                        ASTPair aSTPair6 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 107);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair6;
                        aST = aST16;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 108: {
                        AST aST19 = aST;
                        AST aST20 = null;
                        AST aST21 = null;
                        aST20 = this.astFactory.create(aST);
                        aST21 = aST;
                        this.astFactory.addASTChild(aSTPair, aST20);
                        ASTPair aSTPair7 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 108);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair7;
                        aST = aST19;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 34: {
                        AST aST22 = aST;
                        AST aST23 = null;
                        AST aST24 = null;
                        aST23 = this.astFactory.create(aST);
                        aST24 = aST;
                        this.astFactory.addASTChild(aSTPair, aST23);
                        ASTPair aSTPair8 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 34);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 18: {
                                AST aST25 = aST;
                                AST aST26 = null;
                                AST aST27 = null;
                                aST26 = this.astFactory.create(aST);
                                aST27 = aST;
                                this.astFactory.addASTChild(aSTPair, aST26);
                                ASTPair aSTPair9 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 18);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aSTPair9;
                                aST = aST25;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair8;
                        aST = aST22;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 81: {
                        AST aST28 = aST;
                        AST aST29 = null;
                        AST aST30 = null;
                        aST29 = this.astFactory.create(aST);
                        aST30 = aST;
                        this.astFactory.addASTChild(aSTPair, aST29);
                        ASTPair aSTPair10 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 81);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 18: {
                                AST aST31 = aST;
                                AST aST32 = null;
                                AST aST33 = null;
                                aST32 = this.astFactory.create(aST);
                                aST33 = aST;
                                this.astFactory.addASTChild(aSTPair, aST32);
                                ASTPair aSTPair11 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 18);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aSTPair11;
                                aST = aST31;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair10;
                        aST = aST28;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 10: {
                        AST aST34 = aST;
                        AST aST35 = null;
                        AST aST36 = null;
                        aST35 = this.astFactory.create(aST);
                        aST36 = aST;
                        this.astFactory.addASTChild(aSTPair, aST35);
                        ASTPair aSTPair12 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 10);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair12;
                        aST = aST34;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 79: {
                        AST aST37 = aST;
                        AST aST38 = null;
                        AST aST39 = null;
                        aST38 = this.astFactory.create(aST);
                        aST39 = aST;
                        this.astFactory.addASTChild(aSTPair, aST38);
                        ASTPair aSTPair13 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 79);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair13;
                        aST = aST37;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 26: {
                        AST aST40 = aST;
                        AST aST41 = null;
                        AST aST42 = null;
                        aST41 = this.astFactory.create(aST);
                        aST42 = aST;
                        this.astFactory.addASTChild(aSTPair, aST41);
                        ASTPair aSTPair14 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 26);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.inRhs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair14;
                        aST = aST40;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 80: {
                        AST aST43 = aST;
                        AST aST44 = null;
                        AST aST45 = null;
                        aST44 = this.astFactory.create(aST);
                        aST45 = aST;
                        this.astFactory.addASTChild(aSTPair, aST44);
                        ASTPair aSTPair15 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 80);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        this.inRhs(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair15;
                        aST = aST43;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 77: {
                        AST aST46 = aST;
                        AST aST47 = null;
                        AST aST48 = null;
                        aST47 = this.astFactory.create(aST);
                        aST48 = aST;
                        this.astFactory.addASTChild(aSTPair, aST47);
                        ASTPair aSTPair16 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 77);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair16;
                        aST = aST46;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 76: {
                        AST aST49 = aST;
                        AST aST50 = null;
                        AST aST51 = null;
                        aST50 = this.astFactory.create(aST);
                        aST51 = aST;
                        this.astFactory.addASTChild(aSTPair, aST50);
                        ASTPair aSTPair17 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 76);
                        aST = aST.getFirstChild();
                        this.exprOrSubquery(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair17;
                        aST = aST49;
                        aST = aST.getNextSibling();
                        break;
                    }
                    case 19: {
                        AST aST52 = aST;
                        AST aST53 = null;
                        AST aST54 = null;
                        aST53 = this.astFactory.create(aST);
                        aST54 = aST;
                        this.astFactory.addASTChild(aSTPair, aST53);
                        ASTPair aSTPair18 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 19);
                        aST = aST.getFirstChild();
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 12: 
                            case 15: 
                            case 20: 
                            case 39: 
                            case 49: 
                            case 54: 
                            case 68: 
                            case 71: 
                            case 75: 
                            case 78: 
                            case 87: 
                            case 89: 
                            case 90: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: {
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                break;
                            }
                            case 17: 
                            case 27: 
                            case 83: {
                                this.collectionFunctionOrSubselect(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair18;
                        aST = aST52;
                        aST = aST.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aST2 = aSTPair.root;
                this.prepareLogicOperator(aST2);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block35;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void exprOrSubquery(AST aST) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 12: 
                    case 15: 
                    case 20: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 83: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 5: {
                        AST aST4 = aST;
                        AST aST5 = null;
                        AST aST6 = null;
                        aST5 = this.astFactory.create(aST);
                        aST6 = aST;
                        this.astFactory.addASTChild(aSTPair, aST5);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 5);
                        aST = aST.getFirstChild();
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair2;
                        aST = aST4;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 4: {
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 4);
                        aST = aST.getFirstChild();
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair3;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 47: {
                        AST aST10 = aST;
                        AST aST11 = null;
                        AST aST12 = null;
                        aST11 = this.astFactory.create(aST);
                        aST12 = aST;
                        this.astFactory.addASTChild(aSTPair, aST11);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 47);
                        aST = aST.getFirstChild();
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aSTPair = aSTPair4;
                        aST = aST10;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void inRhs(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = aST;
                AST aST5 = null;
                AST aST6 = null;
                aST5 = this.astFactory.create(aST);
                aST6 = aST;
                this.astFactory.addASTChild(aSTPair, aST5);
                ASTPair aSTPair2 = aSTPair.copy();
                aSTPair.root = aSTPair.child;
                aSTPair.child = null;
                this.match(aST, 74);
                aST = aST.getFirstChild();
                if (aST == null) {
                    aST = ASTNULL;
                }
                block1 : switch (aST.getType()) {
                    case 17: 
                    case 27: 
                    case 83: {
                        this.collectionFunctionOrSubselect(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        break;
                    }
                    case 3: 
                    case 12: 
                    case 15: 
                    case 20: 
                    case 39: 
                    case 49: 
                    case 54: 
                    case 68: 
                    case 71: 
                    case 75: 
                    case 78: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (!_tokenSet_0.member(aST.getType())) break block1;
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                        }
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
                aSTPair = aSTPair2;
                aST = aST4;
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void collectionFunctionOrSubselect(AST aST) throws RecognitionException {
        AST aST2;
        block7: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 17: 
                    case 27: {
                        this.collectionFunction(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 83: {
                        this.query(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block7;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void addrExpr(AST aST, boolean bl) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            AST aST12 = null;
            AST aST13 = null;
            AST aST14 = null;
            AST aST15 = null;
            AST aST16 = null;
            AST aST17 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 15: {
                        AST aST18 = aST;
                        aST4 = aST == ASTNULL ? null : aST;
                        Object var21_23 = null;
                        aST5 = this.astFactory.create(aST4);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 15);
                        aST = aST.getFirstChild();
                        aST7 = aST == ASTNULL ? null : aST;
                        this.addrExprLhs(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        aST9 = aST == ASTNULL ? null : aST;
                        this.propertyName(aST);
                        aST = this._retTree;
                        aST8 = this.returnAST;
                        aSTPair = aSTPair2;
                        aST = aST18;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aST2 = this.astFactory.make(new ASTArray(3).add(aST5).add(aST6).add(aST8));
                        aSTPair.root = aST2 = this.lookupProperty(aST2, bl, false);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 75: {
                        AST aST19 = aST;
                        aST10 = aST == ASTNULL ? null : aST;
                        Object var21_24 = null;
                        aST11 = this.astFactory.create(aST10);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 75);
                        aST = aST.getFirstChild();
                        aST13 = aST == ASTNULL ? null : aST;
                        this.addrExprLhs(aST);
                        aST = this._retTree;
                        aST12 = this.returnAST;
                        aST15 = aST == ASTNULL ? null : aST;
                        this.expr(aST);
                        aST = this._retTree;
                        aST14 = this.returnAST;
                        aSTPair = aSTPair3;
                        aST = aST19;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aST2 = this.astFactory.make(new ASTArray(3).add(aST11).add(aST12).add(aST14));
                        this.processIndex(aST2);
                        aSTPair.root = aST2;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 90: 
                    case 120: {
                        aST17 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST16 = this.returnAST;
                        aST2 = aSTPair.root;
                        if (this.isNonQualifiedPropertyRef(aST16)) {
                            aST2 = this.lookupNonQualifiedProperty(aST16);
                        } else {
                            this.resolve(aST16);
                            aST2 = aST16;
                        }
                        aSTPair.root = aST2;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void constant(AST aST) throws RecognitionException {
        AST aST2;
        block10: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 92: 
                    case 93: 
                    case 94: 
                    case 118: 
                    case 119: {
                        this.literal(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 39: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 39);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 49: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 49);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processBoolean(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 20: {
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        this.match(aST, 20);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        this.processBoolean(aST2);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 95: {
                        AST aST10 = null;
                        AST aST11 = null;
                        aST10 = this.astFactory.create(aST);
                        aST11 = aST;
                        this.astFactory.addASTChild(aSTPair, aST10);
                        this.match(aST, 95);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block10;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void parameter(AST aST) throws RecognitionException {
        AST aST2;
        block12: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            AST aST4 = null;
            AST aST5 = null;
            AST aST6 = null;
            AST aST7 = null;
            AST aST8 = null;
            AST aST9 = null;
            AST aST10 = null;
            AST aST11 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 116: {
                        AST aST12 = aST;
                        aST4 = aST == ASTNULL ? null : aST;
                        Object var14_16 = null;
                        aST5 = this.astFactory.create(aST4);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 116);
                        aST = aST.getFirstChild();
                        aST7 = aST == ASTNULL ? null : aST;
                        this.identifier(aST);
                        aST = this._retTree;
                        aST6 = this.returnAST;
                        aSTPair = aSTPair2;
                        aST = aST12;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aSTPair.root = aST2 = this.generateNamedParameter(aST4, aST7);
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    case 117: {
                        AST aST13 = aST;
                        aST8 = aST == ASTNULL ? null : aST;
                        Object var14_17 = null;
                        aST9 = this.astFactory.create(aST8);
                        ASTPair aSTPair3 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 117);
                        aST = aST.getFirstChild();
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 118: {
                                aST10 = aST;
                                Object var16_20 = null;
                                aST11 = this.astFactory.create(aST10);
                                this.match(aST, 118);
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair3;
                        aST = aST13;
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        aST2 = aST10 != null ? this.generateNamedParameter(aST8, aST10) : this.generatePositionalParameter(aST8);
                        aSTPair.root = aST2;
                        aSTPair.child = aST2 != null && aST2.getFirstChild() != null ? aST2.getFirstChild() : aST2;
                        aSTPair.advanceChildToEnd();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block12;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void caseExpr(AST aST) throws RecognitionException {
        AST aST2;
        block23: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 54: {
                        AST aST4;
                        AST aST5;
                        AST aST6;
                        AST aST7 = aST;
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        ASTPair aSTPair2 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 54);
                        aST = aST.getFirstChild();
                        this.inCase = true;
                        int n = 0;
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (aST.getType() != 58) {
                                if (n >= 1) break;
                                throw new NoViableAltException(aST);
                            }
                            aST6 = aST;
                            aST5 = null;
                            aST4 = null;
                            aST5 = this.astFactory.create(aST);
                            aST4 = aST;
                            this.astFactory.addASTChild(aSTPair, aST5);
                            ASTPair aSTPair3 = aSTPair.copy();
                            aSTPair.root = aSTPair.child;
                            aSTPair.child = null;
                            this.match(aST, 58);
                            aST = aST.getFirstChild();
                            this.logicalExpr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            aSTPair = aSTPair3;
                            aST = aST6;
                            aST = aST.getNextSibling();
                            ++n;
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 56: {
                                AST aST10 = aST;
                                aST6 = null;
                                aST5 = null;
                                aST6 = this.astFactory.create(aST);
                                aST5 = aST;
                                this.astFactory.addASTChild(aSTPair, aST6);
                                aST4 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 56);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aST4;
                                aST = aST10;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair2;
                        aST = aST7;
                        aST = aST.getNextSibling();
                        this.inCase = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 71: {
                        AST aST11;
                        AST aST12;
                        AST aST13;
                        AST aST14 = aST;
                        AST aST15 = null;
                        AST aST16 = null;
                        aST15 = this.astFactory.create(aST);
                        aST16 = aST;
                        this.astFactory.addASTChild(aSTPair, aST15);
                        ASTPair aSTPair4 = aSTPair.copy();
                        aSTPair.root = aSTPair.child;
                        aSTPair.child = null;
                        this.match(aST, 71);
                        aST = aST.getFirstChild();
                        this.inCase = true;
                        this.expr(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        int n = 0;
                        while (true) {
                            if (aST == null) {
                                aST = ASTNULL;
                            }
                            if (aST.getType() != 58) {
                                if (n >= 1) break;
                                throw new NoViableAltException(aST);
                            }
                            aST13 = aST;
                            aST12 = null;
                            aST11 = null;
                            aST12 = this.astFactory.create(aST);
                            aST11 = aST;
                            this.astFactory.addASTChild(aSTPair, aST12);
                            ASTPair aSTPair5 = aSTPair.copy();
                            aSTPair.root = aSTPair.child;
                            aSTPair.child = null;
                            this.match(aST, 58);
                            aST = aST.getFirstChild();
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            this.expr(aST);
                            aST = this._retTree;
                            this.astFactory.addASTChild(aSTPair, this.returnAST);
                            aSTPair = aSTPair5;
                            aST = aST13;
                            aST = aST.getNextSibling();
                            ++n;
                        }
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        switch (aST.getType()) {
                            case 56: {
                                AST aST17 = aST;
                                aST13 = null;
                                aST12 = null;
                                aST13 = this.astFactory.create(aST);
                                aST12 = aST;
                                this.astFactory.addASTChild(aSTPair, aST13);
                                aST11 = aSTPair.copy();
                                aSTPair.root = aSTPair.child;
                                aSTPair.child = null;
                                this.match(aST, 56);
                                aST = aST.getFirstChild();
                                this.expr(aST);
                                aST = this._retTree;
                                this.astFactory.addASTChild(aSTPair, this.returnAST);
                                aSTPair = aST11;
                                aST = aST17;
                                aST = aST.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(aST);
                            }
                        }
                        aSTPair = aSTPair4;
                        aST = aST14;
                        aST = aST.getNextSibling();
                        this.inCase = false;
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block23;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void addrExprLhs(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.addrExpr(aST, false);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void propertyName(AST aST) throws RecognitionException {
        AST aST2;
        block9: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                if (aST == null) {
                    aST = ASTNULL;
                }
                switch (aST.getType()) {
                    case 90: 
                    case 120: {
                        this.identifier(aST);
                        aST = this._retTree;
                        this.astFactory.addASTChild(aSTPair, this.returnAST);
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 11: {
                        AST aST4 = null;
                        AST aST5 = null;
                        aST4 = this.astFactory.create(aST);
                        aST5 = aST;
                        this.astFactory.addASTChild(aSTPair, aST4);
                        this.match(aST, 11);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 17: {
                        AST aST6 = null;
                        AST aST7 = null;
                        aST6 = this.astFactory.create(aST);
                        aST7 = aST;
                        this.astFactory.addASTChild(aSTPair, aST6);
                        this.match(aST, 17);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    case 27: {
                        AST aST8 = null;
                        AST aST9 = null;
                        aST8 = this.astFactory.create(aST);
                        aST9 = aST;
                        this.astFactory.addASTChild(aSTPair, aST8);
                        this.match(aST, 27);
                        aST = aST.getNextSibling();
                        aST2 = aSTPair.root;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(aST);
                    }
                }
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block9;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void propertyRefLhs(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                this.propertyRef(aST);
                aST = this._retTree;
                this.astFactory.addASTChild(aSTPair, this.returnAST);
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    public final void numericInteger(AST aST) throws RecognitionException {
        AST aST2;
        block2: {
            AST aST3 = aST == ASTNULL ? null : aST;
            this.returnAST = null;
            ASTPair aSTPair = new ASTPair();
            aST2 = null;
            try {
                AST aST4 = null;
                AST aST5 = null;
                aST4 = this.astFactory.create(aST);
                aST5 = aST;
                this.astFactory.addASTChild(aSTPair, aST4);
                this.match(aST, 118);
                aST = aST.getNextSibling();
                aST2 = aSTPair.root;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                if (aST == null) break block2;
                aST = aST.getNextSibling();
            }
        }
        this.returnAST = aST2;
        this._retTree = aST;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[]{18577898219802624L, 140667123746752656L, 0L, 0L};
        return lArray;
    }
}

