/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql;

import java.lang.reflect.Constructor;
import org.hibernate.transform.AliasToBeanConstructorResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public final class HolderInstantiator {
    public static final HolderInstantiator NOOP_INSTANTIATOR = new HolderInstantiator(null, null);
    private final ResultTransformer transformer;
    private final String[] queryReturnAliases;

    public static HolderInstantiator getHolderInstantiator(ResultTransformer resultTransformer, ResultTransformer resultTransformer2, String[] stringArray) {
        if (resultTransformer != null) {
            return new HolderInstantiator(resultTransformer, stringArray);
        }
        return new HolderInstantiator(resultTransformer2, stringArray);
    }

    public static ResultTransformer createSelectNewTransformer(Constructor constructor, boolean bl, boolean bl2) {
        if (constructor != null) {
            return new AliasToBeanConstructorResultTransformer(constructor);
        }
        if (bl) {
            return Transformers.ALIAS_TO_ENTITY_MAP;
        }
        if (bl2) {
            return Transformers.TO_LIST;
        }
        return null;
    }

    public static HolderInstantiator createClassicHolderInstantiator(Constructor constructor, ResultTransformer resultTransformer) {
        if (constructor != null) {
            return new HolderInstantiator(new AliasToBeanConstructorResultTransformer(constructor), null);
        }
        return new HolderInstantiator(resultTransformer, null);
    }

    public HolderInstantiator(ResultTransformer resultTransformer, String[] stringArray) {
        this.transformer = resultTransformer;
        this.queryReturnAliases = stringArray;
    }

    public boolean isRequired() {
        return this.transformer != null;
    }

    public Object instantiate(Object[] objectArray) {
        if (this.transformer == null) {
            return objectArray;
        }
        return this.transformer.transformTuple(objectArray, this.queryReturnAliases);
    }

    public String[] getQueryReturnAliases() {
        return this.queryReturnAliases;
    }

    public ResultTransformer getResultTransformer() {
        return this.transformer;
    }
}

