/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.Configurable;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class SQLExceptionConverterFactory {
    private static final Log log = LogFactory.getLog((Class)SQLExceptionConverterFactory.class);
    static /* synthetic */ Class class$org$hibernate$exception$ViolatedConstraintNameExtracter;

    private SQLExceptionConverterFactory() {
    }

    public static SQLExceptionConverter buildSQLExceptionConverter(Dialect dialect, Properties properties) throws HibernateException {
        SQLExceptionConverter sQLExceptionConverter = null;
        String string = (String)properties.get("hibernate.jdbc.sql_exception_converter");
        if (StringHelper.isNotEmpty(string)) {
            sQLExceptionConverter = SQLExceptionConverterFactory.constructConverter(string, dialect.getViolatedConstraintNameExtracter());
        }
        if (sQLExceptionConverter == null) {
            log.trace((Object)"Using dialect defined converter");
            sQLExceptionConverter = dialect.buildSQLExceptionConverter();
        }
        if (sQLExceptionConverter instanceof Configurable) {
            try {
                ((Configurable)((Object)sQLExceptionConverter)).configure(properties);
            }
            catch (HibernateException hibernateException) {
                log.warn((Object)"Unable to configure SQLExceptionConverter", (Throwable)hibernateException);
                throw hibernateException;
            }
        }
        return sQLExceptionConverter;
    }

    public static SQLExceptionConverter buildMinimalSQLExceptionConverter() {
        return new SQLExceptionConverter(){

            public JDBCException convert(SQLException sQLException, String string, String string2) {
                return new GenericJDBCException(string, sQLException, string2);
            }
        };
    }

    private static SQLExceptionConverter constructConverter(String string, ViolatedConstraintNameExtracter violatedConstraintNameExtracter) {
        try {
            log.trace((Object)("Attempting to construct instance of specified SQLExceptionConverter [" + string + "]"));
            Class clazz = ReflectHelper.classForName(string);
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                if (constructorArray[i].getParameterTypes() == null || constructorArray[i].getParameterTypes().length != 1 || !(class$org$hibernate$exception$ViolatedConstraintNameExtracter == null ? SQLExceptionConverterFactory.class$("org.hibernate.exception.ViolatedConstraintNameExtracter") : class$org$hibernate$exception$ViolatedConstraintNameExtracter).isAssignableFrom(constructorArray[i].getParameterTypes()[0])) continue;
                try {
                    return (SQLExceptionConverter)constructorArray[i].newInstance(violatedConstraintNameExtracter);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return (SQLExceptionConverter)clazz.newInstance();
        }
        catch (Throwable throwable) {
            log.warn((Object)"Unable to construct instance of specified SQLExceptionConverter", throwable);
            return null;
        }
    }
}

