/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.util.JDBCExceptionReporter;

public final class JDBCExceptionHelper {
    private JDBCExceptionHelper() {
    }

    public static JDBCException convert(SQLExceptionConverter sQLExceptionConverter, SQLException sQLException, String string) {
        return JDBCExceptionHelper.convert(sQLExceptionConverter, sQLException, string, "???");
    }

    public static JDBCException convert(SQLExceptionConverter sQLExceptionConverter, SQLException sQLException, String string, String string2) {
        JDBCExceptionReporter.logExceptions(sQLException, string + " [" + string2 + "]");
        return sQLExceptionConverter.convert(sQLException, string, string2);
    }

    public static int extractErrorCode(SQLException sQLException) {
        int n = sQLException.getErrorCode();
        for (SQLException sQLException2 = sQLException.getNextException(); n == 0 && sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            n = sQLException2.getErrorCode();
        }
        return n;
    }

    public static String extractSqlState(SQLException sQLException) {
        String string = sQLException.getSQLState();
        for (SQLException sQLException2 = sQLException.getNextException(); string == null && sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            string = sQLException2.getSQLState();
        }
        return string;
    }

    public static String extractSqlStateClassCode(SQLException sQLException) {
        return JDBCExceptionHelper.determineSqlStateClassCode(JDBCExceptionHelper.extractSqlState(sQLException));
    }

    public static String determineSqlStateClassCode(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        return string.substring(0, 2);
    }
}

