/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.exception.Nestable;
import org.hibernate.util.ArrayHelper;

public final class ExceptionUtils {
    private static final String LINE_SEPARATOR;
    static final String WRAPPED_MARKER = " [wrapped] ";
    private static final String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;

    private ExceptionUtils() {
    }

    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] stringArray) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (throwable2 == null) {
            String string;
            if (stringArray == null) {
                stringArray = CAUSE_METHOD_NAMES;
            }
            for (int i = 0; i < stringArray.length && ((string = stringArray[i]) == null || (throwable2 = ExceptionUtils.getCauseUsingMethodName(throwable, string)) == null); ++i) {
            }
            if (throwable2 == null) {
                throwable2 = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return throwable2;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getCause(throwable);
        if (throwable2 != null) {
            throwable = throwable2;
            while ((throwable = ExceptionUtils.getCause(throwable)) != null) {
                throwable2 = throwable;
            }
        }
        return throwable2;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof Nestable) {
            return ((Nestable)((Object)throwable)).getCause();
        }
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String string) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, ArrayHelper.EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String string) {
        Field field = null;
        try {
            field = throwable.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof Nestable) {
            return true;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (ExceptionUtils.isThrowableNested()) {
            return true;
        }
        Class<?> clazz = throwable.getClass();
        int n = CAUSE_METHOD_NAMES.length;
        for (int i = 0; i < n; ++i) {
            try {
                Method method = clazz.getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method == null || !(class$java$lang$Throwable == null ? ExceptionUtils.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            Field field = clazz.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static int getThrowableCount(Throwable throwable) {
        int n = 0;
        while (throwable != null) {
            ++n;
            throwable = ExceptionUtils.getCause(throwable);
        }
        return n;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null) {
            arrayList.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return arrayList.toArray(new Throwable[arrayList.size()]);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz) {
        return ExceptionUtils.indexOfThrowable(throwable, clazz, 0);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz, int n) {
        Throwable[] throwableArray;
        if (throwable == null) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= (throwableArray = ExceptionUtils.getThrowables(throwable)).length) {
            return -1;
        }
        for (int i = n; i < throwableArray.length; ++i) {
            if (!throwableArray[i].getClass().equals(clazz)) continue;
            return i;
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        if (throwable == null) {
            return;
        }
        if (printStream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        String[] stringArray = ExceptionUtils.getRootCauseStackTrace(throwable);
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.println(stringArray[i]);
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        if (throwable == null) {
            return;
        }
        if (printWriter == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        String[] stringArray = ExceptionUtils.getRootCauseStackTrace(throwable);
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println(stringArray[i]);
        }
        printWriter.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        int n = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ExceptionUtils.getStackFrameList(throwableArray[n - 1]);
        int n2 = n;
        while (--n2 >= 0) {
            List list2 = list;
            if (n2 != 0) {
                list = ExceptionUtils.getStackFrameList(throwableArray[n2 - 1]);
                ExceptionUtils.removeCommonFrames(list2, list);
            }
            if (n2 == n - 1) {
                arrayList.add(throwableArray[n2].toString());
            } else {
                arrayList.add(WRAPPED_MARKER + throwableArray[n2].toString());
            }
            for (int i = 0; i < list2.size(); ++i) {
                arrayList.add((String)list2.get(i));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static void removeCommonFrames(List list, List list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int n = list.size() - 1;
        for (int i = list2.size() - 1; n >= 0 && i >= 0; --n, --i) {
            String string;
            String string2 = (String)list.get(n);
            if (!string2.equals(string = (String)list2.get(i))) continue;
            list.remove(n);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        for (int i = 0; i < throwableArray.length; ++i) {
            throwableArray[i].printStackTrace(printWriter);
            if (ExceptionUtils.isNestedThrowable(throwableArray[i])) break;
        }
        return stringWriter.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    static String[] getStackFrames(String string) {
        String string2 = LINE_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    static List getStackFrameList(Throwable throwable) {
        String string = ExceptionUtils.getStackTrace(throwable);
        String string2 = LINE_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("at");
            if (n != -1 && string3.substring(0, n).trim().length() == 0) {
                bl = true;
                linkedList.add(string3);
                continue;
            }
            if (!bl) continue;
            break;
        }
        return linkedList;
    }

    static {
        Method method;
        LINE_SEPARATOR = System.getProperty("line.separator");
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested"};
        try {
            method = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception exception) {
            method = null;
        }
        THROWABLE_CAUSE_METHOD = method;
    }
}

