/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class WrapVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog((Class)WrapVisitor.class);
    boolean substitute = false;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(EventSource eventSource) {
        super(eventSource);
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object != null && object instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)object;
            EventSource eventSource = this.getSession();
            if (persistentCollection.setCurrentSession(eventSource)) {
                this.reattachCollection(persistentCollection, collectionType);
            }
            return null;
        }
        return this.processArrayOrNewCollection(object, collectionType);
    }

    final Object processArrayOrNewCollection(Object object, CollectionType collectionType) throws HibernateException {
        EventSource eventSource = this.getSession();
        if (object == null) {
            return null;
        }
        CollectionPersister collectionPersister = eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        if (collectionType.hasHolder(eventSource.getEntityMode())) {
            if (object == CollectionType.UNFETCHED_COLLECTION) {
                return null;
            }
            PersistentCollection persistentCollection = persistenceContext.getCollectionHolder(object);
            if (persistentCollection == null) {
                persistentCollection = collectionType.wrap(eventSource, object);
                persistenceContext.addNewCollection(collectionPersister, persistentCollection);
                persistenceContext.addCollectionHolder(persistentCollection);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(eventSource, object);
        persistenceContext.addNewCollection(collectionPersister, persistentCollection);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrapped collection in role: " + collectionType.getRole()));
        }
        return persistentCollection;
    }

    void processValue(int n, Object[] objectArray, Type[] typeArray) {
        Object object = this.processValue(objectArray[n], typeArray[n]);
        if (object != null) {
            this.substitute = true;
            objectArray[n] = object;
        }
    }

    Object processComponent(Object object, AbstractComponentType abstractComponentType) throws HibernateException {
        if (object != null) {
            Object[] objectArray = abstractComponentType.getPropertyValues(object, this.getSession());
            Type[] typeArray = abstractComponentType.getSubtypes();
            boolean bl = false;
            for (int i = 0; i < typeArray.length; ++i) {
                Object object2 = this.processValue(objectArray[i], typeArray[i]);
                if (object2 == null) continue;
                objectArray[i] = object2;
                bl = true;
            }
            if (bl) {
                abstractComponentType.setPropertyValues(object, objectArray, this.getSession().getEntityMode());
            }
        }
        return null;
    }

    void process(Object object, EntityPersister entityPersister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        Object[] objectArray = entityPersister.getPropertyValues(object, entityMode);
        Type[] typeArray = entityPersister.getPropertyTypes();
        this.processEntityPropertyValues(objectArray, typeArray);
        if (this.isSubstitutionRequired()) {
            entityPersister.setPropertyValues(object, objectArray, entityMode);
        }
    }
}

