/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog((Class)ReattachVisitor.class);
    private final Serializable ownerIdentifier;
    private final Object owner;

    public ReattachVisitor(EventSource eventSource, Serializable serializable, Object object) {
        super(eventSource);
        this.ownerIdentifier = serializable;
        this.owner = object;
    }

    final Serializable getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    final Object getOwner() {
        return this.owner;
    }

    Object processComponent(Object object, AbstractComponentType abstractComponentType) throws HibernateException {
        Type[] typeArray = abstractComponentType.getSubtypes();
        if (object == null) {
            this.processValues(new Object[typeArray.length], typeArray);
        } else {
            super.processComponent(object, abstractComponentType);
        }
        return null;
    }

    void removeCollection(CollectionPersister collectionPersister, Serializable serializable, EventSource eventSource) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("collection dereferenced while transient " + MessageHelper.collectionInfoString(collectionPersister, this.ownerIdentifier, eventSource.getFactory())));
        }
        eventSource.getActionQueue().addAction(new CollectionRemoveAction(null, collectionPersister, serializable, false, eventSource));
    }

    final Serializable extractCollectionKeyFromOwner(CollectionPersister collectionPersister) {
        if (collectionPersister.getCollectionType().useLHSPrimaryKey()) {
            return this.ownerIdentifier;
        }
        return (Serializable)collectionPersister.getOwnerEntityPersister().getPropertyValue(this.owner, collectionPersister.getCollectionType().getLHSPropertyName(), this.getSession().getEntityMode());
    }
}

