/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.ReattachVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class OnReplicateVisitor
extends ReattachVisitor {
    private boolean isUpdate;

    OnReplicateVisitor(EventSource eventSource, Serializable serializable, Object object, boolean bl) {
        super(eventSource, serializable, object);
        this.isUpdate = bl;
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        EventSource eventSource = this.getSession();
        CollectionPersister collectionPersister = eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        if (this.isUpdate) {
            this.removeCollection(collectionPersister, this.extractCollectionKeyFromOwner(collectionPersister), eventSource);
        }
        if (object != null && object instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)object;
            persistentCollection.setCurrentSession(eventSource);
            if (persistentCollection.wasInitialized()) {
                eventSource.getPersistenceContext().addNewCollection(collectionPersister, persistentCollection);
            } else {
                this.reattachCollection(persistentCollection, collectionType);
            }
        }
        return null;
    }
}

