/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;

public class EvictVisitor
extends AbstractVisitor {
    private static final Log log = LogFactory.getLog((Class)EvictVisitor.class);

    EvictVisitor(EventSource eventSource) {
        super(eventSource);
    }

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object != null) {
            this.evictCollection(object, collectionType);
        }
        return null;
    }

    public void evictCollection(Object object, CollectionType collectionType) {
        Object object2;
        if (collectionType.hasHolder(this.getSession().getEntityMode())) {
            object2 = this.getSession().getPersistenceContext().removeCollectionHolder(object);
        } else if (object instanceof PersistentCollection) {
            object2 = object;
        } else {
            return;
        }
        PersistentCollection persistentCollection = (PersistentCollection)object2;
        if (persistentCollection.unsetSession(this.getSession())) {
            this.evictCollection(persistentCollection);
        }
    }

    private void evictCollection(PersistentCollection persistentCollection) {
        CollectionEntry collectionEntry = (CollectionEntry)this.getSession().getPersistenceContext().getCollectionEntries().remove(persistentCollection);
        if (log.isDebugEnabled()) {
            log.debug((Object)("evicting collection: " + MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), this.getSession().getFactory())));
        }
        if (collectionEntry.getLoadedPersister() != null && collectionEntry.getLoadedKey() != null) {
            this.getSession().getPersistenceContext().getCollectionsByKey().remove(new CollectionKey(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), this.getSession().getEntityMode()));
        }
    }
}

