/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultSaveOrUpdateEventListener.class);

    public void onSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        EventSource eventSource = saveOrUpdateEvent.getSession();
        Object object = saveOrUpdateEvent.getObject();
        Serializable serializable = saveOrUpdateEvent.getRequestedId();
        if (serializable != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(serializable);
        }
        if (this.reassociateIfUninitializedProxy(object, eventSource)) {
            log.trace((Object)"reassociated uninitialized proxy");
        } else {
            Object object2 = eventSource.getPersistenceContext().unproxyAndReassociate(object);
            saveOrUpdateEvent.setEntity(object2);
            saveOrUpdateEvent.setEntry(eventSource.getPersistenceContext().getEntry(object2));
            saveOrUpdateEvent.setResultId(this.performSaveOrUpdate(saveOrUpdateEvent));
        }
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor sessionImplementor) {
        return sessionImplementor.getPersistenceContext().reassociateIfUninitializedProxy(object);
    }

    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        int n = this.getEntityState(saveOrUpdateEvent.getEntity(), saveOrUpdateEvent.getEntityName(), saveOrUpdateEvent.getEntry(), saveOrUpdateEvent.getSession());
        switch (n) {
            case 2: {
                this.entityIsDetached(saveOrUpdateEvent);
                return null;
            }
            case 0: {
                return this.entityIsPersistent(saveOrUpdateEvent);
            }
        }
        return this.entityIsTransient(saveOrUpdateEvent);
    }

    protected Serializable entityIsPersistent(SaveOrUpdateEvent saveOrUpdateEvent) throws HibernateException {
        Serializable serializable;
        log.trace((Object)"ignoring persistent instance");
        EntityEntry entityEntry = saveOrUpdateEvent.getEntry();
        if (entityEntry == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        SessionFactoryImplementor sessionFactoryImplementor = saveOrUpdateEvent.getSession().getFactory();
        Serializable serializable2 = saveOrUpdateEvent.getRequestedId();
        if (serializable2 == null) {
            serializable = entityEntry.getId();
        } else {
            boolean bl;
            boolean bl2 = bl = !entityEntry.getPersister().getIdentifierType().isEqual(serializable2, entityEntry.getId(), saveOrUpdateEvent.getSession().getEntityMode(), sessionFactoryImplementor);
            if (bl) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(entityEntry.getPersister(), serializable2, sessionFactoryImplementor));
            }
            serializable = serializable2;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object already associated with session: " + MessageHelper.infoString(entityEntry.getPersister(), serializable, sessionFactoryImplementor)));
        }
        return serializable;
    }

    protected Serializable entityIsTransient(SaveOrUpdateEvent saveOrUpdateEvent) {
        log.trace((Object)"saving transient instance");
        EventSource eventSource = saveOrUpdateEvent.getSession();
        EntityEntry entityEntry = saveOrUpdateEvent.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                eventSource.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Serializable serializable = this.saveWithGeneratedOrRequestedId(saveOrUpdateEvent);
        eventSource.getPersistenceContext().reassociateProxy(saveOrUpdateEvent.getObject(), serializable);
        return serializable;
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent saveOrUpdateEvent) {
        return this.saveWithGeneratedId(saveOrUpdateEvent.getEntity(), saveOrUpdateEvent.getEntityName(), null, saveOrUpdateEvent.getSession(), true);
    }

    protected void entityIsDetached(SaveOrUpdateEvent saveOrUpdateEvent) {
        log.trace((Object)"updating detached instance");
        if (saveOrUpdateEvent.getSession().getPersistenceContext().isEntryFor(saveOrUpdateEvent.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object object = saveOrUpdateEvent.getEntity();
        EntityPersister entityPersister = saveOrUpdateEvent.getSession().getEntityPersister(saveOrUpdateEvent.getEntityName(), object);
        saveOrUpdateEvent.setRequestedId(this.getUpdateId(object, entityPersister, saveOrUpdateEvent.getRequestedId(), saveOrUpdateEvent.getSession().getEntityMode()));
        this.performUpdate(saveOrUpdateEvent, object, entityPersister);
    }

    protected Serializable getUpdateId(Object object, EntityPersister entityPersister, Serializable serializable, EntityMode entityMode) {
        Serializable serializable2 = entityPersister.getIdentifier(object, entityMode);
        if (serializable2 == null) {
            throw new TransientObjectException("The given object has a null identifier: " + entityPersister.getEntityName());
        }
        return serializable2;
    }

    protected void performUpdate(SaveOrUpdateEvent saveOrUpdateEvent, Object object, EntityPersister entityPersister) throws HibernateException {
        if (!entityPersister.isMutable()) {
            log.trace((Object)"immutable instance passed to doUpdate(), locking");
            this.reassociate(saveOrUpdateEvent, object, saveOrUpdateEvent.getRequestedId(), entityPersister);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("updating " + MessageHelper.infoString(entityPersister, saveOrUpdateEvent.getRequestedId(), saveOrUpdateEvent.getSession().getFactory())));
            }
            EventSource eventSource = saveOrUpdateEvent.getSession();
            EntityKey entityKey = new EntityKey(saveOrUpdateEvent.getRequestedId(), entityPersister, eventSource.getEntityMode());
            eventSource.getPersistenceContext().checkUniqueness(entityKey, object);
            if (this.invokeUpdateLifecycle(object, entityPersister, eventSource)) {
                this.reassociate(saveOrUpdateEvent, saveOrUpdateEvent.getObject(), saveOrUpdateEvent.getRequestedId(), entityPersister);
                return;
            }
            new OnUpdateVisitor(eventSource, saveOrUpdateEvent.getRequestedId(), object).process(object, entityPersister);
            eventSource.getPersistenceContext().addEntity(object, Status.MANAGED, null, entityKey, entityPersister.getVersion(object, eventSource.getEntityMode()), LockMode.NONE, true, entityPersister, false, true);
            entityPersister.afterReassociate(object, eventSource);
            if (log.isTraceEnabled()) {
                log.trace((Object)("updating " + MessageHelper.infoString(entityPersister, saveOrUpdateEvent.getRequestedId(), eventSource.getFactory())));
            }
            this.cascadeOnUpdate(saveOrUpdateEvent, entityPersister, object);
        }
    }

    protected boolean invokeUpdateLifecycle(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (entityPersister.implementsLifecycle(eventSource.getEntityMode())) {
            log.debug((Object)"calling onUpdate()");
            if (((Lifecycle)object).onUpdate(eventSource)) {
                log.debug((Object)"update vetoed by onUpdate()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent saveOrUpdateEvent, EntityPersister entityPersister, Object object) {
        EventSource eventSource = saveOrUpdateEvent.getSession();
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.SAVE_UPDATE, 0, eventSource).cascade(entityPersister, object);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.SAVE_UPDATE;
    }
}

