/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.def.EvictVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.hibernate.util.IdentityMap;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultRefreshEventListener.class);

    public void onRefresh(RefreshEvent refreshEvent) throws HibernateException {
        this.onRefresh(refreshEvent, IdentityMap.instantiate(10));
    }

    public void onRefresh(RefreshEvent refreshEvent, Map map) throws HibernateException {
        Object object;
        Serializable serializable;
        EntityPersister entityPersister;
        EventSource eventSource = refreshEvent.getSession();
        if (eventSource.getPersistenceContext().reassociateIfUninitializedProxy(refreshEvent.getObject())) {
            return;
        }
        Object object2 = eventSource.getPersistenceContext().unproxyAndReassociate(refreshEvent.getObject());
        if (map.containsKey(object2)) {
            log.trace((Object)"already refreshed");
            return;
        }
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object2);
        if (entityEntry == null) {
            entityPersister = eventSource.getEntityPersister(null, object2);
            serializable = entityPersister.getIdentifier(object2, refreshEvent.getSession().getEntityMode());
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing transient " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory())));
            }
            object = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            if (eventSource.getPersistenceContext().getEntry(object) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing " + MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), eventSource.getFactory())));
            }
            if (!entityEntry.isExistsInDatabase()) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            entityPersister = entityEntry.getPersister();
            serializable = entityEntry.getId();
        }
        map.put(object2, object2);
        new Cascade(CascadingAction.REFRESH, 0, eventSource).cascade(entityPersister, object2, map);
        if (entityEntry != null) {
            object = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            eventSource.getPersistenceContext().removeEntity((EntityKey)object);
            if (entityPersister.hasCollections()) {
                new EvictVisitor(eventSource).process(object2, entityPersister);
            }
        }
        if (entityPersister.hasCache()) {
            object = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), eventSource.getEntityMode(), eventSource.getFactory());
            entityPersister.getCache().remove(object);
        }
        this.evictCachedCollections(entityPersister, serializable, eventSource.getFactory());
        object = eventSource.getFetchProfile();
        eventSource.setFetchProfile("refresh");
        Object object3 = entityPersister.load(serializable, object2, refreshEvent.getLockMode(), eventSource);
        eventSource.setFetchProfile((String)object);
        UnresolvableObjectException.throwIfNull(object3, serializable, entityPersister.getEntityName());
    }

    private void evictCachedCollections(EntityPersister entityPersister, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        this.evictCachedCollections(entityPersister.getPropertyTypes(), serializable, sessionFactoryImplementor);
    }

    private void evictCachedCollections(Type[] typeArray, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].isCollectionType()) {
                sessionFactoryImplementor.evictCollection(((CollectionType)typeArray[i]).getRole(), serializable);
                continue;
            }
            if (!typeArray[i].isComponentType()) continue;
            AbstractComponentType abstractComponentType = (AbstractComponentType)typeArray[i];
            this.evictCachedCollections(abstractComponentType.getSubtypes(), serializable, sessionFactoryImplementor);
        }
    }
}

