/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.CascadingAction;
import org.hibernate.event.EventSource;
import org.hibernate.event.PersistEvent;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.util.IdentityMap;

public class DefaultPersistEventListener
extends AbstractSaveEventListener
implements PersistEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultPersistEventListener.class);

    public void onPersist(PersistEvent persistEvent) throws HibernateException {
        this.onPersist(persistEvent, IdentityMap.instantiate(10));
    }

    public void onPersist(PersistEvent persistEvent, Map map) throws HibernateException {
        Object object;
        EventSource eventSource = persistEvent.getSession();
        Object object2 = persistEvent.getObject();
        if (object2 instanceof HibernateProxy) {
            LazyInitializer lazyInitializer = ((HibernateProxy)object2).getHibernateLazyInitializer();
            if (lazyInitializer.isUninitialized()) {
                if (lazyInitializer.getSession() == eventSource) {
                    return;
                }
                throw new PersistentObjectException("uninitialized proxy passed to persist()");
            }
            object = lazyInitializer.getImplementation();
        } else {
            object = object2;
        }
        int n = this.getEntityState(object, persistEvent.getEntityName(), eventSource.getPersistenceContext().getEntry(object), eventSource);
        switch (n) {
            case 2: {
                throw new PersistentObjectException("detached entity passed to persist: " + this.getLoggableName(persistEvent.getEntityName(), object));
            }
            case 0: {
                this.entityIsPersistent(persistEvent, map);
                break;
            }
            case 1: {
                this.entityIsTransient(persistEvent, map);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to persist", null, this.getLoggableName(persistEvent.getEntityName(), object));
            }
        }
    }

    protected void entityIsPersistent(PersistEvent persistEvent, Map map) {
        log.trace((Object)"ignoring persistent instance");
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        EntityPersister entityPersister = eventSource.getEntityPersister(persistEvent.getEntityName(), object);
        if (map.put(object, object) == null) {
            this.cascadeBeforeSave(eventSource, entityPersister, object, map);
            this.cascadeAfterSave(eventSource, entityPersister, object, map);
        }
    }

    protected void entityIsTransient(PersistEvent persistEvent, Map map) throws HibernateException {
        log.trace((Object)"saving transient instance");
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        if (map.put(object, object) == null) {
            this.saveWithGeneratedId(object, persistEvent.getEntityName(), map, eventSource, false);
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.PERSIST;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.TRUE;
    }
}

