/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.IdentityMap;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultMergeEventListener.class);

    protected Map getMergeMap(Object object) {
        return IdentityMap.invert((Map)object);
    }

    public void onMerge(MergeEvent mergeEvent) throws HibernateException {
        this.onMerge(mergeEvent, IdentityMap.instantiate(10));
    }

    public void onMerge(MergeEvent mergeEvent, Map map) throws HibernateException {
        EventSource eventSource = mergeEvent.getSession();
        Object object = mergeEvent.getOriginal();
        if (object != null) {
            Object object2;
            if (object instanceof HibernateProxy) {
                LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
                if (lazyInitializer.isUninitialized()) {
                    log.trace((Object)"ignoring uninitialized proxy");
                    mergeEvent.setResult(eventSource.load(lazyInitializer.getEntityName(), lazyInitializer.getIdentifier()));
                    return;
                }
                object2 = lazyInitializer.getImplementation();
            } else {
                object2 = object;
            }
            if (map.containsKey(object2)) {
                log.trace((Object)"already merged");
                mergeEvent.setResult(object2);
            } else {
                EntityPersister entityPersister;
                Serializable serializable;
                mergeEvent.setEntity(object2);
                int n = -1;
                EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object2);
                if (entityEntry == null && (serializable = (entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object2)).getIdentifier(object2, eventSource.getEntityMode())) != null) {
                    EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
                    Object object3 = eventSource.getPersistenceContext().getEntity(entityKey);
                    entityEntry = eventSource.getPersistenceContext().getEntry(object3);
                    if (entityEntry != null) {
                        n = 2;
                    }
                }
                if (n == -1) {
                    n = this.getEntityState(object2, mergeEvent.getEntityName(), entityEntry, eventSource);
                }
                switch (n) {
                    case 2: {
                        this.entityIsDetached(mergeEvent, map);
                        break;
                    }
                    case 1: {
                        this.entityIsTransient(mergeEvent, map);
                        break;
                    }
                    case 0: {
                        this.entityIsPersistent(mergeEvent, map);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(mergeEvent.getEntityName(), object2));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent mergeEvent, Map map) {
        log.trace((Object)"ignoring persistent instance");
        Object object = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object);
        map.put(object, object);
        this.cascadeOnMerge(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, object, eventSource, map);
        mergeEvent.setResult(object);
    }

    protected void entityIsTransient(MergeEvent mergeEvent, Map map) {
        log.trace((Object)"merging transient instance");
        Object object = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object);
        String string = entityPersister.getEntityName();
        Serializable serializable = entityPersister.hasIdentifierProperty() ? entityPersister.getIdentifier(object, eventSource.getEntityMode()) : null;
        Object object2 = entityPersister.instantiate(serializable, eventSource.getEntityMode());
        map.put(object, object2);
        super.cascadeBeforeSave(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, object2, eventSource, map, ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT);
        Serializable serializable2 = mergeEvent.getRequestedId();
        if (serializable2 == null) {
            this.saveWithGeneratedId(object2, string, map, eventSource, false);
        } else {
            this.saveWithRequestedId(object2, serializable2, string, map, eventSource);
        }
        super.cascadeAfterSave(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, object2, eventSource, map, ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        mergeEvent.setResult(object2);
    }

    protected void entityIsDetached(MergeEvent mergeEvent, Map map) {
        Object object;
        log.trace((Object)"merging detached instance");
        Object object2 = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object2);
        String string = entityPersister.getEntityName();
        Serializable serializable = mergeEvent.getRequestedId();
        if (serializable == null) {
            serializable = entityPersister.getIdentifier(object2, eventSource.getEntityMode());
        } else {
            object = entityPersister.getIdentifier(object2, eventSource.getEntityMode());
            if (!entityPersister.getIdentifierType().isEqual(serializable, object, eventSource.getEntityMode(), eventSource.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        object = eventSource.getFetchProfile();
        eventSource.setFetchProfile("merge");
        Serializable serializable2 = (Serializable)entityPersister.getIdentifierType().deepCopy(serializable, eventSource.getEntityMode(), eventSource.getFactory());
        Object object3 = eventSource.get(string, serializable2);
        eventSource.setFetchProfile((String)object);
        if (object3 == null) {
            this.entityIsTransient(mergeEvent, map);
        } else {
            map.put(object2, object3);
            Object object4 = eventSource.getPersistenceContext().unproxy(object3);
            if (object4 == object2) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!eventSource.getEntityName(object4).equals(string)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", mergeEvent.getRequestedId(), string);
            }
            if (this.isVersionChanged(object2, eventSource, entityPersister, object4)) {
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().optimisticFailure(string);
                }
                throw new StaleObjectStateException(string, serializable);
            }
            this.cascadeOnMerge(eventSource, entityPersister, object2, map);
            this.copyValues(entityPersister, object2, object4, eventSource, map);
            this.markInterceptorDirty(object2, object4);
            mergeEvent.setResult(object3);
        }
    }

    private void markInterceptorDirty(Object object, Object object2) {
        FieldInterceptor fieldInterceptor;
        if (FieldInterceptionHelper.isInstrumented(object) && (fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object2)) != null) {
            fieldInterceptor.dirty();
        }
    }

    private boolean isVersionChanged(Object object, EventSource eventSource, EntityPersister entityPersister, Object object2) {
        if (!entityPersister.isVersioned()) {
            return false;
        }
        boolean bl = !entityPersister.getVersionType().isSame(entityPersister.getVersion(object2, eventSource.getEntityMode()), entityPersister.getVersion(object, eventSource.getEntityMode()), eventSource.getEntityMode());
        return bl && this.existsInDatabase(object2, eventSource, entityPersister);
    }

    private boolean existsInDatabase(Object object, EventSource eventSource, EntityPersister entityPersister) {
        Serializable serializable;
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        if (entityEntry == null && (serializable = entityPersister.getIdentifier(object, eventSource.getEntityMode())) != null) {
            EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            Object object2 = eventSource.getPersistenceContext().getEntity(entityKey);
            entityEntry = eventSource.getPersistenceContext().getEntry(object2);
        }
        if (entityEntry == null) {
            return false;
        }
        return entityEntry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister entityPersister, Object object, Object object2, SessionImplementor sessionImplementor, Map map) {
        Object[] objectArray = TypeFactory.replace(entityPersister.getPropertyValues(object, sessionImplementor.getEntityMode()), entityPersister.getPropertyValues(object2, sessionImplementor.getEntityMode()), entityPersister.getPropertyTypes(), sessionImplementor, object2, map);
        entityPersister.setPropertyValues(object2, objectArray, sessionImplementor.getEntityMode());
    }

    protected void copyValues(EntityPersister entityPersister, Object object, Object object2, SessionImplementor sessionImplementor, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray = foreignKeyDirection == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT ? TypeFactory.replaceAssociations(entityPersister.getPropertyValues(object, sessionImplementor.getEntityMode()), entityPersister.getPropertyValues(object2, sessionImplementor.getEntityMode()), entityPersister.getPropertyTypes(), sessionImplementor, object2, map, foreignKeyDirection) : TypeFactory.replace(entityPersister.getPropertyValues(object, sessionImplementor.getEntityMode()), entityPersister.getPropertyValues(object2, sessionImplementor.getEntityMode()), entityPersister.getPropertyTypes(), sessionImplementor, object2, map, foreignKeyDirection);
        entityPersister.setPropertyValues(object2, objectArray, sessionImplementor.getEntityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource eventSource, EntityPersister entityPersister, Object object, Map map) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 0, eventSource).cascade(entityPersister, object, map);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.MERGE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    protected void cascadeAfterSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
    }

    protected void cascadeBeforeSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
    }
}

