/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.def.AbstractLockUpgradeEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultLoadEventListener
extends AbstractLockUpgradeEventListener
implements LoadEventListener {
    public static final Object REMOVED_ENTITY_MARKER = new Object();
    public static final Object INCONSISTENT_RTN_CLASS_MARKER = new Object();
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private static final Log log = LogFactory.getLog((Class)DefaultLoadEventListener.class);

    public void onLoad(LoadEvent loadEvent, LoadEventListener.LoadType loadType) throws HibernateException {
        Serializable serializable;
        EntityPersister entityPersister;
        EventSource eventSource = loadEvent.getSession();
        if (loadEvent.getInstanceToLoad() != null) {
            entityPersister = eventSource.getEntityPersister(null, loadEvent.getInstanceToLoad());
            loadEvent.setEntityClassName(loadEvent.getInstanceToLoad().getClass().getName());
        } else {
            entityPersister = eventSource.getFactory().getEntityPersister(loadEvent.getEntityClassName());
        }
        if (entityPersister == null) {
            throw new HibernateException("Unable to locate persister: " + loadEvent.getEntityClassName());
        }
        if (!(entityPersister.getIdentifierType().isComponentType() && EntityMode.DOM4J == loadEvent.getSession().getEntityMode() || (serializable = entityPersister.getIdentifierType().getReturnedClass()) == null || serializable.isInstance(loadEvent.getEntityId()))) {
            throw new TypeMismatchException("Provided id of the wrong type. Expected: " + serializable + ", got " + loadEvent.getEntityId().getClass());
        }
        serializable = new EntityKey(loadEvent.getEntityId(), entityPersister, eventSource.getEntityMode());
        try {
            if (loadType.isNakedEntityReturned()) {
                loadEvent.setResult(this.load(loadEvent, entityPersister, (EntityKey)serializable, loadType));
            } else if (loadEvent.getLockMode() == LockMode.NONE) {
                loadEvent.setResult(this.proxyOrLoad(loadEvent, entityPersister, (EntityKey)serializable, loadType));
            } else {
                loadEvent.setResult(this.lockAndLoad(loadEvent, entityPersister, (EntityKey)serializable, loadType, eventSource));
            }
        }
        catch (HibernateException hibernateException) {
            log.info((Object)"Error performing load command", (Throwable)hibernateException);
            throw hibernateException;
        }
    }

    protected Object load(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) throws HibernateException {
        boolean bl;
        if (loadEvent.getInstanceToLoad() != null) {
            if (loadEvent.getSession().getPersistenceContext().getEntry(loadEvent.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory()));
            }
            entityPersister.setIdentifier(loadEvent.getInstanceToLoad(), loadEvent.getEntityId(), loadEvent.getSession().getEntityMode());
        }
        Object object = this.doLoad(loadEvent, entityPersister, entityKey, loadType);
        boolean bl2 = bl = loadEvent.getInstanceToLoad() != null;
        if ((!loadType.isAllowNulls() || bl) && object == null) {
            loadEvent.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(loadEvent.getEntityClassName(), loadEvent.getEntityId());
        }
        if (bl && object != loadEvent.getInstanceToLoad()) {
            throw new NonUniqueObjectException(loadEvent.getEntityId(), loadEvent.getEntityClassName());
        }
        return object;
    }

    protected Object proxyOrLoad(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading entity: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory())));
        }
        if (!entityPersister.hasProxy()) {
            return this.load(loadEvent, entityPersister, entityKey, loadType);
        }
        PersistenceContext persistenceContext = loadEvent.getSession().getPersistenceContext();
        Object object = persistenceContext.getProxy(entityKey);
        if (object != null) {
            return this.returnNarrowedProxy(loadEvent, entityPersister, entityKey, loadType, persistenceContext, object);
        }
        if (loadType.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(loadEvent, entityPersister, entityKey, loadType, persistenceContext);
        }
        return this.load(loadEvent, entityPersister, entityKey, loadType);
    }

    private Object returnNarrowedProxy(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType, PersistenceContext persistenceContext, Object object) {
        log.trace((Object)"entity proxy found in session cache");
        LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
        if (lazyInitializer.isUnwrap()) {
            return lazyInitializer.getImplementation();
        }
        Object object2 = null;
        if (!loadType.isAllowProxyCreation() && (object2 = this.load(loadEvent, entityPersister, entityKey, loadType)) == null) {
            loadEvent.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityPersister.getEntityName(), entityKey.getIdentifier());
        }
        return persistenceContext.narrowProxy(object, entityPersister, entityKey, object2);
    }

    private Object createProxyIfNecessary(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType, PersistenceContext persistenceContext) {
        Object object = persistenceContext.getEntity(entityKey);
        if (object != null) {
            EntityEntry entityEntry;
            Status status;
            log.trace((Object)"entity found in session cache");
            if (loadType.isCheckDeleted() && ((status = (entityEntry = persistenceContext.getEntry(object)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return object;
        }
        log.trace((Object)"creating new proxy for entity");
        Object object2 = entityPersister.createProxy(loadEvent.getEntityId(), loadEvent.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
        persistenceContext.addProxy(entityKey, object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object lockAndLoad(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType, SessionImplementor sessionImplementor) throws HibernateException {
        Object object;
        CacheKey cacheKey;
        CacheConcurrencyStrategy.SoftLock softLock = null;
        if (entityPersister.hasCache()) {
            cacheKey = new CacheKey(loadEvent.getEntityId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            softLock = entityPersister.getCache().lock(cacheKey, null);
        } else {
            cacheKey = null;
        }
        try {
            object = this.load(loadEvent, entityPersister, entityKey, loadType);
            Object var10_9 = null;
            if (!entityPersister.hasCache()) return loadEvent.getSession().getPersistenceContext().proxyFor(entityPersister, entityKey, object);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!entityPersister.hasCache()) throw throwable;
            entityPersister.getCache().release(cacheKey, softLock);
            throw throwable;
        }
        entityPersister.getCache().release(cacheKey, softLock);
        return loadEvent.getSession().getPersistenceContext().proxyFor(entityPersister, entityKey, object);
    }

    protected Object doLoad(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) throws HibernateException {
        Object object;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to resolve: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory())));
        }
        if ((object = this.loadFromSessionCache(loadEvent, entityKey, loadType)) == REMOVED_ENTITY_MARKER) {
            log.debug((Object)"load request found matching entity in context, but it is scheduled for removal; returning null");
            return null;
        }
        if (object == INCONSISTENT_RTN_CLASS_MARKER) {
            log.debug((Object)"load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
            return null;
        }
        if (object != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in session cache: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory())));
            }
            return object;
        }
        object = this.loadFromSecondLevelCache(loadEvent, entityPersister, loadType);
        if (object != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in second-level cache: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory())));
            }
            return object;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object not resolved in any cache: " + MessageHelper.infoString(entityPersister, loadEvent.getEntityId(), loadEvent.getSession().getFactory())));
        }
        return this.loadFromDatasource(loadEvent, entityPersister, entityKey, loadType);
    }

    protected Object loadFromDatasource(LoadEvent loadEvent, EntityPersister entityPersister, EntityKey entityKey, LoadEventListener.LoadType loadType) throws HibernateException {
        EventSource eventSource = loadEvent.getSession();
        Object object = entityPersister.load(loadEvent.getEntityId(), loadEvent.getInstanceToLoad(), loadEvent.getLockMode(), eventSource);
        if (loadEvent.isAssociationFetch() && eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
            eventSource.getFactory().getStatisticsImplementor().fetchEntity(loadEvent.getEntityClassName());
        }
        return object;
    }

    protected Object loadFromSessionCache(LoadEvent loadEvent, EntityKey entityKey, LoadEventListener.LoadType loadType) throws HibernateException {
        EventSource eventSource = loadEvent.getSession();
        Object object = eventSource.getEntityUsingInterceptor(entityKey);
        if (object != null) {
            Object object2;
            EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
            if (loadType.isCheckDeleted() && ((object2 = entityEntry.getStatus()) == Status.DELETED || object2 == Status.GONE)) {
                return REMOVED_ENTITY_MARKER;
            }
            if (loadType.isAllowNulls() && !(object2 = loadEvent.getSession().getFactory().getEntityPersister(loadEvent.getEntityClassName())).isInstance(object, loadEvent.getSession().getEntityMode())) {
                return INCONSISTENT_RTN_CLASS_MARKER;
            }
            this.upgradeLock(object, entityEntry, loadEvent.getLockMode(), eventSource);
        }
        return object;
    }

    protected Object loadFromSecondLevelCache(LoadEvent loadEvent, EntityPersister entityPersister, LoadEventListener.LoadType loadType) throws HibernateException {
        boolean bl;
        EventSource eventSource = loadEvent.getSession();
        boolean bl2 = bl = entityPersister.hasCache() && eventSource.getCacheMode().isGetEnabled() && loadEvent.getLockMode().lessThan(LockMode.READ);
        if (bl) {
            SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
            CacheKey cacheKey = new CacheKey(loadEvent.getEntityId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), eventSource.getEntityMode(), eventSource.getFactory());
            Object object = entityPersister.getCache().get(cacheKey, eventSource.getTimestamp());
            if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                if (object == null) {
                    sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheMiss(entityPersister.getCache().getRegionName());
                } else {
                    sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheHit(entityPersister.getCache().getRegionName());
                }
            }
            if (object != null) {
                CacheEntry cacheEntry = (CacheEntry)entityPersister.getCacheEntryStructure().destructure(object, sessionFactoryImplementor);
                return this.assembleCacheEntry(cacheEntry, loadEvent.getEntityId(), entityPersister, loadEvent);
            }
        }
        return null;
    }

    private Object assembleCacheEntry(CacheEntry cacheEntry, Serializable serializable, EntityPersister entityPersister, LoadEvent loadEvent) throws HibernateException {
        Object object = loadEvent.getInstanceToLoad();
        EventSource eventSource = loadEvent.getSession();
        SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
        if (log.isTraceEnabled()) {
            log.trace((Object)("assembling entity from second-level cache: " + MessageHelper.infoString(entityPersister, serializable, sessionFactoryImplementor)));
        }
        EntityPersister entityPersister2 = sessionFactoryImplementor.getEntityPersister(cacheEntry.getSubclass());
        Object object2 = object == null ? eventSource.instantiate(entityPersister2, serializable) : object;
        TwoPhaseLoad.addUninitializedCachedEntity(new EntityKey(serializable, entityPersister2, eventSource.getEntityMode()), object2, entityPersister2, LockMode.NONE, cacheEntry.areLazyPropertiesUnfetched(), cacheEntry.getVersion(), eventSource);
        Type[] typeArray = entityPersister2.getPropertyTypes();
        Object[] objectArray = cacheEntry.assemble(object2, serializable, entityPersister2, eventSource.getInterceptor(), eventSource);
        TypeFactory.deepCopy(objectArray, typeArray, entityPersister2.getPropertyUpdateability(), objectArray, eventSource);
        Object object3 = Versioning.getVersion(objectArray, entityPersister2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cached Version: " + object3));
        }
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        persistenceContext.addEntry(object2, Status.MANAGED, objectArray, null, serializable, object3, LockMode.NONE, true, entityPersister2, false, cacheEntry.areLazyPropertiesUnfetched());
        entityPersister2.afterInitialize(object2, cacheEntry.areLazyPropertiesUnfetched(), eventSource);
        persistenceContext.initializeNonLazyCollections();
        PostLoadEvent postLoadEvent = new PostLoadEvent(eventSource).setEntity(object2).setId(serializable).setPersister(entityPersister);
        PostLoadEventListener[] postLoadEventListenerArray = eventSource.getListeners().getPostLoadEventListeners();
        for (int i = 0; i < postLoadEventListenerArray.length; ++i) {
            postLoadEventListenerArray[i].onPostLoad(postLoadEvent);
        }
        return object2;
    }
}

