/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultInitializeCollectionEventListener.class);

    public void onInitializeCollection(InitializeCollectionEvent initializeCollectionEvent) throws HibernateException {
        PersistentCollection persistentCollection = initializeCollectionEvent.getCollection();
        EventSource eventSource = initializeCollectionEvent.getSession();
        CollectionEntry collectionEntry = eventSource.getPersistenceContext().getCollectionEntry(persistentCollection);
        if (collectionEntry == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!persistentCollection.wasInitialized()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("initializing collection " + MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), eventSource.getFactory())));
            }
            log.trace((Object)"checking second-level cache");
            boolean bl = this.initializeCollectionFromCache(collectionEntry.getLoadedKey(), collectionEntry.getLoadedPersister(), persistentCollection, eventSource);
            if (bl) {
                log.trace((Object)"collection initialized from cache");
            } else {
                log.trace((Object)"collection not cached");
                collectionEntry.getLoadedPersister().initialize(collectionEntry.getLoadedKey(), eventSource);
                log.trace((Object)"collection initialized");
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().fetchCollection(collectionEntry.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable serializable, CollectionPersister collectionPersister, PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        if (!sessionImplementor.getEnabledFilters().isEmpty() && collectionPersister.isAffectedByEnabledFilters(sessionImplementor)) {
            log.trace((Object)"disregarding cached version (if any) of collection due to enabled filters ");
            return false;
        }
        boolean bl2 = bl = collectionPersister.hasCache() && sessionImplementor.getCacheMode().isGetEnabled();
        if (!bl) {
            return false;
        }
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        CacheKey cacheKey = new CacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
        Object object = collectionPersister.getCache().get(cacheKey, sessionImplementor.getTimestamp());
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            if (object == null) {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheMiss(collectionPersister.getCache().getRegionName());
            } else {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCacheHit(collectionPersister.getCache().getRegionName());
            }
        }
        if (object == null) {
            return false;
        }
        CollectionCacheEntry collectionCacheEntry = (CollectionCacheEntry)collectionPersister.getCacheEntryStructure().destructure(object, sessionFactoryImplementor);
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        collectionCacheEntry.assemble(persistentCollection, collectionPersister, persistenceContext.getCollectionOwner(serializable, collectionPersister));
        persistenceContext.getCollectionEntry(persistentCollection).postInitialize(persistentCollection);
        return true;
    }
}

