/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.event.EventSource;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.def.EvictVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultEvictEventListener
implements EvictEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultEvictEventListener.class);

    public void onEvict(EvictEvent evictEvent) throws HibernateException {
        EventSource eventSource = evictEvent.getSession();
        Object object = evictEvent.getObject();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        if (object instanceof HibernateProxy) {
            Object object2;
            LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            Serializable serializable = lazyInitializer.getIdentifier();
            EntityPersister entityPersister = eventSource.getFactory().getEntityPersister(lazyInitializer.getEntityName());
            if (serializable == null) {
                throw new IllegalArgumentException("null identifier");
            }
            EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            persistenceContext.removeProxy(entityKey);
            if (!lazyInitializer.isUninitialized() && (object2 = persistenceContext.removeEntity(entityKey)) != null) {
                EntityEntry entityEntry = evictEvent.getSession().getPersistenceContext().removeEntry(object2);
                this.doEvict(object2, entityKey, entityEntry.getPersister(), evictEvent.getSession());
            }
            lazyInitializer.setSession(null);
        } else {
            EntityEntry entityEntry = persistenceContext.removeEntry(object);
            if (entityEntry != null) {
                EntityKey entityKey = new EntityKey(entityEntry.getId(), entityEntry.getPersister(), eventSource.getEntityMode());
                persistenceContext.removeEntity(entityKey);
                this.doEvict(object, entityKey, entityEntry.getPersister(), eventSource);
            }
        }
    }

    protected void doEvict(Object object, EntityKey entityKey, EntityPersister entityPersister, EventSource eventSource) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("evicting " + MessageHelper.infoString(entityPersister)));
        }
        if (entityPersister.hasCollections()) {
            new EvictVisitor(eventSource).process(object, entityPersister);
        }
        new Cascade(CascadingAction.EVICT, 0, eventSource).cascade(entityPersister, object);
    }
}

