/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.def.AbstractFlushingEventListener;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final Log log = LogFactory.getLog((Class)DefaultDirtyCheckEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDirtyCheck(DirtyCheckEvent dirtyCheckEvent) throws HibernateException {
        int n = dirtyCheckEvent.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(dirtyCheckEvent);
            boolean bl = dirtyCheckEvent.getSession().getActionQueue().hasAnyQueuedActions();
            log.debug((Object)(bl ? "session dirty" : "session not dirty"));
            dirtyCheckEvent.setDirty(bl);
        }
        finally {
            dirtyCheckEvent.getSession().getActionQueue().clearFromFlushNeededCheck(n);
        }
    }
}

