/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final Log log = LogFactory.getLog((Class)AbstractLockUpgradeEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entityEntry, LockMode lockMode, SessionImplementor sessionImplementor) throws HibernateException {
        CacheConcurrencyStrategy.SoftLock softLock;
        CacheKey cacheKey;
        if (!lockMode.greaterThan(entityEntry.getLockMode())) return;
        if (entityEntry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        EntityPersister entityPersister = entityEntry.getPersister();
        if (log.isTraceEnabled()) {
            log.trace((Object)("locking " + MessageHelper.infoString(entityPersister, entityEntry.getId(), sessionImplementor.getFactory()) + " in mode: " + lockMode));
        }
        if (entityPersister.hasCache()) {
            cacheKey = new CacheKey(entityEntry.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            softLock = entityPersister.getCache().lock(cacheKey, entityEntry.getVersion());
        } else {
            cacheKey = null;
            softLock = null;
        }
        try {
            if (entityPersister.isVersioned() && lockMode == LockMode.FORCE) {
                Object object2 = entityPersister.forceVersionIncrement(entityEntry.getId(), entityEntry.getVersion(), sessionImplementor);
                entityEntry.forceLocked(object, object2);
            } else {
                entityPersister.lock(entityEntry.getId(), entityEntry.getVersion(), object, lockMode, sessionImplementor);
            }
            entityEntry.setLockMode(lockMode);
            Object var10_9 = null;
            if (!entityPersister.hasCache()) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!entityPersister.hasCache()) throw throwable;
            entityPersister.getCache().release(cacheKey, softLock);
            throw throwable;
        }
        entityPersister.getCache().release(cacheKey, softLock);
    }
}

