/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.EventSource;

public class LoadEvent
extends AbstractEvent {
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private Serializable entityId;
    private String entityClassName;
    private Object instanceToLoad;
    private LockMode lockMode;
    private boolean isAssociationFetch;
    private Object result;

    public LoadEvent(Serializable serializable, Object object, EventSource eventSource) {
        this(serializable, null, object, null, false, eventSource);
    }

    public LoadEvent(Serializable serializable, String string, LockMode lockMode, EventSource eventSource) {
        this(serializable, string, null, lockMode, false, eventSource);
    }

    public LoadEvent(Serializable serializable, String string, boolean bl, EventSource eventSource) {
        this(serializable, string, null, null, bl, eventSource);
    }

    public boolean isAssociationFetch() {
        return this.isAssociationFetch;
    }

    private LoadEvent(Serializable serializable, String string, Object object, LockMode lockMode, boolean bl, EventSource eventSource) {
        super(eventSource);
        if (serializable == null) {
            throw new IllegalArgumentException("id to load is required for loading");
        }
        if (lockMode == LockMode.WRITE) {
            throw new IllegalArgumentException("Invalid lock mode for loading");
        }
        if (lockMode == null) {
            lockMode = DEFAULT_LOCK_MODE;
        }
        this.entityId = serializable;
        this.entityClassName = string;
        this.instanceToLoad = object;
        this.lockMode = lockMode;
        this.isAssociationFetch = bl;
    }

    public Serializable getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Serializable serializable) {
        this.entityId = serializable;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String string) {
        this.entityClassName = string;
    }

    public Object getInstanceToLoad() {
        return this.instanceToLoad;
    }

    public void setInstanceToLoad(Object object) {
        this.instanceToLoad = object;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object object) {
        this.result = object;
    }
}

