/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;

public class Isolater {
    private static final Log log = LogFactory.getLog((Class)Isolater.class);

    public static void doIsolatedWork(IsolatedWork isolatedWork, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = sessionImplementor.getFactory().getTransactionManager() != null;
        if (bl) {
            new JtaDelegate(sessionImplementor).delegateWork(isolatedWork, true);
        } else {
            new JdbcDelegate(sessionImplementor).delegateWork(isolatedWork, true);
        }
    }

    public static void doNonTransactedWork(IsolatedWork isolatedWork, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = sessionImplementor.getFactory().getTransactionManager() != null;
        if (bl) {
            new JtaDelegate(sessionImplementor).delegateWork(isolatedWork, false);
        } else {
            new JdbcDelegate(sessionImplementor).delegateWork(isolatedWork, false);
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1, boolean var2) throws HibernateException;
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        /*
         * Loose catch block
         */
        public void delegateWork(IsolatedWork isolatedWork, boolean bl) throws HibernateException {
            Connection connection;
            block15: {
                boolean bl2;
                block14: {
                    connection = null;
                    bl2 = false;
                    connection = this.session.getBatcher().openConnection();
                    if (bl && connection.getAutoCommit()) {
                        bl2 = true;
                        connection.setAutoCommit(false);
                    }
                    isolatedWork.doWork(connection);
                    if (!bl) break block14;
                    connection.commit();
                }
                Object var8_5 = null;
                if (!bl || !bl2) break block15;
                try {
                    connection.setAutoCommit(true);
                    break block15;
                }
                catch (Throwable throwable) {
                    log.trace((Object)"was unable to reset connection back to auto-commit");
                }
                {
                    break block15;
                    catch (Throwable throwable) {
                        try {
                            if (bl && connection != null && !connection.isClosed()) {
                                connection.rollback();
                            }
                        }
                        catch (Throwable throwable2) {
                            log.trace((Object)("unable to release connection on exception [" + throwable2 + "]"));
                        }
                        if (throwable instanceof HibernateException) {
                            throw (HibernateException)throwable;
                        }
                        if (throwable instanceof SQLException) {
                            throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), (SQLException)throwable, "error performing isolated work");
                        }
                        throw new HibernateException("error performing isolated work", throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    if (bl && bl2) {
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (Throwable throwable3) {
                            log.trace((Object)"was unable to reset connection back to auto-commit");
                        }
                    }
                    this.session.getBatcher().closeConnection(connection);
                    throw throwable;
                }
            }
            this.session.getBatcher().closeConnection(connection);
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void delegateWork(IsolatedWork isolatedWork, boolean bl) throws HibernateException {
            TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
            Transaction transaction = null;
            Connection connection = null;
            boolean bl2 = false;
            try {
                try {
                    transaction = transactionManager.suspend();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("surrounding JTA transaction suspended [" + transaction + "]"));
                    }
                    if (bl) {
                        transactionManager.begin();
                    }
                    connection = this.session.getBatcher().openConnection();
                    isolatedWork.doWork(connection);
                    this.session.getBatcher().closeConnection(connection);
                    if (bl) {
                        transactionManager.commit();
                    }
                }
                catch (Throwable throwable) {
                    bl2 = true;
                    try {
                        if (connection != null && !connection.isClosed()) {
                            this.session.getBatcher().closeConnection(connection);
                        }
                    }
                    catch (Throwable throwable2) {
                        log.trace((Object)("unable to release connection on exception [" + throwable2 + "]"));
                    }
                    if (bl) {
                        try {
                            transactionManager.rollback();
                        }
                        catch (Throwable throwable3) {
                            log.trace((Object)("unable to rollback new transaction on exception [" + throwable3 + "]"));
                        }
                    }
                    if (!(throwable instanceof HibernateException)) throw new HibernateException("error performing isolated work", throwable);
                    throw (HibernateException)throwable;
                }
                Object var10_7 = null;
                if (transaction == null) return;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (transaction == null) throw throwable;
                try {
                    transactionManager.resume(transaction);
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug((Object)("surrounding JTA transaction resumed [" + transaction + "]"));
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    if (bl2) throw throwable;
                    throw new HibernateException("unable to resume previously suspended transaction", throwable4);
                }
            }
            try {}
            catch (Throwable throwable) {
                if (bl2) return;
                throw new HibernateException("unable to resume previously suspended transaction", throwable);
            }
            transactionManager.resume(transaction);
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("surrounding JTA transaction resumed [" + transaction + "]"));
        }
    }
}

