/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.loader.custom.sql.SQLCustomQuery;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class NativeSQLQueryPlan
implements Serializable {
    private final String sourceQuery;
    private final SQLCustomQuery customQuery;
    private static final Log log = LogFactory.getLog((Class)NativeSQLQueryPlan.class);

    public NativeSQLQueryPlan(NativeSQLQuerySpecification nativeSQLQuerySpecification, SessionFactoryImplementor sessionFactoryImplementor) {
        this.sourceQuery = nativeSQLQuerySpecification.getQueryString();
        this.customQuery = new SQLCustomQuery(nativeSQLQuerySpecification.getQueryString(), nativeSQLQuerySpecification.getQueryReturns(), nativeSQLQuerySpecification.getQuerySpaces(), sessionFactoryImplementor);
    }

    public String getSourceQuery() {
        return this.sourceQuery;
    }

    public SQLCustomQuery getCustomQuery() {
        return this.customQuery;
    }

    private int[] getNamedParameterLocs(String string) throws QueryException {
        Object v = this.customQuery.getNamedParameterBindPoints().get(string);
        if (v == null) {
            throw new QueryException("Named parameter does not appear in Query: " + string, this.customQuery.getSQL());
        }
        if (v instanceof Integer) {
            return new int[]{(Integer)v};
        }
        return ArrayHelper.toIntArray((List)v);
    }

    private int bindPositionalParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray = queryParameters.getFilteredPositionalParameterValues();
        Type[] typeArray = queryParameters.getFilteredPositionalParameterTypes();
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            typeArray[i].nullSafeSet(preparedStatement, objectArray[i], n + n2, sessionImplementor);
            n2 += typeArray[i].getColumnSpan(sessionImplementor.getFactory());
        }
        return n2;
    }

    private int bindNamedParameters(PreparedStatement preparedStatement, Map map, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                TypedValue typedValue = (TypedValue)entry.getValue();
                int[] nArray = this.getNamedParameterLocs(string);
                for (int i = 0; i < nArray.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bindNamedParameters() " + typedValue.getValue() + " -> " + string + " [" + (nArray[i] + n) + "]"));
                    }
                    typedValue.getType().nullSafeSet(preparedStatement, typedValue.getValue(), nArray[i] + n, sessionImplementor);
                }
                n2 += nArray.length;
            }
            return n2;
        }
        return 0;
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor sessionImplementor) {
        BulkOperationCleanupAction bulkOperationCleanupAction = new BulkOperationCleanupAction(sessionImplementor, this.getCustomQuery().getQuerySpaces());
        bulkOperationCleanupAction.init();
        if (sessionImplementor.isEventSource()) {
            ((EventSource)sessionImplementor).getActionQueue().addAction(bulkOperationCleanupAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.coordinateSharedCacheCleanup(sessionImplementor);
        if (queryParameters.isCallable()) {
            throw new IllegalArgumentException("callable not yet supported for native queries");
        }
        int n = 0;
        try {
            queryParameters.processFilters(this.customQuery.getSQL(), sessionImplementor);
            String string = queryParameters.getFilteredSQL();
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareStatement(string);
            try {
                int n2 = 1;
                n2 += this.bindPositionalParameters(preparedStatement, queryParameters, n2, sessionImplementor);
                n2 += this.bindNamedParameters(preparedStatement, queryParameters.getNamedParameters(), n2, sessionImplementor);
                n = preparedStatement.executeUpdate();
                Object var8_8 = null;
                if (preparedStatement == null) return n;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (preparedStatement == null) throw throwable;
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                throw throwable;
            }
            sessionImplementor.getBatcher().closeStatement(preparedStatement);
            return n;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not execute native bulk manipulation query", this.sourceQuery);
        }
    }
}

