/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.loading.CollectionLoadContext;
import org.hibernate.engine.loading.EntityLoadContext;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.IdentityMap;

public class LoadContexts {
    private static final Log log = LogFactory.getLog((Class)LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private Map collectionLoadContexts;
    private Map entityLoadContexts;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext collectionLoadContext = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = IdentityMap.instantiate(8);
        } else {
            collectionLoadContext = (CollectionLoadContext)this.collectionLoadContexts.get(resultSet);
        }
        if (collectionLoadContext == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("constructing collection load context for result set [" + resultSet + "]"));
            }
            collectionLoadContext = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, collectionLoadContext);
        }
        return collectionLoadContext;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister collectionPersister, Serializable serializable) {
        LoadingCollectionEntry loadingCollectionEntry = this.locateLoadingCollectionEntry(new CollectionKey(collectionPersister, serializable, this.getEntityMode()), null);
        if (loadingCollectionEntry != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning loading collection:" + MessageHelper.collectionInfoString(collectionPersister, serializable, this.getSession().getFactory())));
            }
            return loadingCollectionEntry.getCollection();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("creating collection wrapper:" + MessageHelper.collectionInfoString(collectionPersister, serializable, this.getSession().getFactory())));
        }
        return null;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey collectionKey, CollectionLoadContext collectionLoadContext) {
        if (this.collectionLoadContexts == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to locate loading collection entry [" + collectionKey + "] in any result-set context"));
        }
        LoadingCollectionEntry loadingCollectionEntry = null;
        Iterator iterator = this.collectionLoadContexts.values().iterator();
        while (iterator.hasNext()) {
            CollectionLoadContext collectionLoadContext2 = (CollectionLoadContext)iterator.next();
            if (collectionLoadContext2 == collectionLoadContext || (loadingCollectionEntry = collectionLoadContext2.getLocalLoadingCollectionEntry(collectionKey)) == null) continue;
            if (!log.isTraceEnabled()) break;
            log.trace((Object)("collection [" + collectionKey + "] located in load context [" + collectionLoadContext2 + "]"));
            break;
        }
        return loadingCollectionEntry;
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext entityLoadContext = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = IdentityMap.instantiate(8);
        } else {
            entityLoadContext = (EntityLoadContext)this.entityLoadContexts.get(resultSet);
        }
        if (entityLoadContext == null) {
            entityLoadContext = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, entityLoadContext);
        }
        return entityLoadContext;
    }

    public void cleanup(ResultSet resultSet) {
        Object object;
        if (this.collectionLoadContexts != null) {
            object = (CollectionLoadContext)this.collectionLoadContexts.remove(resultSet);
            ((CollectionLoadContext)object).cleanup();
        }
        if (this.entityLoadContexts != null) {
            object = (EntityLoadContext)this.entityLoadContexts.remove(resultSet);
            ((EntityLoadContext)object).cleanup();
        }
    }

    private SessionImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    private EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }
}

