/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.loading.LoadContexts;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public class CollectionLoadContext {
    private static final Log log = LogFactory.getLog((Class)CollectionLoadContext.class);
    private final LoadContexts loadContexts;
    private final ResultSet resultSet;
    private final Map loadingCollections = new HashMap(8);

    public CollectionLoadContext(LoadContexts loadContexts, ResultSet resultSet) {
        this.loadContexts = loadContexts;
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public LoadContexts getLoadContext() {
        return this.loadContexts;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister collectionPersister, Serializable serializable) {
        LoadingCollectionEntry loadingCollectionEntry;
        EntityMode entityMode = this.loadContexts.getPersistenceContext().getSession().getEntityMode();
        CollectionKey collectionKey = new CollectionKey(collectionPersister, serializable, entityMode);
        if (log.isTraceEnabled()) {
            log.trace((Object)("starting attempt to find loading collection [" + MessageHelper.collectionInfoString(collectionPersister.getRole(), serializable) + "]"));
        }
        if ((loadingCollectionEntry = this.locateLoadingCollectionEntry(collectionKey)) == null) {
            PersistentCollection persistentCollection = this.loadContexts.getPersistenceContext().getCollection(collectionKey);
            if (persistentCollection != null) {
                if (persistentCollection.wasInitialized()) {
                    log.trace((Object)"collection already initialized; ignoring");
                    return null;
                }
                log.trace((Object)"collection not yet initialized; initializing");
            } else {
                boolean bl;
                Object object = this.loadContexts.getPersistenceContext().getCollectionOwner(serializable, collectionPersister);
                boolean bl2 = bl = object != null && this.loadContexts.getPersistenceContext().getEntry(object).getStatus() != Status.LOADING && entityMode != EntityMode.DOM4J;
                if (bl) {
                    log.trace((Object)"owning entity already loaded; ignoring");
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("instantiating new collection [key=" + serializable + ", rs=" + this.resultSet + "]"));
                }
                persistentCollection = collectionPersister.getCollectionType().instantiate(this.loadContexts.getPersistenceContext().getSession(), collectionPersister, serializable);
            }
            persistentCollection.beforeInitialize(collectionPersister, -1);
            persistentCollection.beginRead();
            this.loadingCollections.put(collectionKey, new LoadingCollectionEntry(this.resultSet, collectionPersister, serializable, persistentCollection));
            return persistentCollection;
        }
        if (loadingCollectionEntry.getResultSet() == this.resultSet) {
            log.trace((Object)"found loading collection bound to current result set processing; reading row");
            return loadingCollectionEntry.getCollection();
        }
        log.trace((Object)"collection is already being initialized; ignoring row");
        return null;
    }

    private LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey collectionKey) {
        LoadingCollectionEntry loadingCollectionEntry;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to locate loading collection entry [" + collectionKey + "]"));
        }
        if ((loadingCollectionEntry = this.getLocalLoadingCollectionEntry(collectionKey)) == null) {
            loadingCollectionEntry = this.loadContexts.locateLoadingCollectionEntry(collectionKey, this);
        }
        return loadingCollectionEntry;
    }

    LoadingCollectionEntry getLocalLoadingCollectionEntry(CollectionKey collectionKey) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to locally locate loading collection entry [key=" + collectionKey + ", rs=" + this.resultSet + "]"));
        }
        return (LoadingCollectionEntry)this.loadingCollections.get(collectionKey);
    }

    public void endLoadingCollections(CollectionPersister collectionPersister) {
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        ArrayList<LoadingCollectionEntry> arrayList = null;
        Iterator iterator = this.loadingCollections.values().iterator();
        while (iterator.hasNext()) {
            LoadingCollectionEntry loadingCollectionEntry = (LoadingCollectionEntry)iterator.next();
            if (loadingCollectionEntry.getResultSet() != this.resultSet || loadingCollectionEntry.getPersister() != collectionPersister) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<LoadingCollectionEntry>();
            }
            arrayList.add(loadingCollectionEntry);
            if (loadingCollectionEntry.getCollection().getOwner() == null) {
                sessionImplementor.getPersistenceContext().addUnownedCollection(new CollectionKey(collectionPersister, loadingCollectionEntry.getKey(), sessionImplementor.getEntityMode()), loadingCollectionEntry.getCollection());
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("removing collection load entry [" + loadingCollectionEntry + "]"));
            }
            iterator.remove();
        }
        this.endLoadingCollections(collectionPersister, arrayList);
    }

    private void endLoadingCollections(CollectionPersister collectionPersister, List list) {
        int n;
        int n2 = n = list == null ? 0 : list.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)(n + " collections were found in result set for role: " + collectionPersister.getRole()));
        }
        for (int i = 0; i < n; ++i) {
            LoadingCollectionEntry loadingCollectionEntry = (LoadingCollectionEntry)list.get(i);
            this.endLoadingCollection(loadingCollectionEntry, collectionPersister);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(n + " collections initialized for role: " + collectionPersister.getRole()));
        }
    }

    private void endLoadingCollection(LoadingCollectionEntry loadingCollectionEntry, CollectionPersister collectionPersister) {
        boolean bl;
        CollectionEntry collectionEntry;
        if (log.isTraceEnabled()) {
            log.debug((Object)("ending loading collection [" + loadingCollectionEntry + "]"));
        }
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        EntityMode entityMode = sessionImplementor.getEntityMode();
        boolean bl2 = loadingCollectionEntry.getCollection().endRead();
        if (collectionPersister.getCollectionType().hasHolder(entityMode)) {
            this.getLoadContext().getPersistenceContext().addCollectionHolder(loadingCollectionEntry.getCollection());
        }
        if ((collectionEntry = this.getLoadContext().getPersistenceContext().getCollectionEntry(loadingCollectionEntry.getCollection())) == null) {
            collectionEntry = this.getLoadContext().getPersistenceContext().addInitializedCollection(collectionPersister, loadingCollectionEntry.getCollection(), loadingCollectionEntry.getKey());
        } else {
            collectionEntry.postInitialize(loadingCollectionEntry.getCollection());
        }
        boolean bl3 = bl = bl2 && collectionPersister.hasCache() && sessionImplementor.getCacheMode().isPutEnabled() && !collectionEntry.isDoremove();
        if (bl) {
            this.addCollectionToCache(loadingCollectionEntry, collectionPersister);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("collection fully initialized: " + MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getKey(), sessionImplementor.getFactory())));
        }
        if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
            sessionImplementor.getFactory().getStatisticsImplementor().loadCollection(collectionPersister.getRole());
        }
    }

    private void addCollectionToCache(LoadingCollectionEntry loadingCollectionEntry, CollectionPersister collectionPersister) {
        Object object;
        Object object2;
        Comparator comparator;
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching collection: " + MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getKey(), sessionFactoryImplementor)));
        }
        if (!sessionImplementor.getEnabledFilters().isEmpty() && collectionPersister.isAffectedByEnabledFilters(sessionImplementor)) {
            log.debug((Object)"Refusing to add to cache due to enabled filters");
            return;
        }
        if (collectionPersister.isVersioned()) {
            comparator = collectionPersister.getOwnerEntityPersister().getVersionType().getComparator();
            object2 = this.getLoadContext().getPersistenceContext().getCollectionOwner(loadingCollectionEntry.getKey(), collectionPersister);
            object = this.getLoadContext().getPersistenceContext().getEntry(object2).getVersion();
        } else {
            object = null;
            comparator = null;
        }
        object2 = new CollectionCacheEntry(loadingCollectionEntry.getCollection(), collectionPersister);
        CacheKey cacheKey = new CacheKey(loadingCollectionEntry.getKey(), collectionPersister.getKeyType(), collectionPersister.getRole(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
        boolean bl = collectionPersister.getCache().put(cacheKey, collectionPersister.getCacheEntryStructure().structure(object2), sessionImplementor.getTimestamp(), object, comparator, sessionFactoryImplementor.getSettings().isMinimalPutsEnabled() && sessionImplementor.getCacheMode() != CacheMode.REFRESH);
        if (bl && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(collectionPersister.getCache().getRegionName());
        }
    }

    void cleanup() {
        if (!this.loadingCollections.isEmpty()) {
            log.warn((Object)("On CollectionLoadContext#clear, loadingCollections contained [" + this.loadingCollections.size() + "] entries"));
        }
        this.loadingCollections.clear();
    }

    public String toString() {
        return super.toString() + "<rs=" + this.resultSet + ">";
    }
}

