/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.VersionType;

public final class Versioning {
    public static final int OPTIMISTIC_LOCK_NONE = -1;
    public static final int OPTIMISTIC_LOCK_VERSION = 0;
    public static final int OPTIMISTIC_LOCK_ALL = 2;
    public static final int OPTIMISTIC_LOCK_DIRTY = 1;
    private static final Log log = LogFactory.getLog((Class)Versioning.class);

    private Versioning() {
    }

    private static Object seed(VersionType versionType, SessionImplementor sessionImplementor) {
        Object object = versionType.seed(sessionImplementor);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Seeding: " + object));
        }
        return object;
    }

    public static boolean seedVersion(Object[] objectArray, int n, VersionType versionType, SessionImplementor sessionImplementor) {
        Object object = objectArray[n];
        if (object == null || object instanceof Number && ((Number)object).longValue() < 0L) {
            objectArray[n] = Versioning.seed(versionType, sessionImplementor);
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("using initial version: " + object));
        }
        return false;
    }

    public static Object increment(Object object, VersionType versionType, SessionImplementor sessionImplementor) {
        Object object2 = versionType.next(object, sessionImplementor);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Incrementing: " + versionType.toLoggableString(object, sessionImplementor.getFactory()) + " to " + versionType.toLoggableString(object2, sessionImplementor.getFactory())));
        }
        return object2;
    }

    public static void setVersion(Object[] objectArray, Object object, EntityPersister entityPersister) {
        if (!entityPersister.isVersioned()) {
            return;
        }
        objectArray[entityPersister.getVersionProperty()] = object;
    }

    public static Object getVersion(Object[] objectArray, EntityPersister entityPersister) {
        if (!entityPersister.isVersioned()) {
            return null;
        }
        return objectArray[entityPersister.getVersionProperty()];
    }

    public static boolean isVersionIncrementRequired(int[] nArray, boolean bl, boolean[] blArray) {
        if (bl) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!blArray[nArray[i]]) continue;
            return true;
        }
        return false;
    }
}

