/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.AssociationKey;
import org.hibernate.engine.BatchFetchQueue;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.loading.LoadContexts;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.util.IdentityMap;
import org.hibernate.util.MarkerObject;

public class StatefulPersistenceContext
implements PersistenceContext {
    public static final Object NO_ROW = new MarkerObject("NO_ROW");
    private static final Log log = LogFactory.getLog((Class)StatefulPersistenceContext.class);
    private static final Log PROXY_WARN_LOG = LogFactory.getLog((String)(StatefulPersistenceContext.class.getName() + ".ProxyWarnLog"));
    private static final int INIT_COLL_SIZE = 8;
    private SessionImplementor session;
    private Map entitiesByKey;
    private Map entitiesByUniqueKey;
    private Map entityEntries;
    private Map proxiesByKey;
    private Map entitySnapshotsByKey;
    private Map arrayHolders;
    private Map collectionEntries;
    private Map collectionsByKey;
    private HashSet nullifiableEntityKeys;
    private HashSet nullAssociations;
    private List nonlazyCollections;
    private Map unownedCollections;
    private int cascading = 0;
    private int loadCounter = 0;
    private boolean flushing = false;
    private boolean hasNonReadOnlyEntities = false;
    private LoadContexts loadContexts;
    private BatchFetchQueue batchFetchQueue;

    public StatefulPersistenceContext(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.entitiesByKey = new HashMap(8);
        this.entitiesByUniqueKey = new HashMap(8);
        this.proxiesByKey = new ReferenceMap(0, 2);
        this.entitySnapshotsByKey = new HashMap(8);
        this.entityEntries = IdentityMap.instantiateSequenced(8);
        this.collectionEntries = IdentityMap.instantiateSequenced(8);
        this.collectionsByKey = new HashMap(8);
        this.arrayHolders = IdentityMap.instantiate(8);
        this.nullifiableEntityKeys = new HashSet();
        this.initTransientState();
    }

    private void initTransientState() {
        this.nullAssociations = new HashSet(8);
        this.nonlazyCollections = new ArrayList(8);
    }

    public boolean isStateless() {
        return false;
    }

    public SessionImplementor getSession() {
        return this.session;
    }

    public LoadContexts getLoadContexts() {
        if (this.loadContexts == null) {
            this.loadContexts = new LoadContexts(this);
        }
        return this.loadContexts;
    }

    public void addUnownedCollection(CollectionKey collectionKey, PersistentCollection persistentCollection) {
        if (this.unownedCollections == null) {
            this.unownedCollections = new HashMap(8);
        }
        this.unownedCollections.put(collectionKey, persistentCollection);
    }

    public PersistentCollection useUnownedCollection(CollectionKey collectionKey) {
        if (this.unownedCollections == null) {
            return null;
        }
        return (PersistentCollection)this.unownedCollections.remove(collectionKey);
    }

    public BatchFetchQueue getBatchFetchQueue() {
        if (this.batchFetchQueue == null) {
            this.batchFetchQueue = new BatchFetchQueue(this);
        }
        return this.batchFetchQueue;
    }

    public void clear() {
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entitiesByUniqueKey.clear();
        this.entityEntries.clear();
        this.entitySnapshotsByKey.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        if (this.unownedCollections != null) {
            this.unownedCollections.clear();
        }
        this.proxiesByKey.clear();
        this.nullifiableEntityKeys.clear();
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.clear();
        }
        this.hasNonReadOnlyEntities = false;
    }

    public boolean hasNonReadOnlyEntities() {
        return this.hasNonReadOnlyEntities;
    }

    public void setEntryStatus(EntityEntry entityEntry, Status status) {
        entityEntry.setStatus(status);
        this.setHasNonReadOnlyEnties(status);
    }

    private void setHasNonReadOnlyEnties(Status status) {
        if (status == Status.DELETED || status == Status.MANAGED || status == Status.SAVING) {
            this.hasNonReadOnlyEntities = true;
        }
    }

    public void afterTransactionCompletion() {
        Iterator iterator = this.entityEntries.values().iterator();
        while (iterator.hasNext()) {
            ((EntityEntry)iterator.next()).setLockMode(LockMode.NONE);
        }
    }

    public Object[] getDatabaseSnapshot(Serializable serializable, EntityPersister entityPersister) throws HibernateException {
        EntityKey entityKey = new EntityKey(serializable, entityPersister, this.session.getEntityMode());
        Object v = this.entitySnapshotsByKey.get(entityKey);
        if (v != null) {
            return v == NO_ROW ? null : (Object[])v;
        }
        Object[] objectArray = entityPersister.getDatabaseSnapshot(serializable, this.session);
        this.entitySnapshotsByKey.put(entityKey, objectArray == null ? NO_ROW : objectArray);
        return objectArray;
    }

    public Object[] getNaturalIdSnapshot(Serializable serializable, EntityPersister entityPersister) throws HibernateException {
        if (!entityPersister.hasNaturalIdentifier()) {
            return null;
        }
        int[] nArray = entityPersister.getNaturalIdentifierProperties();
        boolean[] blArray = entityPersister.getPropertyUpdateability();
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[nArray[i]]) continue;
            bl = false;
            break;
        }
        if (bl) {
            Object[] objectArray = this.getDatabaseSnapshot(serializable, entityPersister);
            if (objectArray == NO_ROW) {
                return null;
            }
            Object[] objectArray2 = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray2[i] = objectArray[nArray[i]];
            }
            return objectArray2;
        }
        return entityPersister.getNaturalIdentifierSnapshot(serializable, this.session);
    }

    public Object[] getCachedDatabaseSnapshot(EntityKey entityKey) {
        Object v = this.entitySnapshotsByKey.get(entityKey);
        if (v == NO_ROW) {
            throw new IllegalStateException("persistence context reported no row snapshot for " + MessageHelper.infoString(entityKey.getEntityName(), entityKey.getIdentifier()));
        }
        return (Object[])v;
    }

    public void addEntity(EntityKey entityKey, Object object) {
        this.entitiesByKey.put(entityKey, object);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(entityKey);
    }

    public Object getEntity(EntityKey entityKey) {
        return this.entitiesByKey.get(entityKey);
    }

    public boolean containsEntity(EntityKey entityKey) {
        return this.entitiesByKey.containsKey(entityKey);
    }

    public Object removeEntity(EntityKey entityKey) {
        Object v = this.entitiesByKey.remove(entityKey);
        Iterator iterator = this.entitiesByUniqueKey.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != v) continue;
            iterator.remove();
        }
        this.entitySnapshotsByKey.remove(entityKey);
        this.nullifiableEntityKeys.remove(entityKey);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(entityKey);
        this.getBatchFetchQueue().removeSubselect(entityKey);
        return v;
    }

    public Object getEntity(EntityUniqueKey entityUniqueKey) {
        return this.entitiesByUniqueKey.get(entityUniqueKey);
    }

    public void addEntity(EntityUniqueKey entityUniqueKey, Object object) {
        this.entitiesByUniqueKey.put(entityUniqueKey, object);
    }

    public EntityEntry getEntry(Object object) {
        return (EntityEntry)this.entityEntries.get(object);
    }

    public EntityEntry removeEntry(Object object) {
        return (EntityEntry)this.entityEntries.remove(object);
    }

    public boolean isEntryFor(Object object) {
        return this.entityEntries.containsKey(object);
    }

    public CollectionEntry getCollectionEntry(PersistentCollection persistentCollection) {
        return (CollectionEntry)this.collectionEntries.get(persistentCollection);
    }

    public EntityEntry addEntity(Object object, Status status, Object[] objectArray, EntityKey entityKey, Object object2, LockMode lockMode, boolean bl, EntityPersister entityPersister, boolean bl2, boolean bl3) {
        this.addEntity(entityKey, object);
        return this.addEntry(object, status, objectArray, null, entityKey.getIdentifier(), object2, lockMode, bl, entityPersister, bl2, bl3);
    }

    public EntityEntry addEntry(Object object, Status status, Object[] objectArray, Object object2, Serializable serializable, Object object3, LockMode lockMode, boolean bl, EntityPersister entityPersister, boolean bl2, boolean bl3) {
        EntityEntry entityEntry = new EntityEntry(status, objectArray, object2, serializable, object3, lockMode, bl, entityPersister, this.session.getEntityMode(), bl2, bl3);
        this.entityEntries.put(object, entityEntry);
        this.setHasNonReadOnlyEnties(status);
        return entityEntry;
    }

    public boolean containsCollection(PersistentCollection persistentCollection) {
        return this.collectionEntries.containsKey(persistentCollection);
    }

    public boolean containsProxy(Object object) {
        return this.proxiesByKey.containsValue(object);
    }

    public boolean reassociateIfUninitializedProxy(Object object) throws MappingException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (!Hibernate.isInitialized(object)) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            this.reassociateProxy(lazyInitializer, hibernateProxy);
            return true;
        }
        return false;
    }

    public void reassociateProxy(Object object, Serializable serializable) throws MappingException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (object instanceof HibernateProxy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting proxy identifier: " + serializable));
            }
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            lazyInitializer.setIdentifier(serializable);
            this.reassociateProxy(lazyInitializer, hibernateProxy);
        }
    }

    private void reassociateProxy(LazyInitializer lazyInitializer, HibernateProxy hibernateProxy) {
        if (lazyInitializer.getSession() != this.getSession()) {
            EntityPersister entityPersister = this.session.getFactory().getEntityPersister(lazyInitializer.getEntityName());
            EntityKey entityKey = new EntityKey(lazyInitializer.getIdentifier(), entityPersister, this.session.getEntityMode());
            if (!this.proxiesByKey.containsKey(entityKey)) {
                this.proxiesByKey.put(entityKey, hibernateProxy);
            }
            hibernateProxy.getHibernateLazyInitializer().setSession(this.session);
        }
    }

    public Object unproxy(Object object) throws HibernateException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            if (lazyInitializer.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for " + lazyInitializer.getEntityName());
            }
            return lazyInitializer.getImplementation();
        }
        return object;
    }

    public Object unproxyAndReassociate(Object object) throws HibernateException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            this.reassociateProxy(lazyInitializer, hibernateProxy);
            return lazyInitializer.getImplementation();
        }
        return object;
    }

    public void checkUniqueness(EntityKey entityKey, Object object) throws HibernateException {
        Object object2 = this.getEntity(entityKey);
        if (object2 == object) {
            throw new AssertionFailure("object already associated, but no entry was found");
        }
        if (object2 != null) {
            throw new NonUniqueObjectException(entityKey.getIdentifier(), entityKey.getEntityName());
        }
    }

    public Object narrowProxy(Object object, EntityPersister entityPersister, EntityKey entityKey, Object object2) throws HibernateException {
        boolean bl = entityPersister.getConcreteProxyClass(this.session.getEntityMode()).isAssignableFrom(object.getClass());
        if (!bl) {
            if (PROXY_WARN_LOG.isWarnEnabled()) {
                PROXY_WARN_LOG.warn((Object)("Narrowing proxy to " + entityPersister.getConcreteProxyClass(this.session.getEntityMode()) + " - this operation breaks =="));
            }
            if (object2 != null) {
                this.proxiesByKey.remove(entityKey);
                return object2;
            }
            object = entityPersister.createProxy(entityKey.getIdentifier(), this.session);
            this.proxiesByKey.put(entityKey, object);
            return object;
        }
        if (object2 != null) {
            LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            lazyInitializer.setImplementation(object2);
        }
        return object;
    }

    public Object proxyFor(EntityPersister entityPersister, EntityKey entityKey, Object object) throws HibernateException {
        if (!entityPersister.hasProxy()) {
            return object;
        }
        Object v = this.proxiesByKey.get(entityKey);
        if (v != null) {
            return this.narrowProxy(v, entityPersister, entityKey, object);
        }
        return object;
    }

    public Object proxyFor(Object object) throws HibernateException {
        EntityEntry entityEntry = this.getEntry(object);
        EntityPersister entityPersister = entityEntry.getPersister();
        return this.proxyFor(entityPersister, new EntityKey(entityEntry.getId(), entityPersister, this.session.getEntityMode()), object);
    }

    public Object getCollectionOwner(Serializable serializable, CollectionPersister collectionPersister) throws MappingException {
        return this.getEntity(new EntityKey(serializable, collectionPersister.getOwnerEntityPersister(), this.session.getEntityMode()));
    }

    public void addUninitializedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable) {
        CollectionEntry collectionEntry = new CollectionEntry(persistentCollection, collectionPersister, serializable, this.flushing);
        this.addCollection(persistentCollection, collectionEntry, serializable);
    }

    public void addUninitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection) {
        CollectionEntry collectionEntry = new CollectionEntry(collectionPersister, persistentCollection.getKey());
        this.addCollection(persistentCollection, collectionEntry, persistentCollection.getKey());
    }

    public void addNewCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection) throws HibernateException {
        this.addCollection(persistentCollection, collectionPersister);
    }

    private void addCollection(PersistentCollection persistentCollection, CollectionEntry collectionEntry, Serializable serializable) {
        this.collectionEntries.put(persistentCollection, collectionEntry);
        CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedPersister(), serializable, this.session.getEntityMode());
        PersistentCollection persistentCollection2 = this.collectionsByKey.put(collectionKey, persistentCollection);
        if (persistentCollection2 != null) {
            if (persistentCollection2 == persistentCollection) {
                throw new AssertionFailure("bug adding collection twice");
            }
            persistentCollection2.unsetSession(this.session);
            this.collectionEntries.remove(persistentCollection2);
        }
    }

    private void addCollection(PersistentCollection persistentCollection, CollectionPersister collectionPersister) {
        CollectionEntry collectionEntry = new CollectionEntry(collectionPersister, persistentCollection);
        this.collectionEntries.put(persistentCollection, collectionEntry);
    }

    public void addInitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection) throws HibernateException {
        if (persistentCollection.isUnreferenced()) {
            this.addCollection(persistentCollection, collectionPersister);
        } else {
            CollectionEntry collectionEntry = new CollectionEntry(persistentCollection, this.session.getFactory());
            this.addCollection(persistentCollection, collectionEntry, persistentCollection.getKey());
        }
    }

    public CollectionEntry addInitializedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable) throws HibernateException {
        CollectionEntry collectionEntry = new CollectionEntry(persistentCollection, collectionPersister, serializable, this.flushing);
        collectionEntry.postInitialize(persistentCollection);
        this.addCollection(persistentCollection, collectionEntry, serializable);
        return collectionEntry;
    }

    public PersistentCollection getCollection(CollectionKey collectionKey) {
        return (PersistentCollection)this.collectionsByKey.get(collectionKey);
    }

    public void addNonLazyCollection(PersistentCollection persistentCollection) {
        this.nonlazyCollections.add(persistentCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            log.debug((Object)"initializing non-lazy collections");
            ++this.loadCounter;
            try {
                int n;
                while ((n = this.nonlazyCollections.size()) > 0) {
                    ((PersistentCollection)this.nonlazyCollections.remove(n - 1)).forceInitialization();
                }
            }
            finally {
                --this.loadCounter;
                this.clearNullProperties();
            }
        }
    }

    public PersistentCollection getCollectionHolder(Object object) {
        return (PersistentCollection)this.arrayHolders.get(object);
    }

    public void addCollectionHolder(PersistentCollection persistentCollection) {
        this.arrayHolders.put(persistentCollection.getValue(), persistentCollection);
    }

    public PersistentCollection removeCollectionHolder(Object object) {
        return (PersistentCollection)this.arrayHolders.remove(object);
    }

    public Serializable getSnapshot(PersistentCollection persistentCollection) {
        return this.getCollectionEntry(persistentCollection).getSnapshot();
    }

    public CollectionEntry getCollectionEntryOrNull(Object object) {
        PersistentCollection persistentCollection;
        if (object instanceof PersistentCollection) {
            persistentCollection = (PersistentCollection)object;
        } else {
            persistentCollection = this.getCollectionHolder(object);
            if (persistentCollection == null) {
                Iterator iterator = IdentityMap.keyIterator(this.collectionEntries);
                while (iterator.hasNext()) {
                    PersistentCollection persistentCollection2 = (PersistentCollection)iterator.next();
                    if (!persistentCollection2.isWrapper(object)) continue;
                    persistentCollection = persistentCollection2;
                    break;
                }
            }
        }
        return persistentCollection == null ? null : this.getCollectionEntry(persistentCollection);
    }

    public Object getProxy(EntityKey entityKey) {
        return this.proxiesByKey.get(entityKey);
    }

    public void addProxy(EntityKey entityKey, Object object) {
        this.proxiesByKey.put(entityKey, object);
    }

    public Object removeProxy(EntityKey entityKey) {
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.removeBatchLoadableEntityKey(entityKey);
            this.batchFetchQueue.removeSubselect(entityKey);
        }
        return this.proxiesByKey.remove(entityKey);
    }

    public HashSet getNullifiableEntityKeys() {
        return this.nullifiableEntityKeys;
    }

    public Map getEntitiesByKey() {
        return this.entitiesByKey;
    }

    public Map getEntityEntries() {
        return this.entityEntries;
    }

    public Map getCollectionEntries() {
        return this.collectionEntries;
    }

    public Map getCollectionsByKey() {
        return this.collectionsByKey;
    }

    public int getCascadeLevel() {
        return this.cascading;
    }

    public int incrementCascadeLevel() {
        return ++this.cascading;
    }

    public int decrementCascadeLevel() {
        return --this.cascading;
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public void setFlushing(boolean bl) {
        this.flushing = bl;
    }

    public void beforeLoad() {
        ++this.loadCounter;
    }

    public void afterLoad() {
        --this.loadCounter;
    }

    public String toString() {
        return "PersistenceContext[entityKeys=" + this.entitiesByKey.keySet() + ",collectionKeys=" + this.collectionsByKey.keySet() + "]";
    }

    public Serializable getOwnerId(String string, String string2, Object object, Map map) {
        EntityPersister entityPersister = this.session.getFactory().getEntityPersister(string);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(string + '.' + string2);
        Iterator iterator = this.entityEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            EntityEntry entityEntry = (EntityEntry)entry.getValue();
            if (!entityPersister.isSubclassEntityName(entityEntry.getEntityName())) continue;
            Object k = entry.getKey();
            boolean bl = this.isFoundInParent(string2, object, entityPersister, collectionPersister, k);
            if (!bl && map != null) {
                Object v = map.get(k);
                Object v2 = map.get(object);
                if (v != null && v2 != null) {
                    bl = this.isFoundInParent(string2, v2, entityPersister, collectionPersister, v);
                }
            }
            if (!bl) continue;
            return entityEntry.getId();
        }
        return null;
    }

    private boolean isFoundInParent(String string, Object object, EntityPersister entityPersister, CollectionPersister collectionPersister, Object object2) {
        Object object3 = entityPersister.getPropertyValue(object2, string, this.session.getEntityMode());
        return object3 != null && Hibernate.isInitialized(object3) && collectionPersister.getCollectionType().contains(object3, object, this.session);
    }

    public Object getIndexInOwner(String string, String string2, Object object, Map map) {
        EntityPersister entityPersister = this.session.getFactory().getEntityPersister(string);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(string + '.' + string2);
        Iterator iterator = this.entityEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            EntityEntry entityEntry = (EntityEntry)entry.getValue();
            if (!entityPersister.isSubclassEntityName(entityEntry.getEntityName())) continue;
            Object k = entry.getKey();
            Object object2 = this.getIndexInParent(string2, object, entityPersister, collectionPersister, k);
            if (object2 == null && map != null) {
                Object v = map.get(k);
                Object v2 = map.get(object);
                if (v != null && v2 != null) {
                    object2 = this.getIndexInParent(string2, v2, entityPersister, collectionPersister, v);
                }
            }
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    private Object getIndexInParent(String string, Object object, EntityPersister entityPersister, CollectionPersister collectionPersister, Object object2) {
        Object object3 = entityPersister.getPropertyValue(object2, string, this.session.getEntityMode());
        if (object3 != null && Hibernate.isInitialized(object3)) {
            return collectionPersister.getCollectionType().indexOf(object3, object);
        }
        return null;
    }

    public void addNullProperty(EntityKey entityKey, String string) {
        this.nullAssociations.add(new AssociationKey(entityKey, string));
    }

    public boolean isPropertyNull(EntityKey entityKey, String string) {
        return this.nullAssociations.contains(new AssociationKey(entityKey, string));
    }

    private void clearNullProperties() {
        this.nullAssociations.clear();
    }

    public void setReadOnly(Object object, boolean bl) {
        EntityEntry entityEntry = this.getEntry(object);
        if (entityEntry == null) {
            throw new TransientObjectException("Instance was not associated with the session");
        }
        entityEntry.setReadOnly(bl, object);
        this.hasNonReadOnlyEntities = this.hasNonReadOnlyEntities || !bl;
    }

    public void replaceDelayedEntityIdentityInsertKeys(EntityKey entityKey, Serializable serializable) {
        Object v = this.entitiesByKey.remove(entityKey);
        EntityEntry entityEntry = (EntityEntry)this.entityEntries.remove(v);
        EntityKey entityKey2 = new EntityKey(serializable, entityEntry.getPersister(), this.getSession().getEntityMode());
        this.addEntity(entityKey2, v);
        this.addEntry(v, entityEntry.getStatus(), entityEntry.getLoadedState(), entityEntry.getRowId(), serializable, entityEntry.getVersion(), entityEntry.getLockMode(), entityEntry.isExistsInDatabase(), entityEntry.getPersister(), entityEntry.isBeingReplicated(), entityEntry.isLoadedWithLazyPropertiesUnfetched());
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        log.trace((Object)"serializing persistent-context");
        objectOutputStream.writeBoolean(this.hasNonReadOnlyEntities);
        objectOutputStream.writeInt(this.entitiesByKey.size());
        log.trace((Object)("starting serialization of [" + this.entitiesByKey.size() + "] entitiesByKey entries"));
        Iterator iterator = this.entitiesByKey.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((EntityKey)object.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.entitiesByUniqueKey.size());
        log.trace((Object)("starting serialization of [" + this.entitiesByUniqueKey.size() + "] entitiesByUniqueKey entries"));
        iterator = this.entitiesByUniqueKey.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((EntityUniqueKey)object.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.proxiesByKey.size());
        log.trace((Object)("starting serialization of [" + this.proxiesByKey.size() + "] proxiesByKey entries"));
        iterator = this.proxiesByKey.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((EntityKey)object.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.entitySnapshotsByKey.size());
        log.trace((Object)("starting serialization of [" + this.entitySnapshotsByKey.size() + "] entitySnapshotsByKey entries"));
        iterator = this.entitySnapshotsByKey.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((EntityKey)object.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.entityEntries.size());
        log.trace((Object)("starting serialization of [" + this.entityEntries.size() + "] entityEntries entries"));
        iterator = this.entityEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            objectOutputStream.writeObject(object.getKey());
            ((EntityEntry)object.getValue()).serialize(objectOutputStream);
        }
        objectOutputStream.writeInt(this.collectionsByKey.size());
        log.trace((Object)("starting serialization of [" + this.collectionsByKey.size() + "] collectionsByKey entries"));
        iterator = this.collectionsByKey.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((CollectionKey)object.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.collectionEntries.size());
        log.trace((Object)("starting serialization of [" + this.collectionEntries.size() + "] collectionEntries entries"));
        iterator = this.collectionEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            objectOutputStream.writeObject(object.getKey());
            ((CollectionEntry)object.getValue()).serialize(objectOutputStream);
        }
        objectOutputStream.writeInt(this.arrayHolders.size());
        log.trace((Object)("starting serialization of [" + this.arrayHolders.size() + "] arrayHolders entries"));
        iterator = this.arrayHolders.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            objectOutputStream.writeObject(object.getKey());
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.nullifiableEntityKeys.size());
        log.trace((Object)("starting serialization of [" + this.nullifiableEntityKeys.size() + "] nullifiableEntityKeys entries"));
        iterator = this.nullifiableEntityKeys.iterator();
        while (iterator.hasNext()) {
            object = (EntityKey)((Object)iterator.next());
            ((EntityKey)object).serialize(objectOutputStream);
        }
    }

    public static StatefulPersistenceContext deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing persistent-context");
        StatefulPersistenceContext statefulPersistenceContext = new StatefulPersistenceContext(sessionImplementor);
        try {
            Object object;
            Object object2;
            int n;
            statefulPersistenceContext.hasNonReadOnlyEntities = objectInputStream.readBoolean();
            int n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] entitiesByKey entries"));
            statefulPersistenceContext.entitiesByKey = new HashMap(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.entitiesByKey.put(EntityKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] entitiesByUniqueKey entries"));
            statefulPersistenceContext.entitiesByUniqueKey = new HashMap(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.entitiesByUniqueKey.put(EntityUniqueKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] proxiesByKey entries"));
            statefulPersistenceContext.proxiesByKey = new ReferenceMap(0, 2, n2 < 8 ? 8 : n2, 0.75f);
            for (n = 0; n < n2; ++n) {
                object2 = EntityKey.deserialize(objectInputStream, sessionImplementor);
                object = objectInputStream.readObject();
                if (object instanceof HibernateProxy) {
                    ((HibernateProxy)object).getHibernateLazyInitializer().setSession(sessionImplementor);
                    statefulPersistenceContext.proxiesByKey.put(object2, object);
                    continue;
                }
                log.trace((Object)"encountered prunded proxy");
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] entitySnapshotsByKey entries"));
            statefulPersistenceContext.entitySnapshotsByKey = new HashMap(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.entitySnapshotsByKey.put(EntityKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] entityEntries entries"));
            statefulPersistenceContext.entityEntries = IdentityMap.instantiateSequenced(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                object2 = objectInputStream.readObject();
                object = EntityEntry.deserialize(objectInputStream, sessionImplementor);
                statefulPersistenceContext.entityEntries.put(object2, object);
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] collectionsByKey entries"));
            statefulPersistenceContext.collectionsByKey = new HashMap(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.collectionsByKey.put(CollectionKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] collectionEntries entries"));
            statefulPersistenceContext.collectionEntries = IdentityMap.instantiateSequenced(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                object2 = (PersistentCollection)objectInputStream.readObject();
                object = CollectionEntry.deserialize(objectInputStream, sessionImplementor);
                object2.setCurrentSession(sessionImplementor);
                statefulPersistenceContext.collectionEntries.put(object2, object);
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] arrayHolders entries"));
            statefulPersistenceContext.arrayHolders = IdentityMap.instantiate(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.arrayHolders.put(objectInputStream.readObject(), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            log.trace((Object)("staring deserialization of [" + n2 + "] nullifiableEntityKeys entries"));
            statefulPersistenceContext.nullifiableEntityKeys = new HashSet();
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.nullifiableEntityKeys.add(EntityKey.deserialize(objectInputStream, sessionImplementor));
            }
        }
        catch (HibernateException hibernateException) {
            throw new InvalidObjectException(hibernateException.getMessage());
        }
        return statefulPersistenceContext;
    }
}

