/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.pretty.Printer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public final class QueryParameters {
    private static final Log log = LogFactory.getLog((Class)QueryParameters.class);
    private Type[] positionalParameterTypes;
    private Object[] positionalParameterValues;
    private Map namedParameters;
    private Map lockModes;
    private RowSelection rowSelection;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private ScrollMode scrollMode;
    private Serializable[] collectionKeys;
    private Object optionalObject;
    private String optionalEntityName;
    private Serializable optionalId;
    private boolean readOnly;
    private boolean callable = false;
    private boolean autodiscovertypes = false;
    private boolean isNaturalKeyLookup;
    private final ResultTransformer resultTransformer;
    private String processedSQL;
    private Type[] processedPositionalParameterTypes;
    private Object[] processedPositionalParameterValues;
    static /* synthetic */ Class class$java$util$Collection;

    public QueryParameters() {
        this(ArrayHelper.EMPTY_TYPE_ARRAY, ArrayHelper.EMPTY_OBJECT_ARRAY);
    }

    public QueryParameters(Type type, Object object) {
        this(new Type[]{type}, new Object[]{object});
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Object object, String string, Serializable serializable) {
        this(typeArray, objectArray);
        this.optionalObject = object;
        this.optionalId = serializable;
        this.optionalEntityName = string;
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray) {
        this(typeArray, objectArray, null, null, false, null, null, false, null);
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Serializable[] serializableArray) {
        this(typeArray, objectArray, null, serializableArray);
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map map, Serializable[] serializableArray) {
        this(typeArray, objectArray, map, null, null, false, false, null, null, serializableArray, null);
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map map, RowSelection rowSelection, boolean bl, String string, String string2, boolean bl2, ResultTransformer resultTransformer) {
        this(typeArray, objectArray, null, map, rowSelection, false, bl, string, string2, null, resultTransformer);
        this.isNaturalKeyLookup = bl2;
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map map, Map map2, RowSelection rowSelection, boolean bl, boolean bl2, String string, String string2, Serializable[] serializableArray, ResultTransformer resultTransformer) {
        this.positionalParameterTypes = typeArray;
        this.positionalParameterValues = objectArray;
        this.namedParameters = map;
        this.lockModes = map2;
        this.rowSelection = rowSelection;
        this.cacheable = bl2;
        this.cacheRegion = string;
        this.comment = string2;
        this.collectionKeys = serializableArray;
        this.readOnly = bl;
        this.resultTransformer = resultTransformer;
    }

    public QueryParameters(Type[] typeArray, Object[] objectArray, Map map, Map map2, RowSelection rowSelection, boolean bl, boolean bl2, String string, String string2, Serializable[] serializableArray, Object object, String string3, Serializable serializable, ResultTransformer resultTransformer) {
        this(typeArray, objectArray, map, map2, rowSelection, bl, bl2, string, string2, serializableArray, resultTransformer);
        this.optionalEntityName = string3;
        this.optionalId = serializable;
        this.optionalObject = object;
    }

    public boolean hasRowSelection() {
        return this.rowSelection != null;
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public Type[] getPositionalParameterTypes() {
        return this.positionalParameterTypes;
    }

    public Object[] getPositionalParameterValues() {
        return this.positionalParameterValues;
    }

    public RowSelection getRowSelection() {
        return this.rowSelection;
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public void setNamedParameters(Map map) {
        this.namedParameters = map;
    }

    public void setPositionalParameterTypes(Type[] typeArray) {
        this.positionalParameterTypes = typeArray;
    }

    public void setPositionalParameterValues(Object[] objectArray) {
        this.positionalParameterValues = objectArray;
    }

    public void setRowSelection(RowSelection rowSelection) {
        this.rowSelection = rowSelection;
    }

    public Map getLockModes() {
        return this.lockModes;
    }

    public void setLockModes(Map map) {
        this.lockModes = map;
    }

    public void traceParameters(SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        Printer printer = new Printer(sessionFactoryImplementor);
        if (this.positionalParameterValues.length != 0) {
            log.trace((Object)("parameters: " + printer.toString(this.positionalParameterTypes, this.positionalParameterValues)));
        }
        if (this.namedParameters != null) {
            log.trace((Object)("named parameters: " + printer.toString(this.namedParameters)));
        }
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean bl) {
        this.cacheable = bl;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheRegion(String string) {
        this.cacheRegion = string;
    }

    public void validateParameters() throws QueryException {
        int n;
        int n2 = this.positionalParameterTypes == null ? 0 : this.positionalParameterTypes.length;
        int n3 = n = this.positionalParameterValues == null ? 0 : this.positionalParameterValues.length;
        if (n2 != n) {
            throw new QueryException("Number of positional parameter types:" + n2 + " does not match number of positional parameters: " + n);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public ScrollMode getScrollMode() {
        return this.scrollMode;
    }

    public void setScrollMode(ScrollMode scrollMode) {
        this.scrollMode = scrollMode;
    }

    public Serializable[] getCollectionKeys() {
        return this.collectionKeys;
    }

    public void setCollectionKeys(Serializable[] serializableArray) {
        this.collectionKeys = serializableArray;
    }

    public String getOptionalEntityName() {
        return this.optionalEntityName;
    }

    public void setOptionalEntityName(String string) {
        this.optionalEntityName = string;
    }

    public Serializable getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Serializable serializable) {
        this.optionalId = serializable;
    }

    public Object getOptionalObject() {
        return this.optionalObject;
    }

    public void setOptionalObject(Object object) {
        this.optionalObject = object;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setCallable(boolean bl) {
        this.callable = bl;
    }

    public boolean isCallable() {
        return this.callable;
    }

    public boolean hasAutoDiscoverScalarTypes() {
        return this.autodiscovertypes;
    }

    public void processFilters(String string, SessionImplementor sessionImplementor) {
        if (sessionImplementor.getEnabledFilters().size() == 0 || string.indexOf(":") < 0) {
            this.processedPositionalParameterValues = this.getPositionalParameterValues();
            this.processedPositionalParameterTypes = this.getPositionalParameterTypes();
            this.processedSQL = string;
        } else {
            Dialect dialect = sessionImplementor.getFactory().getDialect();
            String string2 = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\" + dialect.openQuote() + dialect.closeQuote();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Type> arrayList2 = new ArrayList<Type>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith(":")) {
                    String string4 = string3.substring(1);
                    Object object = sessionImplementor.getFilterParameterValue(string4);
                    Type type = sessionImplementor.getFilterParameterType(string4);
                    if (object != null && (class$java$util$Collection == null ? QueryParameters.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(object.getClass())) {
                        Iterator iterator = ((Collection)object).iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            stringBuffer.append('?');
                            arrayList.add(e);
                            arrayList2.add(type);
                            if (!iterator.hasNext()) continue;
                            stringBuffer.append(", ");
                        }
                        continue;
                    }
                    stringBuffer.append('?');
                    arrayList.add(object);
                    arrayList2.add(type);
                    continue;
                }
                stringBuffer.append(string3);
            }
            arrayList.addAll(Arrays.asList(this.getPositionalParameterValues()));
            arrayList2.addAll(Arrays.asList(this.getPositionalParameterTypes()));
            this.processedPositionalParameterValues = arrayList.toArray();
            this.processedPositionalParameterTypes = arrayList2.toArray(new Type[0]);
            this.processedSQL = stringBuffer.toString();
        }
    }

    public String getFilteredSQL() {
        return this.processedSQL;
    }

    public Object[] getFilteredPositionalParameterValues() {
        return this.processedPositionalParameterValues;
    }

    public Type[] getFilteredPositionalParameterTypes() {
        return this.processedPositionalParameterTypes;
    }

    public boolean isNaturalKeyLookup() {
        return this.isNaturalKeyLookup;
    }

    public void setNaturalKeyLookup(boolean bl) {
        this.isNaturalKeyLookup = bl;
    }

    public void setAutoDiscoverScalarTypes(boolean bl) {
        this.autodiscovertypes = bl;
    }

    public QueryParameters createCopyUsing(RowSelection rowSelection) {
        QueryParameters queryParameters = new QueryParameters(this.positionalParameterTypes, this.positionalParameterValues, this.namedParameters, this.lockModes, rowSelection, this.readOnly, this.cacheable, this.cacheRegion, this.comment, this.collectionKeys, this.optionalObject, this.optionalEntityName, this.optionalId, this.resultTransformer);
        queryParameters.processedSQL = this.processedSQL;
        queryParameters.processedPositionalParameterTypes = this.processedPositionalParameterTypes;
        queryParameters.processedPositionalParameterValues = this.processedPositionalParameterValues;
        return queryParameters;
    }
}

