/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public class EntityUniqueKey
implements Serializable {
    private final String uniqueKeyName;
    private final String entityName;
    private final Object key;
    private final Type keyType;
    private final EntityMode entityMode;
    private final int hashCode;

    public EntityUniqueKey(String string, String string2, Object object, Type type, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        this.uniqueKeyName = string2;
        this.entityName = string;
        this.key = object;
        this.keyType = type.getSemiResolvedType(sessionFactoryImplementor);
        this.entityMode = entityMode;
        this.hashCode = this.generateHashCode(sessionFactoryImplementor);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Object getKey() {
        return this.key;
    }

    public String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    public int generateHashCode(SessionFactoryImplementor sessionFactoryImplementor) {
        int n = 17;
        n = 37 * n + this.entityName.hashCode();
        n = 37 * n + this.uniqueKeyName.hashCode();
        n = 37 * n + this.keyType.getHashCode(this.key, this.entityMode, sessionFactoryImplementor);
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        EntityUniqueKey entityUniqueKey = (EntityUniqueKey)object;
        return entityUniqueKey.entityName.equals(this.entityName) && entityUniqueKey.uniqueKeyName.equals(this.uniqueKeyName) && this.keyType.isEqual(entityUniqueKey.key, this.key, this.entityMode);
    }

    public String toString() {
        return "EntityUniqueKey" + MessageHelper.infoString(this.entityName, this.uniqueKeyName, this.key);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.checkAbilityToSerialize();
        objectOutputStream.defaultWriteObject();
    }

    private void checkAbilityToSerialize() {
        if (this.key != null && !Serializable.class.isAssignableFrom(this.key.getClass())) {
            throw new IllegalStateException("Cannot serialize an EntityUniqueKey which represents a non serializable property value [" + this.entityName + "." + this.uniqueKeyName + "]");
        }
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        this.checkAbilityToSerialize();
        objectOutputStream.writeObject(this.uniqueKeyName);
        objectOutputStream.writeObject(this.entityName);
        objectOutputStream.writeObject(this.key);
        objectOutputStream.writeObject(this.keyType);
        objectOutputStream.writeObject(this.entityMode);
    }

    static EntityUniqueKey deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        return new EntityUniqueKey((String)objectInputStream.readObject(), (String)objectInputStream.readObject(), objectInputStream.readObject(), (Type)objectInputStream.readObject(), (EntityMode)objectInputStream.readObject(), sessionImplementor.getFactory());
    }
}

