/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class EntityKey
implements Serializable {
    private final Serializable identifier;
    private final String rootEntityName;
    private final String entityName;
    private final Type identifierType;
    private final boolean isBatchLoadable;
    private final SessionFactoryImplementor factory;
    private final int hashCode;
    private final EntityMode entityMode;

    public EntityKey(Serializable serializable, EntityPersister entityPersister, EntityMode entityMode) {
        if (serializable == null) {
            throw new AssertionFailure("null identifier");
        }
        this.identifier = serializable;
        this.entityMode = entityMode;
        this.rootEntityName = entityPersister.getRootEntityName();
        this.entityName = entityPersister.getEntityName();
        this.identifierType = entityPersister.getIdentifierType();
        this.isBatchLoadable = entityPersister.isBatchLoadable();
        this.factory = entityPersister.getFactory();
        this.hashCode = this.generateHashCode();
    }

    private EntityKey(Serializable serializable, String string, String string2, Type type, boolean bl, SessionFactoryImplementor sessionFactoryImplementor, EntityMode entityMode) {
        this.identifier = serializable;
        this.rootEntityName = string;
        this.entityName = string2;
        this.identifierType = type;
        this.isBatchLoadable = bl;
        this.factory = sessionFactoryImplementor;
        this.entityMode = entityMode;
        this.hashCode = this.generateHashCode();
    }

    public boolean isBatchLoadable() {
        return this.isBatchLoadable;
    }

    public Serializable getIdentifier() {
        return this.identifier;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean equals(Object object) {
        EntityKey entityKey = (EntityKey)object;
        return entityKey.rootEntityName.equals(this.rootEntityName) && this.identifierType.isEqual(entityKey.identifier, this.identifier, this.entityMode, this.factory);
    }

    private int generateHashCode() {
        int n = 17;
        n = 37 * n + this.rootEntityName.hashCode();
        n = 37 * n + this.identifierType.getHashCode(this.identifier, this.entityMode, this.factory);
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "EntityKey" + MessageHelper.infoString(this.factory.getEntityPersister(this.entityName), this.identifier, this.factory);
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.identifier);
        objectOutputStream.writeObject(this.rootEntityName);
        objectOutputStream.writeObject(this.entityName);
        objectOutputStream.writeObject(this.identifierType);
        objectOutputStream.writeBoolean(this.isBatchLoadable);
        objectOutputStream.writeObject(this.entityMode.toString());
    }

    static EntityKey deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        return new EntityKey((Serializable)objectInputStream.readObject(), (String)objectInputStream.readObject(), (String)objectInputStream.readObject(), (Type)objectInputStream.readObject(), objectInputStream.readBoolean(), sessionImplementor.getFactory(), EntityMode.parse((String)objectInputStream.readObject()));
    }
}

