/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;

public final class EntityEntry
implements Serializable {
    private LockMode lockMode;
    private Status status;
    private final Serializable id;
    private Object[] loadedState;
    private Object[] deletedState;
    private boolean existsInDatabase;
    private Object version;
    private transient EntityPersister persister;
    private final EntityMode entityMode;
    private final String entityName;
    private boolean isBeingReplicated;
    private boolean loadedWithLazyPropertiesUnfetched;
    private final transient Object rowId;

    EntityEntry(Status status, Object[] objectArray, Object object, Serializable serializable, Object object2, LockMode lockMode, boolean bl, EntityPersister entityPersister, EntityMode entityMode, boolean bl2, boolean bl3) {
        this.status = status;
        this.loadedState = objectArray;
        this.id = serializable;
        this.rowId = object;
        this.existsInDatabase = bl;
        this.version = object2;
        this.lockMode = lockMode;
        this.isBeingReplicated = bl2;
        this.loadedWithLazyPropertiesUnfetched = bl3;
        this.persister = entityPersister;
        this.entityMode = entityMode;
        this.entityName = entityPersister == null ? null : entityPersister.getEntityName();
    }

    private EntityEntry(SessionFactoryImplementor sessionFactoryImplementor, String string, Serializable serializable, EntityMode entityMode, Status status, Object[] objectArray, Object[] objectArray2, Object object, LockMode lockMode, boolean bl, boolean bl2, boolean bl3) {
        this.entityName = string;
        this.persister = sessionFactoryImplementor.getEntityPersister(string);
        this.id = serializable;
        this.entityMode = entityMode;
        this.status = status;
        this.loadedState = objectArray;
        this.deletedState = objectArray2;
        this.version = object;
        this.lockMode = lockMode;
        this.existsInDatabase = bl;
        this.isBeingReplicated = bl2;
        this.loadedWithLazyPropertiesUnfetched = bl3;
        this.rowId = null;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == Status.READ_ONLY) {
            this.loadedState = null;
        }
        this.status = status;
    }

    public Serializable getId() {
        return this.id;
    }

    public Object[] getLoadedState() {
        return this.loadedState;
    }

    public Object[] getDeletedState() {
        return this.deletedState;
    }

    public void setDeletedState(Object[] objectArray) {
        this.deletedState = objectArray;
    }

    public boolean isExistsInDatabase() {
        return this.existsInDatabase;
    }

    public Object getVersion() {
        return this.version;
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    void afterDeserialize(SessionFactoryImplementor sessionFactoryImplementor) {
        this.persister = sessionFactoryImplementor.getEntityPersister(this.entityName);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isBeingReplicated() {
        return this.isBeingReplicated;
    }

    public Object getRowId() {
        return this.rowId;
    }

    public void postUpdate(Object object, Object[] objectArray, Object object2) {
        this.loadedState = objectArray;
        this.setLockMode(LockMode.WRITE);
        if (this.getPersister().isVersioned()) {
            this.version = object2;
            this.getPersister().setPropertyValue(object, this.getPersister().getVersionProperty(), object2, this.entityMode);
        }
        FieldInterceptionHelper.clearDirty(object);
    }

    public void postDelete() {
        this.status = Status.GONE;
        this.existsInDatabase = false;
    }

    public void postInsert() {
        this.existsInDatabase = true;
    }

    public boolean isNullifiable(boolean bl, SessionImplementor sessionImplementor) {
        return this.getStatus() == Status.SAVING || (bl ? !this.isExistsInDatabase() : sessionImplementor.getPersistenceContext().getNullifiableEntityKeys().contains(new EntityKey(this.getId(), this.getPersister(), this.entityMode)));
    }

    public Object getLoadedValue(String string) {
        int n = ((UniqueKeyLoadable)this.persister).getPropertyIndex(string);
        return this.loadedState[n];
    }

    public boolean requiresDirtyCheck(Object object) {
        boolean bl = this.status != Status.READ_ONLY && this.persister.isMutable();
        return bl && (this.getPersister().hasMutableProperties() || !FieldInterceptionHelper.isInstrumented(object) || FieldInterceptionHelper.extractFieldInterceptor(object).isDirty());
    }

    public void forceLocked(Object object, Object object2) {
        this.loadedState[this.persister.getVersionProperty()] = this.version = object2;
        this.setLockMode(LockMode.FORCE);
        this.persister.setPropertyValue(object, this.getPersister().getVersionProperty(), object2, this.entityMode);
    }

    public void setReadOnly(boolean bl, Object object) {
        if (this.status != Status.MANAGED && this.status != Status.READ_ONLY) {
            throw new HibernateException("instance was not in a valid state");
        }
        if (bl) {
            this.setStatus(Status.READ_ONLY);
            this.loadedState = null;
        } else {
            this.setStatus(Status.MANAGED);
            this.loadedState = this.getPersister().getPropertyValues(object, this.entityMode);
        }
    }

    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.entityName, this.id) + '(' + this.status + ')';
    }

    public boolean isLoadedWithLazyPropertiesUnfetched() {
        return this.loadedWithLazyPropertiesUnfetched;
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.entityName);
        objectOutputStream.writeObject(this.id);
        objectOutputStream.writeObject(this.entityMode.toString());
        objectOutputStream.writeObject(this.status.toString());
        objectOutputStream.writeObject(this.loadedState);
        objectOutputStream.writeObject(this.deletedState);
        objectOutputStream.writeObject(this.version);
        objectOutputStream.writeObject(this.lockMode.toString());
        objectOutputStream.writeBoolean(this.existsInDatabase);
        objectOutputStream.writeBoolean(this.isBeingReplicated);
        objectOutputStream.writeBoolean(this.loadedWithLazyPropertiesUnfetched);
    }

    static EntityEntry deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        return new EntityEntry(sessionImplementor.getFactory(), (String)objectInputStream.readObject(), (Serializable)objectInputStream.readObject(), EntityMode.parse((String)objectInputStream.readObject()), Status.parse((String)objectInputStream.readObject()), (Object[])objectInputStream.readObject(), (Object[])objectInputStream.readObject(), objectInputStream.readObject(), LockMode.parse((String)objectInputStream.readObject()), objectInputStream.readBoolean(), objectInputStream.readBoolean(), objectInputStream.readBoolean());
    }
}

