/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;

public final class Collections {
    private static final Log log = LogFactory.getLog((Class)Collections.class);

    private Collections() {
    }

    public static void processUnreachableCollection(PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        if (persistentCollection.getOwner() == null) {
            Collections.processNeverReferencedCollection(persistentCollection, sessionImplementor);
        } else {
            Collections.processDereferencedCollection(persistentCollection, sessionImplementor);
        }
    }

    private static void processDereferencedCollection(PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(persistentCollection);
        CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
        if (log.isDebugEnabled() && collectionPersister != null) {
            log.debug((Object)("Collection dereferenced: " + MessageHelper.collectionInfoString(collectionPersister, collectionEntry.getLoadedKey(), sessionImplementor.getFactory())));
        }
        boolean bl2 = bl = collectionPersister != null && collectionPersister.hasOrphanDelete();
        if (bl) {
            Object object;
            Serializable serializable;
            Serializable serializable2 = collectionPersister.getOwnerEntityPersister().getIdentifier(persistentCollection.getOwner(), sessionImplementor.getEntityMode());
            if (serializable2 == null) {
                if (sessionImplementor.getFactory().getSettings().isIdentifierRollbackEnabled() && (serializable = persistenceContext.getEntry(persistentCollection.getOwner())) != null) {
                    serializable2 = ((EntityEntry)serializable).getId();
                }
                if (serializable2 == null) {
                    throw new AssertionFailure("Unable to determine collection owner identifier for orphan-delete processing");
                }
            }
            if ((object = persistenceContext.getEntity((EntityKey)(serializable = new EntityKey(serializable2, collectionPersister.getOwnerEntityPersister(), sessionImplementor.getEntityMode())))) == null) {
                throw new AssertionFailure("collection owner not associated with session: " + collectionPersister.getRole());
            }
            EntityEntry entityEntry = persistenceContext.getEntry(object);
            if (entityEntry != null && entityEntry.getStatus() != Status.DELETED && entityEntry.getStatus() != Status.GONE) {
                throw new HibernateException("A collection with cascade=\"all-delete-orphan\" was no longer referenced by the owning entity instance: " + collectionPersister.getRole());
            }
        }
        collectionEntry.setCurrentPersister(null);
        collectionEntry.setCurrentKey(null);
        Collections.prepareCollectionForUpdate(persistentCollection, collectionEntry, sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
    }

    private static void processNeverReferencedCollection(PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(persistentCollection);
        log.debug((Object)("Found collection with unloaded owner: " + MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), sessionImplementor.getFactory())));
        collectionEntry.setCurrentPersister(collectionEntry.getLoadedPersister());
        collectionEntry.setCurrentKey(collectionEntry.getLoadedKey());
        Collections.prepareCollectionForUpdate(persistentCollection, collectionEntry, sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
    }

    public static void processReachableCollection(PersistentCollection persistentCollection, CollectionType collectionType, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        persistentCollection.setOwner(object);
        CollectionEntry collectionEntry = sessionImplementor.getPersistenceContext().getCollectionEntry(persistentCollection);
        if (collectionEntry == null) {
            throw new HibernateException("Found two representations of same collection: " + collectionType.getRole());
        }
        if (collectionEntry.isReached()) {
            throw new HibernateException("Found shared references to a collection: " + collectionType.getRole());
        }
        collectionEntry.setReached(true);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        CollectionPersister collectionPersister = sessionFactoryImplementor.getCollectionPersister(collectionType.getRole());
        collectionEntry.setCurrentPersister(collectionPersister);
        collectionEntry.setCurrentKey(collectionType.getKeyOfOwner(object, sessionImplementor));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collection found: " + MessageHelper.collectionInfoString(collectionPersister, collectionEntry.getCurrentKey(), sessionFactoryImplementor) + ", was: " + MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), sessionFactoryImplementor) + (persistentCollection.wasInitialized() ? " (initialized)" : " (uninitialized)")));
        }
        Collections.prepareCollectionForUpdate(persistentCollection, collectionEntry, sessionImplementor.getEntityMode(), sessionFactoryImplementor);
    }

    private static void prepareCollectionForUpdate(PersistentCollection persistentCollection, CollectionEntry collectionEntry, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        if (collectionEntry.isProcessed()) {
            throw new AssertionFailure("collection was processed twice by flush()");
        }
        collectionEntry.setProcessed(true);
        CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
        CollectionPersister collectionPersister2 = collectionEntry.getCurrentPersister();
        if (collectionPersister != null || collectionPersister2 != null) {
            boolean bl;
            boolean bl2 = bl = collectionPersister != collectionPersister2 || !collectionPersister2.getKeyType().isEqual(collectionEntry.getLoadedKey(), collectionEntry.getCurrentKey(), entityMode, sessionFactoryImplementor);
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = collectionPersister != null && collectionPersister2 != null && collectionPersister.hasOrphanDelete();
                if (bl3) {
                    throw new HibernateException("Don't change the reference to a collection with cascade=\"all-delete-orphan\": " + collectionPersister.getRole());
                }
                if (collectionPersister2 != null) {
                    collectionEntry.setDorecreate(true);
                }
                if (collectionPersister != null) {
                    collectionEntry.setDoremove(true);
                    if (collectionEntry.isDorecreate()) {
                        log.trace((Object)"Forcing collection initialization");
                        persistentCollection.forceInitialization();
                    }
                }
            } else if (persistentCollection.isDirty()) {
                collectionEntry.setDoupdate(true);
            }
        }
    }
}

