/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionEntry
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)CollectionEntry.class);
    private Serializable snapshot;
    private String role;
    private transient CollectionPersister loadedPersister;
    private Serializable loadedKey;
    private transient boolean reached;
    private transient boolean processed;
    private transient boolean doupdate;
    private transient boolean doremove;
    private transient boolean dorecreate;
    private transient boolean ignore;
    private transient CollectionPersister currentPersister;
    private transient Serializable currentKey;

    public CollectionEntry(CollectionPersister collectionPersister, PersistentCollection persistentCollection) {
        this.ignore = false;
        persistentCollection.clearDirty();
        this.snapshot = collectionPersister.isMutable() ? persistentCollection.getSnapshot(collectionPersister) : null;
        persistentCollection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public CollectionEntry(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, boolean bl) {
        this.ignore = bl;
        this.loadedKey = serializable;
        this.setLoadedPersister(collectionPersister);
        persistentCollection.setSnapshot(serializable, this.role, null);
    }

    public CollectionEntry(CollectionPersister collectionPersister, Serializable serializable) {
        this.ignore = false;
        this.loadedKey = serializable;
        this.setLoadedPersister(collectionPersister);
    }

    CollectionEntry(PersistentCollection persistentCollection, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        this.ignore = false;
        this.loadedKey = persistentCollection.getKey();
        this.setLoadedPersister(sessionFactoryImplementor.getCollectionPersister(persistentCollection.getRole()));
        this.snapshot = persistentCollection.getStoredSnapshot();
    }

    private CollectionEntry(String string, Serializable serializable, Serializable serializable2, SessionFactoryImplementor sessionFactoryImplementor) {
        this.role = string;
        this.snapshot = serializable;
        this.loadedKey = serializable2;
        if (string != null) {
            this.afterDeserialize(sessionFactoryImplementor);
        }
    }

    private void dirty(PersistentCollection persistentCollection) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = persistentCollection.wasInitialized() && !persistentCollection.isDirty() && this.getLoadedPersister() != null && this.getLoadedPersister().isMutable() && (persistentCollection.isDirectlyAccessible() || this.getLoadedPersister().getElementType().isMutable()) && !persistentCollection.equalsSnapshot(this.getLoadedPersister());
        if (bl) {
            persistentCollection.dirty();
        }
    }

    public void preFlush(PersistentCollection persistentCollection) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = persistentCollection.isDirty() && this.getLoadedPersister() != null && !this.getLoadedPersister().isMutable();
        if (bl) {
            throw new HibernateException("changed an immutable collection instance: " + MessageHelper.collectionInfoString(this.getLoadedPersister().getRole(), this.getLoadedKey()));
        }
        this.dirty(persistentCollection);
        if (log.isDebugEnabled() && persistentCollection.isDirty() && this.getLoadedPersister() != null) {
            log.debug((Object)("Collection dirty: " + MessageHelper.collectionInfoString(this.getLoadedPersister().getRole(), this.getLoadedKey())));
        }
        this.setDoupdate(false);
        this.setDoremove(false);
        this.setDorecreate(false);
        this.setReached(false);
        this.setProcessed(false);
    }

    public void postInitialize(PersistentCollection persistentCollection) throws HibernateException {
        this.snapshot = this.getLoadedPersister().isMutable() ? persistentCollection.getSnapshot(this.getLoadedPersister()) : null;
        persistentCollection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public void postFlush(PersistentCollection persistentCollection) throws HibernateException {
        if (this.isIgnore()) {
            this.ignore = false;
        } else if (!this.isProcessed()) {
            throw new AssertionFailure("collection [" + persistentCollection.getRole() + "] was not processed by flush()");
        }
        persistentCollection.setSnapshot(this.loadedKey, this.role, this.snapshot);
    }

    public void afterAction(PersistentCollection persistentCollection) {
        boolean bl;
        this.loadedKey = this.getCurrentKey();
        this.setLoadedPersister(this.getCurrentPersister());
        boolean bl2 = bl = persistentCollection.wasInitialized() && (this.isDoremove() || this.isDorecreate() || this.isDoupdate());
        if (bl) {
            this.snapshot = this.loadedPersister == null || !this.loadedPersister.isMutable() ? null : persistentCollection.getSnapshot(this.loadedPersister);
        }
        persistentCollection.postAction();
    }

    public Serializable getKey() {
        return this.getLoadedKey();
    }

    public String getRole() {
        return this.role;
    }

    public Serializable getSnapshot() {
        return this.snapshot;
    }

    private void setLoadedPersister(CollectionPersister collectionPersister) {
        this.loadedPersister = collectionPersister;
        this.setRole(collectionPersister == null ? null : collectionPersister.getRole());
    }

    void afterDeserialize(SessionFactoryImplementor sessionFactoryImplementor) {
        this.loadedPersister = sessionFactoryImplementor.getCollectionPersister(this.role);
    }

    public boolean wasDereferenced() {
        return this.getLoadedKey() == null;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean bl) {
        this.reached = bl;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public boolean isDoupdate() {
        return this.doupdate;
    }

    public void setDoupdate(boolean bl) {
        this.doupdate = bl;
    }

    public boolean isDoremove() {
        return this.doremove;
    }

    public void setDoremove(boolean bl) {
        this.doremove = bl;
    }

    public boolean isDorecreate() {
        return this.dorecreate;
    }

    public void setDorecreate(boolean bl) {
        this.dorecreate = bl;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public CollectionPersister getCurrentPersister() {
        return this.currentPersister;
    }

    public void setCurrentPersister(CollectionPersister collectionPersister) {
        this.currentPersister = collectionPersister;
    }

    public Serializable getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(Serializable serializable) {
        this.currentKey = serializable;
    }

    public CollectionPersister getLoadedPersister() {
        return this.loadedPersister;
    }

    public Serializable getLoadedKey() {
        return this.loadedKey;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public String toString() {
        String string = "CollectionEntry" + MessageHelper.collectionInfoString(this.loadedPersister.getRole(), this.loadedKey);
        if (this.currentPersister != null) {
            string = string + "->" + MessageHelper.collectionInfoString(this.currentPersister.getRole(), this.currentKey);
        }
        return string;
    }

    public Collection getOrphans(String string, PersistentCollection persistentCollection) throws HibernateException {
        if (this.snapshot == null) {
            throw new AssertionFailure("no collection snapshot for orphan delete");
        }
        return persistentCollection.getOrphans(this.snapshot, string);
    }

    public boolean isSnapshotEmpty(PersistentCollection persistentCollection) {
        return persistentCollection.wasInitialized() && (this.getLoadedPersister() == null || this.getLoadedPersister().isMutable()) && persistentCollection.isSnapshotEmpty(this.getSnapshot());
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.role);
        objectOutputStream.writeObject(this.snapshot);
        objectOutputStream.writeObject(this.loadedKey);
    }

    static CollectionEntry deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        return new CollectionEntry((String)objectInputStream.readObject(), (Serializable)objectInputStream.readObject(), (Serializable)objectInputStream.readObject(), sessionImplementor.getFactory());
    }
}

