/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class CascadingAction {
    private static final Log log = LogFactory.getLog((Class)CascadingAction.class);
    public static final CascadingAction DELETE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to delete: " + string));
            }
            eventSource.delete(string, object, bl, (Set)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return CascadingAction.getAllElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_DELETE";
        }
    };
    public static final CascadingAction LOCK = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to lock: " + string));
            }
            eventSource.lock(string, object, LockMode.NONE);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 3.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_LOCK";
        }
    };
    public static final CascadingAction REFRESH = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to refresh: " + string));
            }
            eventSource.refresh(object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 4.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REFRESH";
        }
    };
    public static final CascadingAction EVICT = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to evict: " + string));
            }
            eventSource.evict(object);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 5.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_EVICT";
        }
    };
    public static final CascadingAction SAVE_UPDATE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to saveOrUpdate: " + string));
            }
            eventSource.saveOrUpdate(string, object);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 1.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE";
        }
    };
    public static final CascadingAction MERGE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to merge: " + string));
            }
            eventSource.merge(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 6.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_MERGE";
        }
    };
    public static final CascadingAction SAVE_UPDATE_COPY = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to saveOrUpdateCopy: " + string));
            }
            eventSource.saveOrUpdateCopy(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 7.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE_COPY";
        }
    };
    public static final CascadingAction PERSIST = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to persist: " + string));
            }
            eventSource.persist(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return CascadingAction.getAllElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST";
        }
    };
    public static final CascadingAction PERSIST_ON_FLUSH = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to persistOnFlush: " + string));
            }
            eventSource.persistOnFlush(string, object, (Map)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return CascadingAction.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public boolean requiresNoCascadeChecking() {
            return true;
        }

        public void noCascade(EventSource eventSource, Object object, Object object2, EntityPersister entityPersister, int n) {
            if (object == null) {
                return;
            }
            Type type = entityPersister.getPropertyTypes()[n];
            if (type.isEntityType()) {
                String string = ((EntityType)type).getAssociatedEntityName(eventSource.getFactory());
                if (!this.isInManagedState(object, eventSource) && !(object instanceof HibernateProxy) && ForeignKeys.isTransient(string, object, null, eventSource)) {
                    String string2 = entityPersister.getEntityName();
                    String string3 = entityPersister.getPropertyNames()[n];
                    throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + string2 + "." + string3 + " -> " + string);
                }
            }
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        private boolean isInManagedState(Object object, EventSource eventSource) {
            EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
            return entityEntry != null && (entityEntry.getStatus() == Status.MANAGED || entityEntry.getStatus() == Status.READ_ONLY);
        }

        public String toString() {
            return "ACTION_PERSIST_ON_FLUSH";
        }
    };
    public static final CascadingAction REPLICATE = new CascadingAction(){

        public void cascade(EventSource eventSource, Object object, String string, Object object2, boolean bl) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to replicate: " + string));
            }
            eventSource.replicate(string, object, (ReplicationMode)object2);
        }

        public Iterator getCascadableChildrenIterator(EventSource eventSource, CollectionType collectionType, Object object) {
            return 10.getLoadedElementsIterator(eventSource, collectionType, object);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REPLICATE";
        }
    };

    CascadingAction() {
    }

    public abstract void cascade(EventSource var1, Object var2, String var3, Object var4, boolean var5) throws HibernateException;

    public abstract Iterator getCascadableChildrenIterator(EventSource var1, CollectionType var2, Object var3);

    public abstract boolean deleteOrphans();

    public boolean requiresNoCascadeChecking() {
        return false;
    }

    public void noCascade(EventSource eventSource, Object object, Object object2, EntityPersister entityPersister, int n) {
    }

    public boolean performOnLazyProperty() {
        return true;
    }

    private static Iterator getAllElementsIterator(EventSource eventSource, CollectionType collectionType, Object object) {
        return collectionType.getElementsIterator(object, eventSource);
    }

    public static Iterator getLoadedElementsIterator(SessionImplementor sessionImplementor, CollectionType collectionType, Object object) {
        if (CascadingAction.collectionIsInitialized(object)) {
            return collectionType.getElementsIterator(object, sessionImplementor);
        }
        return ((PersistentCollection)object).queuedAdditionIterator();
    }

    private static boolean collectionIsInitialized(Object object) {
        return !(object instanceof PersistentCollection) || ((PersistentCollection)object).wasInitialized();
    }
}

