/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.event.EventSource;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public final class Cascade {
    public static final int AFTER_INSERT_BEFORE_DELETE = 1;
    public static final int BEFORE_INSERT_AFTER_DELETE = 2;
    public static final int AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION = 3;
    public static final int AFTER_UPDATE = 0;
    public static final int BEFORE_FLUSH = 0;
    public static final int AFTER_EVICT = 0;
    public static final int BEFORE_REFRESH = 0;
    public static final int AFTER_LOCK = 0;
    public static final int BEFORE_MERGE = 0;
    private static final Log log = LogFactory.getLog((Class)Cascade.class);
    private int cascadeTo;
    private EventSource eventSource;
    private CascadingAction action;

    public Cascade(CascadingAction cascadingAction, int n, EventSource eventSource) {
        this.cascadeTo = n;
        this.eventSource = eventSource;
        this.action = cascadingAction;
    }

    public void cascade(EntityPersister entityPersister, Object object) throws HibernateException {
        this.cascade(entityPersister, object, null);
    }

    public void cascade(EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
        if (entityPersister.hasCascades() || this.action.requiresNoCascadeChecking()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing cascade " + this.action + " for: " + entityPersister.getEntityName()));
            }
            Type[] typeArray = entityPersister.getPropertyTypes();
            CascadeStyle[] cascadeStyleArray = entityPersister.getPropertyCascadeStyles();
            EntityMode entityMode = this.eventSource.getEntityMode();
            boolean bl = entityPersister.hasUninitializedLazyProperties(object, entityMode);
            for (int i = 0; i < typeArray.length; ++i) {
                CascadeStyle cascadeStyle = cascadeStyleArray[i];
                if (bl && entityPersister.getPropertyLaziness()[i] && !this.action.performOnLazyProperty()) continue;
                if (cascadeStyle.doCascade(this.action)) {
                    this.cascadeProperty(entityPersister.getPropertyValue(object, i, entityMode), typeArray[i], cascadeStyle, object2, false);
                    continue;
                }
                if (!this.action.requiresNoCascadeChecking()) continue;
                this.action.noCascade(this.eventSource, entityPersister.getPropertyValue(object, i, entityMode), object, entityPersister, i);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done processing cascade " + this.action + " for: " + entityPersister.getEntityName()));
            }
        }
    }

    private void cascadeProperty(Object object, Type type, CascadeStyle cascadeStyle, Object object2, boolean bl) throws HibernateException {
        if (object != null) {
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                if (this.cascadeAssociationNow(associationType)) {
                    this.cascadeAssociation(object, type, cascadeStyle, object2, bl);
                }
            } else if (type.isComponentType()) {
                this.cascadeComponent(object, (AbstractComponentType)type, object2);
            }
        }
    }

    private boolean cascadeAssociationNow(AssociationType associationType) {
        return associationType.getForeignKeyDirection().cascadeNow(this.cascadeTo) && (this.eventSource.getEntityMode() != EntityMode.DOM4J || associationType.isEmbeddedInXML());
    }

    private void cascadeComponent(Object object, AbstractComponentType abstractComponentType, Object object2) {
        Object[] objectArray = abstractComponentType.getPropertyValues(object, this.eventSource);
        Type[] typeArray = abstractComponentType.getSubtypes();
        for (int i = 0; i < typeArray.length; ++i) {
            CascadeStyle cascadeStyle = abstractComponentType.getCascadeStyle(i);
            if (!cascadeStyle.doCascade(this.action)) continue;
            this.cascadeProperty(objectArray[i], typeArray[i], cascadeStyle, object2, false);
        }
    }

    private void cascadeAssociation(Object object, Type type, CascadeStyle cascadeStyle, Object object2, boolean bl) {
        if (type.isEntityType() || type.isAnyType()) {
            this.cascadeToOne(object, type, cascadeStyle, object2, bl);
        } else if (type.isCollectionType()) {
            this.cascadeCollection(object, cascadeStyle, object2, (CollectionType)type);
        }
    }

    private void cascadeCollection(Object object, CascadeStyle cascadeStyle, Object object2, CollectionType collectionType) {
        CollectionPersister collectionPersister = this.eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        Type type = collectionPersister.getElementType();
        int n = this.cascadeTo;
        if (this.cascadeTo == 1) {
            this.cascadeTo = 3;
        }
        if (type.isEntityType() || type.isAnyType() || type.isComponentType()) {
            this.cascadeCollectionElements(object, collectionType, cascadeStyle, type, object2, collectionPersister.isCascadeDeleteEnabled());
        }
        this.cascadeTo = n;
    }

    private void cascadeToOne(Object object, Type type, CascadeStyle cascadeStyle, Object object2, boolean bl) {
        String string;
        String string2 = string = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
        if (cascadeStyle.reallyDoCascade(this.action)) {
            this.action.cascade(this.eventSource, object, string, object2, bl);
        }
    }

    private void cascadeCollectionElements(Object object, CollectionType collectionType, CascadeStyle cascadeStyle, Type type, Object object2, boolean bl) throws HibernateException {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.eventSource.getEntityMode() != EntityMode.DOM4J || ((EntityType)collectionType.getElementType(this.eventSource.getFactory())).isEmbeddedInXML();
        boolean bl5 = bl3 = cascadeStyle.reallyDoCascade(this.action) && bl4 && object != CollectionType.UNFETCHED_COLLECTION;
        if (bl3) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascade " + this.action + " for collection: " + collectionType.getRole()));
            }
            Iterator iterator = this.action.getCascadableChildrenIterator(this.eventSource, collectionType, object);
            while (iterator.hasNext()) {
                this.cascadeProperty(iterator.next(), type, cascadeStyle, object2, bl);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done cascade " + this.action + " for collection: " + collectionType.getRole()));
            }
        }
        boolean bl6 = bl2 = cascadeStyle.hasOrphanDelete() && this.action.deleteOrphans() && type.isEntityType() && object instanceof PersistentCollection;
        if (bl2) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleting orphans for collection: " + collectionType.getRole()));
            }
            String string = collectionType.getAssociatedEntityName(this.eventSource.getFactory());
            this.deleteOrphans(string, (PersistentCollection)object);
            if (log.isTraceEnabled()) {
                log.trace((Object)("done deleting orphans for collection: " + collectionType.getRole()));
            }
        }
    }

    private void deleteOrphans(String string, PersistentCollection persistentCollection) throws HibernateException {
        Object object;
        Collection collection = persistentCollection.wasInitialized() ? ((object = this.eventSource.getPersistenceContext().getCollectionEntry(persistentCollection)) == null ? CollectionHelper.EMPTY_COLLECTION : ((CollectionEntry)object).getOrphans(string, persistentCollection)) : persistentCollection.getQueuedOrphans(string);
        object = collection.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e == null) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleting orphaned entity instance: " + string));
            }
            this.eventSource.delete(string, e, false, null);
        }
    }
}

