/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.SessionImplementor;

public class ActionQueue {
    private static final Log log = LogFactory.getLog((Class)ActionQueue.class);
    private static final int INIT_QUEUE_LIST_SIZE = 5;
    private SessionImplementor session;
    private ArrayList insertions;
    private ArrayList deletions;
    private ArrayList updates;
    private ArrayList collectionCreations;
    private ArrayList collectionUpdates;
    private ArrayList collectionRemovals;
    private ArrayList executions;

    public ActionQueue(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.init();
    }

    private void init() {
        this.insertions = new ArrayList(5);
        this.deletions = new ArrayList(5);
        this.updates = new ArrayList(5);
        this.collectionCreations = new ArrayList(5);
        this.collectionRemovals = new ArrayList(5);
        this.collectionUpdates = new ArrayList(5);
        this.executions = new ArrayList(15);
    }

    public void clear() {
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
    }

    public void addAction(EntityInsertAction entityInsertAction) {
        this.insertions.add(entityInsertAction);
    }

    public void addAction(EntityDeleteAction entityDeleteAction) {
        this.deletions.add(entityDeleteAction);
    }

    public void addAction(EntityUpdateAction entityUpdateAction) {
        this.updates.add(entityUpdateAction);
    }

    public void addAction(CollectionRecreateAction collectionRecreateAction) {
        this.collectionCreations.add(collectionRecreateAction);
    }

    public void addAction(CollectionRemoveAction collectionRemoveAction) {
        this.collectionRemovals.add(collectionRemoveAction);
    }

    public void addAction(CollectionUpdateAction collectionUpdateAction) {
        this.collectionUpdates.add(collectionUpdateAction);
    }

    public void addAction(EntityIdentityInsertAction entityIdentityInsertAction) {
        this.insertions.add(entityIdentityInsertAction);
    }

    public void addAction(BulkOperationCleanupAction bulkOperationCleanupAction) {
        this.executions.add(bulkOperationCleanupAction);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        this.executeActions(this.insertions);
        this.executeActions(this.updates);
        this.executeActions(this.collectionRemovals);
        this.executeActions(this.collectionUpdates);
        this.executeActions(this.collectionCreations);
        this.executeActions(this.deletions);
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTransactionCompletion(boolean bl) {
        int n = this.executions.size();
        boolean bl2 = this.session.getFactory().getSettings().isQueryCacheEnabled();
        for (int i = 0; i < n; ++i) {
            try {
                Object var7_8;
                Executable executable = (Executable)this.executions.get(i);
                try {
                    executable.afterTransactionCompletion(bl);
                    var7_8 = null;
                    if (!bl2) continue;
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    if (bl2) {
                        this.session.getFactory().getUpdateTimestampsCache().invalidate(executable.getPropertySpaces());
                    }
                    throw throwable;
                }
                this.session.getFactory().getUpdateTimestampsCache().invalidate(executable.getPropertySpaces());
                {
                    continue;
                }
            }
            catch (CacheException cacheException) {
                log.error((Object)"could not release a cache lock", (Throwable)cacheException);
                continue;
            }
            catch (Exception exception) {
                throw new AssertionFailure("Exception releasing cache locks", exception);
            }
        }
        this.executions.clear();
    }

    public boolean areTablesToBeUpdated(Set set) {
        return ActionQueue.areTablesToUpdated(this.updates, set) || ActionQueue.areTablesToUpdated(this.insertions, set) || ActionQueue.areTablesToUpdated(this.deletions, set) || ActionQueue.areTablesToUpdated(this.collectionUpdates, set) || ActionQueue.areTablesToUpdated(this.collectionCreations, set) || ActionQueue.areTablesToUpdated(this.collectionRemovals, set);
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions.size() > 0 || this.deletions.size() > 0;
    }

    private static boolean areTablesToUpdated(List list, Set set) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Serializable[] serializableArray = ((Executable)list.get(i)).getPropertySpaces();
            for (int j = 0; j < serializableArray.length; ++j) {
                if (!set.contains(serializableArray[j])) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("changes must be flushed to space: " + serializableArray[j]));
                }
                return true;
            }
        }
        return false;
    }

    private void executeActions(List list) throws HibernateException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.execute((Executable)list.get(i));
        }
        list.clear();
        this.session.getBatcher().executeBatch();
    }

    public void execute(Executable executable) {
        boolean bl = this.session.getFactory().getSettings().isQueryCacheEnabled();
        if (executable.hasAfterTransactionCompletion() || bl) {
            this.executions.add(executable);
        }
        if (bl) {
            this.session.getFactory().getUpdateTimestampsCache().preinvalidate(executable.getPropertySpaces());
        }
        executable.execute();
    }

    private void prepareActions(List list) throws HibernateException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Executable executable = (Executable)list.get(i);
            executable.beforeExecutions();
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + this.insertions + " updates=" + this.updates + " deletions=" + this.deletions + " collectionCreations=" + this.collectionCreations + " collectionRemovals=" + this.collectionRemovals + " collectionUpdates=" + this.collectionUpdates + "]";
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.collectionCreations);
            Collections.sort(this.collectionUpdates);
            Collections.sort(this.collectionRemovals);
        }
    }

    public void sortUpdateActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.updates);
        }
    }

    public ArrayList cloneDeletions() {
        return (ArrayList)this.deletions.clone();
    }

    public void clearFromFlushNeededCheck(int n) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.updates.clear();
        for (int i = this.collectionRemovals.size() - 1; i >= n; --i) {
            this.collectionRemovals.remove(i);
        }
    }

    public boolean hasAnyQueuedActions() {
        return this.updates.size() > 0 || this.insertions.size() > 0 || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        log.trace((Object)"serializing action-queue");
        int n2 = this.insertions.size();
        log.trace((Object)("starting serialization of [" + n2 + "] insertions entries"));
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.insertions.get(n));
        }
        n2 = this.deletions.size();
        log.trace((Object)("starting serialization of [" + n2 + "] deletions entries"));
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.deletions.get(n));
        }
        n2 = this.updates.size();
        log.trace((Object)("starting serialization of [" + n2 + "] updates entries"));
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.updates.get(n));
        }
        n2 = this.collectionUpdates.size();
        log.trace((Object)("starting serialization of [" + n2 + "] collectionUpdates entries"));
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionUpdates.get(n));
        }
        n2 = this.collectionRemovals.size();
        log.trace((Object)("starting serialization of [" + n2 + "] collectionRemovals entries"));
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionRemovals.get(n));
        }
        n2 = this.collectionCreations.size();
        log.trace((Object)("starting serialization of [" + n2 + "] collectionCreations entries"));
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionCreations.get(n));
        }
    }

    public static ActionQueue deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        int n;
        log.trace((Object)"deserializing action-queue");
        ActionQueue actionQueue = new ActionQueue(sessionImplementor);
        int n2 = objectInputStream.readInt();
        log.trace((Object)("starting deserialization of [" + n2 + "] insertions entries"));
        actionQueue.insertions = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.insertions.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace((Object)("starting deserialization of [" + n2 + "] deletions entries"));
        actionQueue.deletions = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.deletions.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace((Object)("starting deserialization of [" + n2 + "] updates entries"));
        actionQueue.updates = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.updates.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace((Object)("starting deserialization of [" + n2 + "] collectionUpdates entries"));
        actionQueue.collectionUpdates = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.collectionUpdates.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace((Object)("starting deserialization of [" + n2 + "] collectionRemovals entries"));
        actionQueue.collectionRemovals = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.collectionRemovals.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace((Object)("starting deserialization of [" + n2 + "] collectionCreations entries"));
        actionQueue.collectionCreations = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.collectionCreations.add(objectInputStream.readObject());
        }
        return actionQueue;
    }
}

