/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;

public class UpdateLockingStrategy
implements LockingStrategy {
    private static final Log log = LogFactory.getLog((Class)UpdateLockingStrategy.class);
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public UpdateLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.UPGRADE)) {
            throw new HibernateException("[" + lockMode + "] not valid for update statement");
        }
        if (!lockable.isVersioned()) {
            log.warn((Object)("write locks via update not supported for non-versioned entities [" + lockable.getEntityName() + "]"));
            this.sql = null;
        } else {
            this.sql = this.generateLockString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable serializable, Object object, Object object2, SessionImplementor sessionImplementor) throws StaleObjectStateException, JDBCException {
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("write locks via update not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sql);
            try {
                int n;
                this.lockable.getVersionType().nullSafeSet(preparedStatement, object, 1, sessionImplementor);
                int n2 = 2;
                this.lockable.getIdentifierType().nullSafeSet(preparedStatement, serializable, n2, sessionImplementor);
                n2 += this.lockable.getIdentifierType().getColumnSpan(sessionFactoryImplementor);
                if (this.lockable.isVersioned()) {
                    this.lockable.getVersionType().nullSafeSet(preparedStatement, object, n2, sessionImplementor);
                }
                if ((n = preparedStatement.executeUpdate()) < 0) {
                    sessionFactoryImplementor.getStatisticsImplementor().optimisticFailure(this.lockable.getEntityName());
                    throw new StaleObjectStateException(this.lockable.getEntityName(), serializable);
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, serializable, sessionImplementor.getFactory()), this.sql);
        }
    }

    protected String generateLockString() {
        SessionFactoryImplementor sessionFactoryImplementor = this.lockable.getFactory();
        Update update = new Update(sessionFactoryImplementor.getDialect());
        update.setTableName(this.lockable.getRootTableName());
        update.setPrimaryKeyColumnNames(this.lockable.getRootTableIdentifierColumnNames());
        update.setVersionColumnName(this.lockable.getVersionColumnName());
        update.addColumn(this.lockable.getVersionColumnName());
        if (sessionFactoryImplementor.getSettings().isCommentsEnabled()) {
            update.setComment(this.lockMode + " lock " + this.lockable.getEntityName());
        }
        return update.toStatementString();
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

