/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class SelectLockingStrategy
implements LockingStrategy {
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public SelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        this.sql = this.generateLockString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable serializable, Object object, Object object2, SessionImplementor sessionImplementor) throws StaleObjectStateException, JDBCException {
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sql);
            try {
                this.lockable.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                if (this.lockable.isVersioned()) {
                    this.lockable.getVersionType().nullSafeSet(preparedStatement, object, this.lockable.getIdentifierType().getColumnSpan(sessionFactoryImplementor) + 1, sessionImplementor);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                            sessionFactoryImplementor.getStatisticsImplementor().optimisticFailure(this.lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(this.lockable.getEntityName(), serializable);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, serializable, sessionImplementor.getFactory()), this.sql);
        }
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected String generateLockString() {
        SessionFactoryImplementor sessionFactoryImplementor = this.lockable.getFactory();
        SimpleSelect simpleSelect = new SimpleSelect(sessionFactoryImplementor.getDialect()).setLockMode(this.lockMode).setTableName(this.lockable.getRootTableName()).addColumn(this.lockable.getRootTableIdentifierColumnNames()[0]).addCondition(this.lockable.getRootTableIdentifierColumnNames(), "=?");
        if (this.lockable.isVersioned()) {
            simpleSelect.addCondition(this.lockable.getVersionColumnName(), "=?");
        }
        if (sessionFactoryImplementor.getSettings().isCommentsEnabled()) {
            simpleSelect.setComment(this.lockMode + " lock " + this.lockable.getEntityName());
        }
        return simpleSelect.toStatementString();
    }
}

