/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class SQLFunctionTemplate
implements SQLFunction {
    private final Type type;
    private final boolean hasArguments;
    private final boolean hasParenthesesIfNoArgs;
    private final String template;
    private final String[] chunks;
    private final int[] paramIndexes;

    public SQLFunctionTemplate(Type type, String string) {
        this(type, string, true);
    }

    public SQLFunctionTemplate(Type type, String string, boolean bl) {
        int n;
        this.type = type;
        this.template = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        StringBuffer stringBuffer = new StringBuffer(10);
        StringBuffer stringBuffer2 = new StringBuffer(2);
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '?') {
                arrayList.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                while (++n < string.length()) {
                    c = string.charAt(n);
                    if (Character.isDigit(c)) {
                        stringBuffer2.append(c);
                        continue;
                    }
                    stringBuffer.append(c);
                    break;
                }
                arrayList2.add(new Integer(Integer.parseInt(stringBuffer2.toString()) - 1));
                stringBuffer2.delete(0, stringBuffer2.length());
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        this.chunks = arrayList.toArray(new String[arrayList.size()]);
        this.paramIndexes = new int[arrayList2.size()];
        for (n = 0; n < this.paramIndexes.length; ++n) {
            this.paramIndexes[n] = (Integer)arrayList2.get(n);
        }
        this.hasArguments = this.paramIndexes.length > 0;
        this.hasParenthesesIfNoArgs = bl;
    }

    public String render(List list, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.chunks.length; ++i) {
            if (i < this.paramIndexes.length) {
                Object var5_5;
                Object v0 = var5_5 = this.paramIndexes[i] < list.size() ? list.get(this.paramIndexes[i]) : null;
                if (var5_5 == null) continue;
                stringBuffer.append(this.chunks[i]).append((Object)var5_5);
                continue;
            }
            stringBuffer.append(this.chunks[i]);
        }
        return stringBuffer.toString();
    }

    public Type getReturnType(Type type, Mapping mapping) throws QueryException {
        return this.type;
    }

    public boolean hasArguments() {
        return this.hasArguments;
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArgs;
    }

    public String toString() {
        return this.template;
    }
}

