/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;

public class TimesTenDialect
extends Dialect {
    public TimesTenDialect() {
        this.registerColumnType(-7, "TINYINT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "VARBINARY($l)");
        this.registerColumnType(2, "DECIMAL($p, $s)");
        this.registerColumnType(2004, "VARBINARY(4000000)");
        this.registerColumnType(2005, "VARCHAR(4000000)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("concat", new StandardSQLFunction("concat", Hibernate.STRING));
        this.registerFunction("mod", new StandardSQLFunction("mod"));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", Hibernate.TIMESTAMP));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", Hibernate.TIMESTAMP, false));
        this.registerFunction("getdate", new NoArgSQLFunction("getdate", Hibernate.TIMESTAMP, false));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSelectSequenceNextValString(String string) {
        return string + ".nextval";
    }

    public String getSequenceNextValString(String string) {
        return "select first 1 " + string + ".nextval from sys.tables";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string;
    }

    public String getQuerySequencesString() {
        return "select NAME from sys.sequences";
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public String getLimitString(String string, int n, int n2) {
        if (n > 0) {
            throw new UnsupportedOperationException("TimesTen does not support offset");
        }
        return new StringBuffer(string.length() + 8).append(string).insert(6, " first " + n2).toString();
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select first 1 sysdate from sys.tables";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String string) {
        String string2 = super.generateTemporaryTableName(string);
        return string2.length() > 30 ? string2.substring(1, 30) : string2;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit delete rows";
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public boolean supportsEmptyInList() {
        return false;
    }
}

