/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;

public class TeradataDialect
extends Dialect {
    public TeradataDialect() {
        this.registerColumnType(2, "NUMERIC($p,$s)");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(-5, "NUMERIC(18,0)");
        this.registerColumnType(-7, "BYTEINT");
        this.registerColumnType(-6, "BYTEINT");
        this.registerColumnType(-3, "VARBYTE($l)");
        this.registerColumnType(-2, "BYTEINT");
        this.registerColumnType(-1, "LONG VARCHAR");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(3, "DECIMAL");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(16, "BYTEINT");
        this.registerColumnType(2004, "BLOB");
        this.registerColumnType(2005, "CLOB");
        this.registerFunction("year", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(year from ?1)"));
        this.registerFunction("length", new SQLFunctionTemplate(Hibernate.INTEGER, "character_length(?1)"));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("substring", new SQLFunctionTemplate(Hibernate.STRING, "substring(?1 from ?2 for ?3)"));
        this.registerFunction("locate", new SQLFunctionTemplate(Hibernate.STRING, "position(?1 in ?2)"));
        this.registerFunction("mod", new SQLFunctionTemplate(Hibernate.STRING, "?1 mod ?2"));
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "cast(?1 as varchar(255))"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "octet_length(cast(?1 as char))*4"));
        this.registerFunction("current_timestamp", new SQLFunctionTemplate(Hibernate.TIMESTAMP, "current_timestamp"));
        this.registerFunction("current_time", new SQLFunctionTemplate(Hibernate.TIMESTAMP, "current_time"));
        this.registerFunction("current_date", new SQLFunctionTemplate(Hibernate.TIMESTAMP, "current_date"));
        this.registerKeyword("password");
        this.registerKeyword("type");
        this.registerKeyword("title");
        this.registerKeyword("year");
        this.registerKeyword("month");
        this.registerKeyword("summary");
        this.registerKeyword("alias");
        this.registerKeyword("value");
        this.registerKeyword("first");
        this.registerKeyword("role");
        this.registerKeyword("account");
        this.registerKeyword("class");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public String getAddColumnString() {
        return "Add Column";
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return " on commit preserve rows";
    }

    public Boolean performTemporaryTableDDLInIsolation() {
        return Boolean.TRUE;
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public String getTypeName(int n, int n2, int n3, int n4) throws HibernateException {
        int n5;
        float f = n3 > 0 ? (float)n4 / (float)n3 : 0.0f;
        int n6 = n5 = n3 > 18 ? 18 : n3;
        int n7 = n3 > 18 ? (int)(18.0 * (double)f) : (n4 > 18 ? 18 : n4);
        return super.getTypeName(n, n2, n5, n7);
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public String getSelectClauseNullString(int n) {
        String string = "null";
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "cast(null as decimal)";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = "cast(null as varchar(255))";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = "cast(null as timestamp)";
                break;
            }
        }
        return string;
    }

    public String getCreateMultisetTableString() {
        return "create multiset table ";
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsBindAsCallableArgument() {
        return false;
    }
}

