/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.ReflectHelper;

public class Oracle9Dialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            int n = JDBCExceptionHelper.extractErrorCode(sQLException);
            if (n == 1 || n == 2291 || n == 2292) {
                return this.extractUsingTemplate("constraint (", ") violated", sQLException.getMessage());
            }
            if (n == 1400) {
                return null;
            }
            return null;
        }
    };
    int oracletypes_cursor_value = 0;

    public Oracle9Dialect() {
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000, "varchar2($l char)");
        this.registerColumnType(12, "long");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, 2000, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction("variance", Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("chr", new StandardSQLFunction("chr", Hibernate.CHARACTER));
        this.registerFunction("initcap", new StandardSQLFunction("initcap"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", Hibernate.TIMESTAMP));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_timestamp", Hibernate.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("lastday", new StandardSQLFunction("lastday", Hibernate.DATE));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", Hibernate.DATE, false));
        this.registerFunction("systimestamp", new NoArgSQLFunction("systimestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("uid", new NoArgSQLFunction("uid", Hibernate.INTEGER, false));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING, false));
        this.registerFunction("rowid", new NoArgSQLFunction("rowid", Hibernate.LONG, false));
        this.registerFunction("rownum", new NoArgSQLFunction("rownum", Hibernate.LONG, false));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "", "||", ""));
        this.registerFunction("instr", new StandardSQLFunction("instr", Hibernate.INTEGER));
        this.registerFunction("instrb", new StandardSQLFunction("instrb", Hibernate.INTEGER));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", Hibernate.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", Hibernate.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", Hibernate.STRING));
        this.registerFunction("substr", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("substrb", new StandardSQLFunction("substrb", Hibernate.STRING));
        this.registerFunction("translate", new StandardSQLFunction("translate", Hibernate.STRING));
        this.registerFunction("substring", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("locate", new SQLFunctionTemplate(Hibernate.INTEGER, "instr(?2,?1)"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "vsize(?1)*8"));
        this.registerFunction("coalesce", new NvlFunction());
        this.registerFunction("atan2", new StandardSQLFunction("atan2", Hibernate.FLOAT));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.INTEGER));
        this.registerFunction("mod", new StandardSQLFunction("mod", Hibernate.INTEGER));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
        this.registerFunction("nvl2", new StandardSQLFunction("nvl2"));
        this.registerFunction("power", new StandardSQLFunction("power", Hibernate.FLOAT));
        this.registerFunction("add_months", new StandardSQLFunction("add_months", Hibernate.DATE));
        this.registerFunction("months_between", new StandardSQLFunction("months_between", Hibernate.FLOAT));
        this.registerFunction("next_day", new StandardSQLFunction("next_day", Hibernate.DATE));
        this.registerFunction("str", new StandardSQLFunction("to_char", Hibernate.STRING));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String string) {
        return "select " + this.getSelectSequenceNextValString(string) + " from dual";
    }

    public String getSelectSequenceNextValString(String string) {
        return string + ".nextval";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, boolean bl) {
        string = string.trim();
        boolean bl2 = false;
        if (string.toLowerCase().endsWith(" for update")) {
            string = string.substring(0, string.length() - 11);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        if (bl) {
            stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            stringBuffer.append("select * from ( ");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            stringBuffer.append(" ) where rownum <= ?");
        }
        if (bl2) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString() + " of " + string;
    }

    public String getForUpdateNowaitString(String string) {
        return this.getForUpdateString() + " of " + string + " nowait";
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select sequence_name from user_sequences";
    }

    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        if (this.oracletypes_cursor_value == 0) {
            try {
                Class clazz = ReflectHelper.classForName("oracle.jdbc.driver.OracleTypes");
                this.oracletypes_cursor_value = clazz.getField("CURSOR").getInt(clazz.newInstance());
            }
            catch (Exception exception) {
                throw new HibernateException("Problem while trying to load or access OracleTypes.CURSOR value", exception);
            }
        }
        callableStatement.registerOutParameter(n, this.oracletypes_cursor_value);
        return ++n;
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        callableStatement.execute();
        return (ResultSet)callableStatement.getObject(1);
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String string) {
        String string2 = super.generateTemporaryTableName(string);
        return string2.length() > 30 ? string2.substring(1, 30) : string2;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit delete rows";
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select systimestamp from dual";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }
}

