/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.StandardSQLFunction;

public class MimerSQLDialect
extends Dialect {
    private static final int NATIONAL_CHAR_LENGTH = 2000;
    private static final int BINARY_MAX_LENGTH = 2000;

    public MimerSQLDialect() {
        this.registerColumnType(-7, "ODBC.BIT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "ODBC.TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "NCHAR(1)");
        this.registerColumnType(12, 2000, "NATIONAL CHARACTER VARYING($l)");
        this.registerColumnType(12, "NCLOB($l)");
        this.registerColumnType(-1, "CLOB($1)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, 2000, "BINARY VARYING($l)");
        this.registerColumnType(-3, "BLOB($1)");
        this.registerColumnType(-4, "BLOB($1)");
        this.registerColumnType(-2, 2000, "BINARY");
        this.registerColumnType(-2, "BLOB($1)");
        this.registerColumnType(2, "NUMERIC(19, $l)");
        this.registerColumnType(2004, "BLOB($l)");
        this.registerColumnType(2005, "NCLOB($l)");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("dacos", new StandardSQLFunction("dacos", Hibernate.DOUBLE));
        this.registerFunction("acos", new StandardSQLFunction("dacos", Hibernate.DOUBLE));
        this.registerFunction("dasin", new StandardSQLFunction("dasin", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("dasin", Hibernate.DOUBLE));
        this.registerFunction("datan", new StandardSQLFunction("datan", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("datan", Hibernate.DOUBLE));
        this.registerFunction("datan2", new StandardSQLFunction("datan2", Hibernate.DOUBLE));
        this.registerFunction("atan2", new StandardSQLFunction("datan2", Hibernate.DOUBLE));
        this.registerFunction("dcos", new StandardSQLFunction("dcos", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("dcos", Hibernate.DOUBLE));
        this.registerFunction("dcot", new StandardSQLFunction("dcot", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("dcot", Hibernate.DOUBLE));
        this.registerFunction("ddegrees", new StandardSQLFunction("ddegrees", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("ddegrees", Hibernate.DOUBLE));
        this.registerFunction("dexp", new StandardSQLFunction("dexp", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("dexp", Hibernate.DOUBLE));
        this.registerFunction("dlog", new StandardSQLFunction("dlog", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("dlog", Hibernate.DOUBLE));
        this.registerFunction("dlog10", new StandardSQLFunction("dlog10", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("dlog10", Hibernate.DOUBLE));
        this.registerFunction("dradian", new StandardSQLFunction("dradian", Hibernate.DOUBLE));
        this.registerFunction("radian", new StandardSQLFunction("dradian", Hibernate.DOUBLE));
        this.registerFunction("dsin", new StandardSQLFunction("dsin", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("dsin", Hibernate.DOUBLE));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("dsqrt", new StandardSQLFunction("dsqrt", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("dsqrt", Hibernate.DOUBLE));
        this.registerFunction("dtan", new StandardSQLFunction("dtan", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("dtan", Hibernate.DOUBLE));
        this.registerFunction("dpower", new StandardSQLFunction("dpower"));
        this.registerFunction("power", new StandardSQLFunction("dpower"));
        this.registerFunction("date", new StandardSQLFunction("date", Hibernate.DATE));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("time", new StandardSQLFunction("time", Hibernate.TIME));
        this.registerFunction("timestamp", new StandardSQLFunction("timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("week", new StandardSQLFunction("week", Hibernate.INTEGER));
        this.registerFunction("varchar", new StandardSQLFunction("varchar", Hibernate.STRING));
        this.registerFunction("real", new StandardSQLFunction("real", Hibernate.FLOAT));
        this.registerFunction("bigint", new StandardSQLFunction("bigint", Hibernate.LONG));
        this.registerFunction("char", new StandardSQLFunction("char", Hibernate.CHARACTER));
        this.registerFunction("integer", new StandardSQLFunction("integer", Hibernate.INTEGER));
        this.registerFunction("smallint", new StandardSQLFunction("smallint", Hibernate.SHORT));
        this.registerFunction("ascii_char", new StandardSQLFunction("ascii_char", Hibernate.CHARACTER));
        this.registerFunction("ascii_code", new StandardSQLFunction("ascii_code", Hibernate.STRING));
        this.registerFunction("unicode_char", new StandardSQLFunction("unicode_char", Hibernate.LONG));
        this.registerFunction("unicode_code", new StandardSQLFunction("unicode_code", Hibernate.STRING));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", Hibernate.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "50");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String string) {
        return "select next_value of " + string + " from system.onerow";
    }

    public String getCreateSequenceString(String string) {
        return "create unique sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string + " restrict";
    }

    public boolean supportsLimit() {
        return false;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public String getQuerySequencesString() {
        return "select sequence_schema || '.' || sequence_name from information_schema.ext_sequences";
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }
}

