/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.StringHelper;

public class InformixDialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            int n;
            String string = null;
            int n2 = JDBCExceptionHelper.extractErrorCode(sQLException);
            if (n2 == -268) {
                string = this.extractUsingTemplate("Unique constraint (", ") violated.", sQLException.getMessage());
            } else if (n2 == -691) {
                string = this.extractUsingTemplate("Missing key in referenced table for referential constraint (", ").", sQLException.getMessage());
            } else if (n2 == -692) {
                string = this.extractUsingTemplate("Key value for constraint (", ") is still being referenced.", sQLException.getMessage());
            }
            if (string != null && (n = string.indexOf(46)) != -1) {
                string = string.substring(n + 1);
            }
            return string;
        }
    };

    public InformixDialect() {
        this.registerColumnType(-5, "int8");
        this.registerColumnType(-2, "byte");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(8, "float");
        this.registerColumnType(6, "smallfloat");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "blob");
        this.registerColumnType(-1, "clob");
        this.registerColumnType(2, "decimal");
        this.registerColumnType(7, "smallfloat");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(93, "datetime year to fraction(5)");
        this.registerColumnType(92, "datetime hour to second");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "byte");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(12, 255, "varchar($l)");
        this.registerColumnType(12, 32739, "lvarchar($l)");
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString(String string, String string2, int n) throws MappingException {
        return n == -5 ? "select dbinfo('serial8') from systables where tabid=1" : "select dbinfo('sqlca.sqlerrd1') from systables where tabid=1";
    }

    public String getIdentityColumnString(int n) throws MappingException {
        return n == -5 ? "serial8 not null" : "serial not null";
    }

    public boolean hasDataTypeInIdentityColumn() {
        return false;
    }

    public String getAddForeignKeyConstraintString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(" add constraint ").append(" foreign key (").append(StringHelper.join(", ", stringArray)).append(") references ").append(string2);
        if (!bl) {
            stringBuffer.append(" (").append(StringHelper.join(", ", stringArray2)).append(')');
        }
        stringBuffer.append(" constraint ").append(string);
        return stringBuffer.toString();
    }

    public String getAddPrimaryKeyConstraintString(String string) {
        return " add constraint primary key constraint " + string + " ";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string + " restrict";
    }

    public String getSequenceNextValString(String string) {
        return "select " + this.getSelectSequenceNextValString(string) + " from systables where tabid=1";
    }

    public String getSelectSequenceNextValString(String string) {
        return string + ".nextval";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getLimitString(String string, int n, int n2) {
        if (n > 0) {
            throw new UnsupportedOperationException("informix has no offset");
        }
        return new StringBuffer(string.length() + 8).append(string).insert(string.toLowerCase().indexOf("select") + 6, " first " + n2).toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select distinct current timestamp from informix.systables";
    }
}

